/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.FallbackAttribute;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionDetails;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetList;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class ArtifactReadableImpl
extends BaseId
implements ArtifactReadable {
    private final HashCollection<AttributeTypeToken, IAttribute<?>> attributes = new HashCollection();
    private final HashCollection<RelationTypeToken, ArtifactReadable> relationsSideA = new HashCollection();
    private final HashCollection<RelationTypeToken, ArtifactReadable> relationsSideB = new HashCollection();
    private final ArtifactTypeToken artifactType;
    private final BranchToken branch;
    private final ArtifactId view;
    private final QueryFactory queryFactory;
    private final ApplicabilityToken applicability;
    private final TransactionId txId;
    private final TransactionDetails latestTxDetails;
    private final ModificationType modType;
    private final HashCollection<AttributeId, ArtifactReadable> referenceAttributes = new HashCollection();
    private final HashCollection<AttributeTypeToken, ArtifactReadable> referenceAttributeByType = new HashCollection();
    private final GammaId gamma;

    public ArtifactReadableImpl(Long id, ArtifactTypeToken artifactType, BranchToken branch, ArtifactId view, ApplicabilityToken applicability, TransactionId txId, ModificationType modType, QueryFactory queryFactory) {
        super(id);
        this.artifactType = artifactType;
        this.branch = branch;
        this.view = view;
        this.applicability = applicability;
        this.txId = txId;
        this.latestTxDetails = new TransactionDetails(TransactionId.SENTINEL, branch, null, null, -1, ArtifactId.SENTINEL, Long.valueOf(-1L), ArtifactId.SENTINEL);
        this.modType = modType;
        this.queryFactory = queryFactory;
        this.gamma = GammaId.SENTINEL;
    }

    public ArtifactReadableImpl(Long id, ArtifactTypeToken artifactType, BranchToken branch, ArtifactId view, ApplicabilityId applicability, TransactionId txId, TransactionDetails txDetails, ModificationType modType, QueryFactory queryFactory, GammaId gamma) {
        super(id);
        this.artifactType = artifactType;
        this.branch = branch;
        this.view = view;
        this.applicability = ApplicabilityToken.valueOf((long)applicability.getId(), (String)"");
        this.txId = txId;
        this.latestTxDetails = new TransactionDetails(TransactionId.SENTINEL, branch, null, null, -1, ArtifactId.SENTINEL, Long.valueOf(-1L), ArtifactId.SENTINEL);
        this.modType = modType;
        this.queryFactory = queryFactory;
        this.gamma = gamma;
    }

    public ArtifactReadableImpl(Long id, ArtifactTypeToken artifactType, BranchToken branch, ArtifactId view, ApplicabilityToken applicability, TransactionId txId, TransactionDetails txDetails, ModificationType modType, QueryFactory queryFactory) {
        super(id);
        this.artifactType = artifactType;
        this.branch = branch;
        this.view = view;
        this.applicability = applicability;
        this.txId = txId;
        this.latestTxDetails = txDetails;
        this.modType = modType;
        this.queryFactory = queryFactory;
        this.gamma = GammaId.SENTINEL;
    }

    public String getName() {
        if (this.attributes.isEmpty()) {
            return "Name not loaded";
        }
        return (String)this.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name);
    }

    public BranchToken getBranch() {
        return this.branch;
    }

    public TransactionId getTransaction() {
        return this.txId;
    }

    public ModificationType getModificationType() {
        return this.modType;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public TransactionId getLastModifiedTransaction() {
        return TransactionId.SENTINEL;
    }

    public int getAttributeCount(AttributeTypeToken type) {
        return this.attributes.sizeByKey((Object)type);
    }

    public int getAttributeCount(AttributeTypeToken type, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public Collection<AttributeTypeToken> getValidAttributeTypes() {
        throw new UnsupportedOperationException();
    }

    public Collection<AttributeTypeToken> getExistingAttributeTypes() {
        return this.attributes.keySet();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType) {
        List<T> values = this.getAttributeValues(attributeType);
        this.ensureSole(attributeType, values);
        return values.iterator().next();
    }

    private void ensureSole(AttributeTypeToken attributeType, Collection<?> values) {
        if (values == null || values.size() < 1) {
            throw new AttributeDoesNotExist("Attribute of type [%s] could not be found on [%s]", new Object[]{attributeType, this.getIdString()});
        }
        this.ensureNotMoreThanOne(attributeType, values.size());
    }

    private void ensureNotMoreThanOne(AttributeTypeToken attributeType, int size) {
        if (size > 1) {
            throw new MultipleAttributesExist("[%s] attributes of type [%s] on [%s], but only 1 instance is allowed", new Object[]{attributeType, size, this.getIdString()});
        }
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, DeletionFlag flag, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, T defaultValue) {
        List<T> values = this.getAttributeValues(attributeType);
        this.ensureNotMoreThanOne(attributeType, values.size());
        if (values.size() == 1) {
            T value = values.iterator().next();
            return value == null ? defaultValue : value;
        }
        return defaultValue;
    }

    public <T> IAttribute<T> getSoleAttribute(AttributeTypeToken attributeType) {
        List values = (List)this.attributes.getValues((Object)attributeType);
        this.ensureNotMoreThanOne(attributeType, values.size());
        if (values.size() == 1) {
            IAttribute value = (IAttribute)values.iterator().next();
            return value;
        }
        throw new AttributeDoesNotExist("Attribute of type [%s] could not be found on [%s]", new Object[]{attributeType, this.getIdString()});
    }

    public <T> IAttribute<T> getSoleAttribute(AttributeTypeToken attributeType, T defaultValue) {
        List values = this.attributes.getValues((Object)attributeType) != null ? (List)this.attributes.getValues((Object)attributeType) : Collections.emptyList();
        this.ensureNotMoreThanOne(attributeType, values.size());
        if (values.size() == 1) {
            IAttribute value = (IAttribute)values.iterator().next();
            FallbackAttribute defaultVal = new FallbackAttribute((value.getId() == Id.SENTINEL ? Long.valueOf(Id.SENTINEL) : value.getId()).longValue(), attributeType, value.getGammaId(), defaultValue);
            return value.getValue() == null ? defaultVal : value;
        }
        return new FallbackAttribute(Long.valueOf(Id.SENTINEL).longValue(), attributeType, defaultValue);
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeType) {
        return this.getSoleAttributeValue(attributeType).toString();
    }

    public String getSoleAttributeAsString(AttributeTypeToken attributeType, String defaultValue) {
        Object value = this.getSoleAttributeValue(attributeType, null);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public AttributeId getSoleAttributeId(AttributeTypeToken attributeType) {
        List list = (List)this.attributes.getValues((Object)attributeType);
        this.ensureNotMoreThanOne(attributeType, list.size());
        return (AttributeId)list.iterator().next();
    }

    public Long getSoleAttributeId(AttributeTypeToken attributeType, Long defaultValue) {
        List list = (List)this.attributes.getValues((Object)attributeType);
        if (list == null) {
            return defaultValue;
        }
        this.ensureNotMoreThanOne(attributeType, list.size());
        return ((IAttribute)list.iterator().next()).getId();
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType) {
        if (this.attributes.isEmpty()) {
            throw new OseeStateException("attributes not loaded for artifact [%s]", new Object[]{this.getIdString()});
        }
        List values = (List)this.attributes.getValues((Object)attributeType);
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().map(IAttribute::getValue).collect(Collectors.toList());
    }

    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        if (this.attributes.isEmpty()) {
            throw new OseeStateException("attributes not loaded for artifact [%s]", new Object[]{this.getIdString()});
        }
        List values = this.getAttributes(attributeType, deletionFlag).getList();
        if (values.isEmpty()) {
            return null;
        }
        return values.stream().map(IAttribute::getValue).collect(Collectors.toList());
    }

    public void putAttributeValue(AttributeTypeGeneric<?> attributeType, IAttribute<?> attribute) {
        this.attributes.put(attributeType, attribute);
    }

    public void putRelation(RelationTypeToken relationType, RelationSide side, ArtifactReadable artifact) {
        (side.isSideA() ? this.relationsSideA : this.relationsSideB).put((Object)relationType, (Object)artifact);
    }

    public void putReferenceArtifact(AttributeId attrId, ArtifactReadable artifact) {
        this.referenceAttributes.put((Object)attrId, (Object)artifact);
        Optional<Map.Entry> findFirst = this.attributes.entrySet().stream().filter(a -> ((List)a.getValue()).stream().anyMatch(b -> b.getId().equals(attrId.getId()))).findFirst();
        if (findFirst.isPresent()) {
            this.referenceAttributeByType.put((Object)((AttributeTypeToken)findFirst.get().getKey()), (Object)artifact);
        }
    }

    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
        throw new UnsupportedOperationException();
    }

    public AttributeReadable<Object> getAttributeById(AttributeId attributeId) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes() {
        throw new UnsupportedOperationException();
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    public <T> List<IAttribute<T>> getAttributeList(AttributeTypeGeneric<T> attributeType) {
        List attributeOfType = (List)this.attributes.getValues(attributeType);
        if (attributeOfType == null) {
            return Collections.emptyList();
        }
        return attributeOfType.stream().map(x -> x).collect(Collectors.toList());
    }

    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    private <T> List<T> getEnumAttributeValues(AttributeTypeToken attributeType) {
        ArrayList<EnumToken> attributeValues = new ArrayList<EnumToken>();
        if (attributeType.isEnumerated()) {
            ArrayList<T> enumAttributeValues = new ArrayList<T>();
            AttributeTypeEnum attributeTypeEnum = (AttributeTypeEnum)attributeType;
            enumAttributeValues.addAll(this.getAttributeValues(attributeType));
            for (String s : enumAttributeValues) {
                attributeValues.add(attributeTypeEnum.valueFromStorageString(s));
            }
        }
        return attributeValues;
    }

    public <T> T getComputedCharacteristicValue(ComputedCharacteristicToken<T> computedCharacteristic) {
        ArrayList<T> attributeValues = new ArrayList<T>();
        if (!this.artifactType.isComputedCharacteristicValid(computedCharacteristic)) {
            throw new OseeCoreException("Attribute Types on Artifact Type %s do not have valid multiplicity for computed characteristic %s", new Object[]{this.artifactType.getName(), computedCharacteristic.getName()});
        }
        for (AttributeTypeGeneric attributeType : computedCharacteristic.getAttributeTypesToCompute()) {
            if (attributeType.isEnumerated()) {
                attributeValues.addAll(this.getEnumAttributeValues((AttributeTypeToken)attributeType));
                continue;
            }
            attributeValues.addAll(this.getAttributeValues((AttributeTypeToken)attributeType));
        }
        return (T)computedCharacteristic.calculate(attributeValues);
    }

    public int getMaximumRelationAllowed(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public Collection<RelationTypeToken> getValidRelationTypes() {
        throw new UnsupportedOperationException();
    }

    public Collection<RelationTypeToken> getExistingRelationTypes() {
        Set relATypes = this.relationsSideA.keySet();
        Set relBTypes = this.relationsSideB.keySet();
        HashSet<RelationTypeToken> rels = new HashSet<RelationTypeToken>();
        if (!relATypes.isEmpty()) {
            rels.addAll(relATypes);
        }
        if (!relBTypes.isEmpty()) {
            rels.addAll(relBTypes);
        }
        return rels;
    }

    public List<ArtifactReadable> getDescendants() {
        return this.queryFactory.fromBranch((BranchId)this.branch, this.view).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)this).asArtifacts();
    }

    public void getDescendants(List<ArtifactReadable> descendants) {
        throw new UnsupportedOperationException();
    }

    public boolean isDescendantOf(ArtifactToken parent) {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactReadable> getChildren() {
        return this.getRelated(CoreRelationTypes.DefaultHierarchical_Child, ArtifactTypeToken.SENTINEL);
    }

    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide) {
        return new ResultSetList(this.getRelated(relationTypeSide, ArtifactTypeToken.SENTINEL));
    }

    public List<ArtifactReadable> getRelatedList(RelationTypeSide relationTypeSide) {
        return this.getRelated(relationTypeSide, ArtifactTypeToken.SENTINEL);
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType) {
        return this.getRelated(relationTypeSide, artifactType, DeletionFlag.EXCLUDE_DELETED);
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeToken artifactType, DeletionFlag deletionFlag) {
        List related = (List)(relationTypeSide.getSide().isSideA() ? this.relationsSideA : this.relationsSideB).getValues((Object)relationTypeSide.getRelationType());
        if (related == null) {
            return Collections.emptyList();
        }
        Predicate<ArtifactReadable> filter = artifact -> this.modType.isIncluded(deletionFlag) && (artifactType.isInvalid() || artifact.getArtifactType().inheritsFrom((ArtifactTypeId)artifactType));
        if (artifactType.isValid() || deletionFlag.equals((Object)DeletionFlag.EXCLUDE_DELETED)) {
            return related.stream().filter(filter).collect(Collectors.toList());
        }
        return related;
    }

    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, DeletionFlag deletionFlag) {
        return this.getRelated(relationTypeSide, ArtifactTypeToken.SENTINEL, deletionFlag);
    }

    public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable artifact) {
        return this.getRelated(typeAndSide, ArtifactTypeToken.SENTINEL).contains(artifact);
    }

    public int getRelatedCount(RelationTypeSide typeAndSide) {
        return this.getRelated(typeAndSide, ArtifactTypeToken.SENTINEL).size();
    }

    public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) {
        throw new UnsupportedOperationException();
    }

    public ResultSet<IRelationLink> getRelations(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    public Collection<ArtifactId> getChildrenIds() {
        throw new UnsupportedOperationException();
    }

    public List<ArtifactId> getRelatedIds(RelationTypeSide relationTypeSide) {
        List<ArtifactReadable> relatedList = this.getRelatedList(relationTypeSide);
        return relatedList.stream().map(p -> ArtifactId.valueOf((Long)p.getId())).collect(Collectors.toList());
    }

    public boolean isHistorical() {
        return false;
    }

    public ApplicabilityToken getApplicabilityToken() {
        return this.applicability;
    }

    public ApplicabilityId getApplicability() {
        return ApplicabilityId.valueOf((Long)this.applicability.getId());
    }

    public List<String> fetchAttributesAsStringList(AttributeTypeToken attributeType) {
        ArrayList<String> items = new ArrayList<String>();
        List attributeValues = this.getAttributeValues(attributeType);
        for (Object object : attributeValues) {
            items.add(object.toString());
        }
        return items;
    }

    public String getSafeName() {
        return this.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name, DeletionFlag.INCLUDE_DELETED, "Unknown Name: " + this.getIdString());
    }

    public HashCollection<AttributeTypeToken, IAttribute<?>> getAttributesHashCollection() {
        return this.attributes;
    }

    public GammaId getGamma() {
        return this.gamma != GammaId.SENTINEL ? this.gamma : GammaId.SENTINEL;
    }

    public TransactionDetails getTxDetails() {
        return this.latestTxDetails;
    }

    public List<ArtifactReadable> getReferenceArtifactsByType(AttributeTypeToken attributeType) {
        List values = (List)this.referenceAttributeByType.getValues((Object)attributeType);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    public ArtifactReadable getReferenceArtifactByAttrId(AttributeId attributeId) {
        if (this.referenceAttributes.containsKey((Object)attributeId)) {
            return (ArtifactReadable)((List)this.referenceAttributes.getValues((Object)attributeId)).get(0);
        }
        return ArtifactReadable.SENTINEL;
    }
}

