/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.templatemanager;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingTemplateRequest
implements ToMessage {
    private @NonNull Boolean byOptions;
    private @Nullable FormatIndicator formatIndicator;
    private @Nullable String option;
    private @Nullable String presentationType;
    private @Nullable String publishArtifactTypeName;
    private @Nullable String rendererId;
    private @Nullable String templateId;

    public PublishingTemplateRequest() {
        this.byOptions = true;
        this.rendererId = null;
        this.publishArtifactTypeName = null;
        this.presentationType = null;
        this.option = null;
        this.formatIndicator = null;
    }

    @JsonIgnore
    public PublishingTemplateRequest(@NonNull String rendererId, @Nullable String publishArtifactTypeName, @NonNull String presentationType, @Nullable String option, @Nullable FormatIndicator formatIndicator) {
        this.byOptions = true;
        this.rendererId = Strings.isValidAndNonBlank((String)rendererId) ? rendererId : null;
        this.publishArtifactTypeName = Strings.isValidAndNonBlank((String)publishArtifactTypeName) ? publishArtifactTypeName : null;
        this.presentationType = Strings.isValidAndNonBlank((String)presentationType) ? presentationType : null;
        this.option = Strings.isValidAndNonBlank((String)option) ? option : null;
        this.formatIndicator = Objects.nonNull(formatIndicator) ? formatIndicator : FormatIndicator.WORD_ML;
        this.templateId = null;
        if (Objects.isNull(this.rendererId) || Objects.isNull(this.presentationType)) {
            throw new IllegalArgumentException();
        }
    }

    @JsonIgnore
    public PublishingTemplateRequest(@NonNull String templateId, FormatIndicator formatIndicator) {
        this.byOptions = false;
        this.option = null;
        this.presentationType = null;
        this.publishArtifactTypeName = null;
        this.rendererId = null;
        this.formatIndicator = formatIndicator;
        this.templateId = Objects.requireNonNull(templateId);
    }

    public @Nullable FormatIndicator getFormatIndicator() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getOption, the member \"byOptions\" has not been set.");
        }
        return this.formatIndicator;
    }

    public @Nullable String getOption() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getOption, the member \"byOptions\" has not been set.");
        }
        return this.option;
    }

    public @Nullable String getPresentationType() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.presentationType) && this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getPresentationType, the member \"presentationType\" has not been set.");
        }
        return this.presentationType;
    }

    public @Nullable String getPublishArtifactTypeName() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        return this.publishArtifactTypeName;
    }

    public @Nullable String getRendererId() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.rendererId) && this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getRendererId, the member \"rendererId\" has not been set.");
        }
        return this.rendererId;
    }

    public @Nullable String getTemplateId() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"byOptions\" has not been set.");
        }
        if (Objects.isNull(this.templateId) && !this.byOptions.booleanValue()) {
            throw new IllegalStateException("PublishingTemplateRequest::getTemplateId, the member \"templateId\" has not been set.");
        }
        return this.templateId;
    }

    public boolean isByOptions() {
        if (Objects.isNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::isByOptions, the member \"byOptions\" has not been set.");
        }
        return this.byOptions;
    }

    @JsonIgnore
    public boolean isValid() {
        if (Objects.isNull(this.byOptions)) {
            return false;
        }
        if (this.byOptions.booleanValue()) {
            return this.presentationType != null && !this.presentationType.isBlank() && Strings.isValidAndNonBlank((String)this.rendererId) && Objects.nonNull(this.formatIndicator) && Objects.isNull(this.templateId);
        }
        return Objects.isNull(this.option) && Objects.isNull(this.presentationType) && Objects.isNull(this.publishArtifactTypeName) && Objects.isNull(this.rendererId) && Objects.nonNull(this.formatIndicator) && Strings.isValidAndNonBlank((String)this.templateId);
    }

    public void setByOption(Boolean byOptions) {
        if (Objects.nonNull(this.byOptions)) {
            throw new IllegalStateException("PublishingTemplateRequest::setByOptions, member \"byOptions\" has already been set.");
        }
        this.byOptions = Objects.requireNonNull(byOptions, "PublishingTemplateRequset::setByOptions, parameter \"byOptions\" cannot be null.");
    }

    public void setFormatIndicator(FormatIndicator formatIndicator) {
        if (Objects.nonNull(this.formatIndicator)) {
            throw new IllegalStateException("PublishingTemplateRequest::setFormatIndicator, member \"formatIndicator\" has already been set.");
        }
        this.formatIndicator = formatIndicator;
    }

    public void setOption(String option) {
        if (Objects.nonNull(this.option)) {
            throw new IllegalStateException("PublishingTemplateRequest::setOption, member \"option\" has already been set.");
        }
        this.option = option;
    }

    public void setPresentationType(String presentationType) {
        if (Objects.nonNull(this.presentationType)) {
            throw new IllegalStateException("PublishingTemplateRequest::setPresentationType, member \"presentationType\" has already been set.");
        }
        this.presentationType = presentationType;
    }

    public void setPublishArtifactTypeName(String publishArtifactTypeName) {
        if (Objects.nonNull(this.publishArtifactTypeName)) {
            throw new IllegalStateException("PublishingTemplateRequest::setPublishArtifactTypeName, member \"publishArtifactTypeName\" has already been set.");
        }
        this.publishArtifactTypeName = publishArtifactTypeName;
    }

    public void setRendererId(String rendererId) {
        if (Objects.nonNull(this.rendererId)) {
            throw new IllegalStateException("PublishingTemplateRequest::setRendererId, member \"rendererId\" has already been set.");
        }
        this.rendererId = rendererId;
    }

    public void setTemplateId(String templateId) {
        if (Objects.nonNull(this.templateId)) {
            throw new IllegalStateException("PublishingTemplateRequest::setTemplateId, member \"templateId\" has already been set.");
        }
        this.templateId = templateId;
    }

    @JsonIgnore
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Publishing Template Request:").indentInc();
        if (Objects.isNull(this.byOptions)) {
            return outMessage.title((CharSequence)"IllegalState, member \"byOptions\" is null.").indentInc().segment((CharSequence)"Renderer Identifier", (Object)this.rendererId).segment((CharSequence)"Publish Artifact Type Name", (Object)this.publishArtifactTypeName).segment((CharSequence)"Presentation Type", (Object)this.presentationType).segment((CharSequence)"Option", (Object)this.option).segment((CharSequence)"Template Identifier", (Object)this.templateId).segmentToMessage((ToMessage)this.formatIndicator).indentDec().indentDec();
        }
        if (this.byOptions.booleanValue()) {
            return outMessage.title((CharSequence)"Publishing Template Requset is by options.").indentInc().segment((CharSequence)"Renderer Identifier", (Object)this.rendererId).segment((CharSequence)"Publish Artifact Type Name", (Object)this.publishArtifactTypeName).segment((CharSequence)"Presentation Type", (Object)this.presentationType).segment((CharSequence)"Option", (Object)this.option).segmentToMessage((ToMessage)this.formatIndicator).indentDec().indentDec();
        }
        return outMessage.title((CharSequence)"Publishing Template Request is by template identifier.").indentInc().segment((CharSequence)"Template Identifier", (Object)this.templateId).segmentToMessage((ToMessage)this.formatIndicator).indentDec().indentDec();
    }

    @JsonIgnore
    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

