/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.publishing;

import java.util.List;
import java.util.Objects;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.publishing.RendererMap;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class PublishingRequestData
implements ToMessage {
    private List<ArtifactId> artifactIds;
    RendererMap publishingRendererOptions;
    private PublishingTemplateRequest publishingTemplateRequest;
    private String desktopClientLoopbackUrl;

    public PublishingRequestData() {
        this.publishingTemplateRequest = null;
        this.artifactIds = null;
        this.publishingRendererOptions = null;
        this.desktopClientLoopbackUrl = "";
    }

    public PublishingRequestData(PublishingTemplateRequest publishingTemplateRequest, RendererMap publishingRendererOptions, List<ArtifactId> artifactIds) {
        this.publishingTemplateRequest = Objects.requireNonNull(publishingTemplateRequest, "PublishingRequest::new, parameter \"publishingTemplateRequest\" cannot be null.");
        this.publishingRendererOptions = Objects.requireNonNull(publishingRendererOptions, "PublishingRequest::new, parameter \"publishingRendererOptions\" cannot be null.");
        this.artifactIds = Objects.requireNonNull(artifactIds, "MsWordPreviewTemplate::new, parameter \"artifactIds\" cannot be null.");
        this.desktopClientLoopbackUrl = "";
    }

    public PublishingRequestData(PublishingTemplateRequest publishingTemplateRequest, RendererMap publishingRendererOptions, List<ArtifactId> artifactIds, String desktopClientLoopbackUrl) {
        this.publishingTemplateRequest = Objects.requireNonNull(publishingTemplateRequest, "PublishingRequest::new, parameter \"publishingTemplateRequest\" cannot be null.");
        this.publishingRendererOptions = Objects.requireNonNull(publishingRendererOptions, "PublishingRequest::new, parameter \"publishingRendererOptions\" cannot be null.");
        this.artifactIds = Objects.requireNonNull(artifactIds, "MsWordPreviewTemplate::new, parameter \"artifactIds\" cannot be null.");
        this.desktopClientLoopbackUrl = desktopClientLoopbackUrl != null ? desktopClientLoopbackUrl : "";
    }

    public boolean isValid() {
        return Objects.nonNull(this.publishingTemplateRequest) && this.publishingTemplateRequest.isValid() && Objects.nonNull(this.publishingRendererOptions) && Objects.nonNull(this.artifactIds) && !this.artifactIds.isEmpty();
    }

    public List<ArtifactId> getArtifactIds() {
        if (Objects.isNull(this.artifactIds)) {
            throw new IllegalStateException();
        }
        return this.artifactIds;
    }

    public RendererMap getPublishingRendererOptions() {
        if (Objects.isNull(this.publishingRendererOptions)) {
            throw new IllegalStateException();
        }
        return this.publishingRendererOptions;
    }

    public PublishingTemplateRequest getPublishingTemplateRequest() {
        if (Objects.isNull(this.publishingTemplateRequest)) {
            throw new IllegalStateException();
        }
        return this.publishingTemplateRequest;
    }

    public String getDesktopClientLoopbackUrl() {
        if (Objects.isNull(this.desktopClientLoopbackUrl)) {
            throw new IllegalStateException("Desktop client loopback URL has not been set.");
        }
        return this.desktopClientLoopbackUrl;
    }

    public void setDesktopClientLoopbackUrl(String desktopClientLoopbackUrl) {
        this.desktopClientLoopbackUrl = desktopClientLoopbackUrl != null ? desktopClientLoopbackUrl : "";
    }

    public void setArtifactIds(List<ArtifactId> artifactIds) {
        if (Objects.nonNull(this.artifactIds)) {
            throw new IllegalStateException();
        }
        this.artifactIds = Objects.requireNonNull(artifactIds, "MsWordPreviewTemplate::new, parameter \"artifactIds\" cannot be null.");
    }

    public void setPublishingRendererOptions(RendererMap publishingRendererOptions) {
        if (Objects.nonNull(this.publishingRendererOptions)) {
            throw new IllegalStateException();
        }
        this.publishingRendererOptions = Objects.requireNonNull(publishingRendererOptions, "PublishingRequest::new, parameter \"publishingRendererOptions\" cannot be null.");
    }

    public void setPublishingTemplateRequest(PublishingTemplateRequest publishingTemplateRequest) {
        if (Objects.nonNull(this.publishingTemplateRequest)) {
            throw new IllegalStateException();
        }
        this.publishingTemplateRequest = Objects.requireNonNull(publishingTemplateRequest, "PublishingRequest::new, parameter \"publishingTemplateRequest\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)this.getClass().getSimpleName()).indentInc().segment((CharSequence)"Artifacts", this.artifactIds).toMessage((ToMessage)this.publishingTemplateRequest).toMessage((ToMessage)this.publishingRendererOptions).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

