/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.importing;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.osee.define.rest.api.importing.ReqNumbering;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.api.importing.RoughAttributeSet;
import org.eclipse.osee.define.rest.api.importing.RoughRelation;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class RoughArtifact {
    private RoughArtifact roughParent;
    private ReqNumbering number;
    private String guid;
    private RoughArtifactKind roughArtifactKind;
    private final RoughAttributeSet attributes;
    private final Collection<RoughArtifact> children;
    private final Collection<RoughRelation> directRelations;
    private ArtifactTypeToken primaryArtifactType;
    private ArtifactTypeToken type = ArtifactTypeToken.SENTINEL;
    private final XResultData results;
    private final OrcsApi orcsApi;

    public RoughArtifact(OrcsApi orcsApi, XResultData results, RoughArtifactKind roughArtifactKind, String name) {
        this.attributes = new RoughAttributeSet();
        this.children = new ArrayList<RoughArtifact>();
        this.directRelations = new ArrayList<RoughRelation>();
        this.roughArtifactKind = roughArtifactKind;
        this.results = results;
        this.orcsApi = orcsApi;
        this.setName(name);
    }

    public RoughArtifact(OrcsApi orcsApi, XResultData results, ArtifactTypeToken type, String name) {
        this.attributes = new RoughAttributeSet();
        this.children = new ArrayList<RoughArtifact>();
        this.directRelations = new ArrayList<RoughRelation>();
        this.roughArtifactKind = RoughArtifactKind.TYPESET;
        this.type = type;
        this.results = results;
        this.orcsApi = orcsApi;
        this.setName(name);
    }

    public RoughArtifact(OrcsApi orcsApi, XResultData results, RoughArtifactKind roughArtifactKind) {
        this(orcsApi, results, roughArtifactKind, "unnamed");
    }

    public void setName(String name) {
        this.attributes.setAttribute(CoreAttributeTypes.Name.getName(), name);
    }

    public void clear() {
        this.attributes.clear();
        this.children.clear();
        this.guid = null;
        this.number = null;
        this.roughParent = null;
        this.primaryArtifactType = null;
    }

    public Set<String> getAttributeTypeNames() {
        return this.attributes.getAttributeTypeNames();
    }

    public boolean hasHierarchicalRelation() {
        return this.number != null;
    }

    public void addChild(RoughArtifact child) {
        child.roughParent = this;
        this.children.add(child);
    }

    public void addDirectRelation(RoughRelation relation) {
        this.directRelations.add(relation);
    }

    public Collection<RoughRelation> getDirectRelations() {
        return this.directRelations;
    }

    public boolean hasParent() {
        return this.roughParent != null;
    }

    public RoughArtifact getRoughParent() {
        return this.roughParent;
    }

    public void addAttribute(AttributeTypeToken attrType, String value) {
        this.addAttribute(attrType.getName(), value);
    }

    public void setAttribute(String typeName, String value) {
        this.attributes.setAttribute(typeName, value);
    }

    public void addAttribute(String typeName, String value) {
        if (Strings.isValid((String)value)) {
            if (this.orcsApi.tokenService().getAttributeType(typeName).isEnumerated()) {
                if (this.isMultipleEnum(typeName, value)) {
                    this.attributes.addAttribute(typeName, this.getEnumValues(value));
                } else {
                    this.attributes.addAttribute(typeName, value.trim());
                }
            } else {
                this.attributes.addAttribute(typeName, value);
            }
        }
    }

    public void addAttribute(String name, URI uri) {
        this.attributes.addAttribute(name, uri);
    }

    public void addAttribute(AttributeTypeToken attributeType, URI uri) {
        this.addAttribute(attributeType.getName(), uri);
    }

    public Collection<URI> getURIAttributes() {
        return this.attributes.getURIAttributes();
    }

    private String[] getEnumValues(String value) {
        String[] data = value.split(",");
        int index = 0;
        while (index < data.length) {
            data[index] = data[index].trim();
            ++index;
        }
        return data;
    }

    private boolean isMultipleEnum(String typeName, String value) {
        boolean result = false;
        try {
            AttributeTypeGeneric attributeType = this.orcsApi.tokenService().getAttributeType(typeName);
            if (attributeType.isEnumerated() && this.type.getMax((AttributeTypeToken)attributeType) > 1 && value.contains(",")) {
                result = true;
            }
        }
        catch (OseeCoreException ex) {
            this.results.errorf(ex.toString(), new Object[0]);
        }
        return result;
    }

    public boolean isChild(RoughArtifact otherArtifact) {
        return this.number.isChild(otherArtifact.number);
    }

    public String toString() {
        return this.getName();
    }

    public void setSectionNumber(String number) {
        this.number = new ReqNumbering(number);
    }

    public ReqNumbering getSectionNumber() {
        return this.number;
    }

    public RoughAttributeSet getAttributes() {
        return this.attributes;
    }

    public Collection<RoughArtifact> getChildren() {
        return this.children;
    }

    public Collection<RoughArtifact> getDescendants() {
        ArrayList<RoughArtifact> decendants = new ArrayList<RoughArtifact>();
        for (RoughArtifact child : this.getChildren()) {
            if (!this.equals(child.roughParent)) continue;
            decendants.add(child);
        }
        return decendants;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGuid() {
        return this.guid;
    }

    public RoughArtifactKind getRoughArtifactKind() {
        return this.roughArtifactKind;
    }

    public void setRoughArtifactKind(RoughArtifactKind roughArtifactKind) {
        this.roughArtifactKind = roughArtifactKind;
    }

    public String getName() {
        return this.attributes.getSoleAttributeValue(CoreAttributeTypes.Name.getName());
    }

    public String getRoughAttribute(String attributeName) {
        return this.attributes.getSoleAttributeValue(attributeName);
    }

    public Collection<String> getRoughAttributeAsList(String attributeName) {
        return this.attributes.getAttributeValueList(attributeName);
    }

    public ArtifactTypeToken getPrimaryArtifactType() {
        return this.primaryArtifactType;
    }

    public void setPrimaryArtifactType(ArtifactTypeToken primaryArtifactType) {
        this.primaryArtifactType = primaryArtifactType;
    }

    public ArtifactTypeToken getType() {
        return this.type;
    }

    public void setType(ArtifactTypeToken type) {
        this.type = type;
    }

    public XResultData getResults() {
        return this.results;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public void deleteAttribute(String typeName) {
        this.attributes.deleteAttribute(typeName);
    }
}

