/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.util.XmlUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.HtmlUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerWidget;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class XViewerTextWidget
extends XViewerWidget {
    protected StyledText sText;
    private Composite parent;
    protected String text = "";
    private int maxTextChars = 0;
    private static final boolean debug = false;
    private int width = 0;
    private int height = 0;
    private Font font;

    public XViewerTextWidget() {
        super("AText", "text");
    }

    public XViewerTextWidget(String displayLabel) {
        this(displayLabel, "text");
    }

    public XViewerTextWidget(String displayLabel, String xmlRoot) {
        this(displayLabel, xmlRoot, "");
    }

    public XViewerTextWidget(String displayLabel, String xmlRoot, String xmlSubRoot) {
        super(displayLabel, xmlRoot, xmlSubRoot);
    }

    public void setEnabled(boolean enabled) {
        this.sText.setEnabled(enabled);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.sText != null && !this.sText.isDisposed()) {
            this.sText.setSize(width, height);
        }
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.sText != null && !this.sText.isDisposed()) {
            this.sText.setSize(this.sText.getSize().x, height);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.label) + ": *" + this.text + "*";
    }

    @Override
    public Control getControl() {
        return this.sText;
    }

    @Override
    public void createWidgets(Composite parent, int horizontalSpan) {
        this.createWidgets(parent, horizontalSpan, true);
    }

    public void createWidgets(Composite parent, int horizontalSpan, boolean fillText) {
        if (!this.verticalLabel && horizontalSpan < 2) {
            horizontalSpan = 2;
        }
        this.parent = parent;
        Composite composite = null;
        composite = this.createComposite(parent, horizontalSpan);
        this.createLabelWidget(composite);
        this.sText = this.fillVertically ? new StyledText(composite, 2882) : new StyledText(composite, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.verticalLabel ? horizontalSpan : horizontalSpan - 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        if (this.fillVertically) {
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
            if (this.height > 0) {
                gd.heightHint = this.height;
            }
        }
        this.sText.setLayoutData((Object)gd);
        this.sText.setMenu(this.getDefaultMenu());
        this.addModificationListener();
        if (this.text != null) {
            this.sText.setText(this.text);
        }
        if (this.width != 0 && this.height != 0) {
            this.sText.setSize(this.width, this.height);
        }
        if (this.maxTextChars > 0) {
            this.sText.setTextLimit(this.maxTextChars);
        }
        if (fillText) {
            this.updateTextWidget();
        }
        this.setLabelError();
        this.sText.setEditable(this.editable);
        if (this.font != null) {
            this.sText.setFont(this.font);
        }
        parent.layout();
    }

    private void addModificationListener() {
        this.sText.addListener(24, e -> {
            if (this.sText != null) {
                this.text = this.sText.getText();
                this.setLabelError();
                this.notifyXModifiedListeners();
            }
        });
    }

    private void createLabelWidget(Composite composite) {
        if (this.displayLabel && !this.label.equals("")) {
            this.labelWidget = new Label(composite, 0);
            this.labelWidget.setText(String.valueOf(this.label) + ":");
            if (this.toolTip != null) {
                this.labelWidget.setToolTipText(this.toolTip);
            }
        }
    }

    private Composite createComposite(Composite parent, int horizontalSpan) {
        Composite composite;
        if (this.fillVertically) {
            composite = new Composite(parent, 0);
            GridLayout layout = XViewerLib.getZeroMarginLayout(1, false);
            layout.verticalSpacing = 4;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
        } else {
            composite = new Composite(parent, 0);
            GridLayout layout = XViewerLib.getZeroMarginLayout(2, false);
            layout.verticalSpacing = 4;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalSpan = horizontalSpan;
            composite.setLayoutData((Object)gd);
        }
        return composite;
    }

    public String getText() {
        return this.sText.getText();
    }

    public void setText(String text) {
        this.text = text;
        if (this.sText != null) {
            this.sText.setText(text);
        }
    }

    public Menu getDefaultMenu() {
        Menu menu = new Menu((Control)this.sText.getShell());
        MenuItem cut = new MenuItem(menu, 0);
        cut.setText(XViewerText.get("menu.cut"));
        cut.addListener(13, e -> {
            this.sText.cut();
            this.sText.redraw();
        });
        MenuItem copy = new MenuItem(menu, 0);
        copy.setText(XViewerText.get("menu.copy"));
        copy.addListener(13, e -> this.sText.copy());
        MenuItem paste = new MenuItem(menu, 0);
        paste.setText(XViewerText.get("menu.paste"));
        paste.addListener(13, e -> {
            this.sText.paste();
            this.sText.redraw();
        });
        return menu;
    }

    @Override
    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.labelWidget != null) {
            this.labelWidget.dispose();
        }
        if (this.sText != null) {
            this.sText.dispose();
            this.sText = null;
        }
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.layout();
        }
    }

    @Override
    public void setFocus() {
        if (this.sText != null) {
            this.sText.setFocus();
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.sText != null && !this.sText.isDisposed()) {
            this.sText.setEditable(editable);
        }
    }

    public void setMaxTextLimit(int limit) {
        this.maxTextChars = limit;
        if (this.sText != null) {
            if (limit == 0) {
                this.sText.setTextLimit(999);
            } else {
                this.sText.setTextLimit(limit);
            }
        }
    }

    public void forceFocus() {
        if (this.sText != null) {
            this.sText.forceFocus();
        }
    }

    public boolean isInteger() {
        try {
            Integer.valueOf(this.text);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isFloat() {
        try {
            new Float(this.text);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public int getInteger() {
        Integer num;
        try {
            num = Integer.valueOf(this.text);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return num;
    }

    public double getFloat() {
        Double num;
        try {
            num = new Double(this.text);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
        return num;
    }

    @Override
    public void setRequiredEntry(boolean requiredEntry) {
        super.setRequiredEntry(requiredEntry);
        this.setLabelError();
    }

    public boolean requiredEntry() {
        return this.requiredEntry;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        if (this.sText != null) {
            this.sText.addModifyListener(modifyListener);
        }
    }

    public String get() {
        return this.text;
    }

    @Override
    public String getXmlData() {
        if (this.sText == null || this.sText.isDisposed()) {
            return XmlUtil.textToXml((String)this.text);
        }
        try {
            return XmlUtil.textToXml((String)this.sText.getText());
        }
        catch (SWTException sWTException) {
            return XmlUtil.textToXml((String)this.text);
        }
    }

    @Override
    public String toXml() {
        if (this.xmlSubRoot.equals("")) {
            return this.toXml(this.xmlRoot);
        }
        return this.toXml(this.xmlRoot, this.xmlSubRoot);
    }

    @Override
    public String toXml(String xmlRoot) {
        return "<" + xmlRoot + ">" + this.getXmlData() + "</" + xmlRoot + ">\n";
    }

    @Override
    public String toXml(String xmlRoot, String xmlSubRoot) {
        return "<" + xmlRoot + ">" + "<" + xmlSubRoot + ">" + this.getXmlData() + "</" + xmlSubRoot + ">" + "</" + xmlRoot + ">\n";
    }

    @Override
    public void setXmlData(String str) {
        this.set(str);
    }

    @Override
    public void setFromXml(String xml) {
        Matcher m = Pattern.compile("<" + this.xmlRoot + ">(.*?)</" + this.xmlRoot + ">", 40).matcher(xml);
        if (m.find()) {
            String xmlStr = m.group(1);
            String str = XmlUtil.xmlToText((String)xmlStr);
            this.setXmlData(str);
        }
    }

    public int getInt() {
        Integer percent = 0;
        try {
            percent = Integer.valueOf(this.text);
        }
        catch (NumberFormatException numberFormatException) {}
        return percent;
    }

    protected void updateTextWidget() {
        if (this.sText == null || this.sText.isDisposed()) {
            return;
        }
        if (this.text.equals(this.sText.getText())) {
            return;
        }
        this.sText.setText(this.text);
        this.setLabelError();
    }

    public void set(String text) {
        this.text = text == null ? "" : text;
        this.updateTextWidget();
    }

    public void set(XViewerTextWidget text) {
        this.set(text.get());
    }

    public void append(String text) {
        this.text = String.valueOf(this.text) + text;
        this.updateTextWidget();
    }

    @Override
    public void refresh() {
        this.updateTextWidget();
    }

    @Override
    public String getReportData() {
        StringBuilder sb = new StringBuilder();
        String textStr = this.text;
        if (this.fillVertically) {
            sb.append("\n");
            textStr = textStr.replaceAll("\n", "\n      ");
            textStr = "      " + textStr;
        }
        sb.append(textStr);
        return sb.toString().replaceAll("\n$", "");
    }

    public String toHTML(String labelFont, boolean newLineText) {
        String s = HtmlUtil.getLabelStr(labelFont, String.valueOf(this.label) + ": ");
        if (newLineText) {
            s = "<dl><dt>" + s + "<dd>";
        }
        s = String.valueOf(s) + this.text;
        if (newLineText) {
            s = String.valueOf(s) + "</dl>";
        }
        return s;
    }

    @Override
    public String toHTML(String labelFont) {
        return this.toHTML(labelFont, false);
    }

    @Override
    public boolean isValid() {
        return !this.isRequiredEntry() || !this.get().equals("");
    }

    @Override
    public Object getData() {
        return this.sText.getText();
    }

    public StyledText getStyledText() {
        return this.sText;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.sText != null) {
            this.sText.setFont(font);
        }
    }
}

