/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.services.internal;

import java.net.URI;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.services.BaseMessages;
import org.eclipse.osee.framework.messaging.services.ServiceInfoPopulator;
import org.eclipse.osee.framework.messaging.services.internal.OseeMessagingStatusImpl;
import org.eclipse.osee.framework.messaging.services.messages.ServiceHealth;

public class UpdateStatus
implements Runnable {
    private final ConnectionNode connectionNode;
    private final ServiceInfoPopulator infoPopulator;
    private final ServiceHealth health;
    private final String errorMsg;

    UpdateStatus(ConnectionNode connectionNode, String serviceName, String serviceVersion, String serviceUniqueId, URI broker, int refreshRateInSeconds, ServiceInfoPopulator infoPopulator) {
        this.connectionNode = connectionNode;
        this.health = new ServiceHealth();
        this.health.setBrokerURI(broker.toASCIIString());
        this.health.setServiceName(serviceName);
        this.health.setServiceVersion(serviceVersion);
        this.health.setServiceUniqueId(serviceUniqueId);
        this.health.setRefreshRateInSeconds(refreshRateInSeconds);
        this.health.setStopping(false);
        this.errorMsg = String.format("Failed to send %s to %s v[%s][%s]", BaseMessages.ServiceHealth.getName(), this.health.getServiceName(), this.health.getServiceVersion(), this.health.getServiceUniqueId());
        this.infoPopulator = infoPopulator;
    }

    @Override
    public synchronized void run() {
        try {
            this.health.getServiceDescription().clear();
            this.infoPopulator.updateServiceInfo(this.health.getServiceDescription());
            this.connectionNode.send(BaseMessages.ServiceHealth, this.health, new OseeMessagingStatusImpl(this.errorMsg, UpdateStatus.class));
        }
        catch (Exception ex) {
            OseeLog.log(UpdateStatus.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public synchronized void close() {
        this.health.setStopping(true);
        this.run();
    }
}

