/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model.transaction;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.framework.resource.management.DataResource;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.model.transaction.AddAttribute;
import org.eclipse.osee.orcs.rest.model.transaction.AddRelation;
import org.eclipse.osee.orcs.rest.model.transaction.ArtifactSortContainer;
import org.eclipse.osee.orcs.rest.model.transaction.ArtifactSortContainerCreate;
import org.eclipse.osee.orcs.rest.model.transaction.ArtifactSortContainerModify;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.AttributeTransfer;
import org.eclipse.osee.orcs.rest.model.transaction.AttributeValueDoesNotExist;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.orcs.rest.model.transaction.DeleteAttribute;
import org.eclipse.osee.orcs.rest.model.transaction.DeleteRelation;
import org.eclipse.osee.orcs.rest.model.transaction.ModifyArtifact;
import org.eclipse.osee.orcs.rest.model.transaction.SetAttribute;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionBuilderDataFactory {
    private final OrcsApi orcsApi;
    private final OrcsTokenService tokenService;
    private final IResourceManager resourceManager;
    private BranchId currentBranch;
    private final HashMap<ArtifactId, ArtifactSortContainer> workingArtsById = new HashMap();
    private final ArrayList<ChangeItem> attributeChanges = new ArrayList();
    private final ArrayList<ChangeItem> relationChanges = new ArrayList();
    private final ArrayList<ChangeItem> tupleChanges = new ArrayList();
    private final XResultData results = new XResultData();

    public TransactionBuilderDataFactory(OrcsApi orcsApi, IResourceManager resourceManager) {
        this.orcsApi = orcsApi;
        this.tokenService = orcsApi.tokenService();
        this.resourceManager = resourceManager;
    }

    public TransactionBuilderDataFactory(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.tokenService = orcsApi.tokenService();
        this.resourceManager = null;
    }

    public TransactionBuilderData loadFromChanges(TransactionId txId1, TransactionId txId2) {
        Objects.requireNonNull(txId1, "The given start transaction cannot be null");
        Objects.requireNonNull(txId2, "The given end transaction cannot be null");
        List changes = this.orcsApi.getTransactionFactory().compareTxs(txId1, txId2);
        if (changes.isEmpty()) {
            throw new OseeCoreException("Change report is empty", new Object[0]);
        }
        TransactionBuilderData tbd = new TransactionBuilderData();
        for (ChangeItem change : changes) {
            if (!this.isGoodChange(change)) continue;
            ChangeType ct = change.getChangeType();
            if (ct.isArtifactChange()) {
                ChangeVersion net = change.getNetChange();
                ModificationType mt = net.getModType();
                if (ModificationType.NEW.equals(mt)) {
                    tbd = this.newArtifact(change, tbd, txId2);
                    continue;
                }
                if (ModificationType.MODIFIED.equals(mt)) {
                    tbd = this.modifyArtifact(change, tbd, txId2);
                    continue;
                }
                if (ModificationType.DELETED.equals(mt)) {
                    tbd = this.deleteArtifact(change, tbd);
                    continue;
                }
                if (!ModificationType.MERGED.equals(mt)) continue;
                tbd = this.modifyArtifact(change, tbd, txId2);
                continue;
            }
            if (ct.isAttributeChange()) {
                this.attributeChanges.add(change);
                continue;
            }
            if (ct.isRelationChange()) {
                this.relationChanges.add(change);
                continue;
            }
            if (ct.isTupleChange()) {
                this.tupleChanges.add(change);
                continue;
            }
            if (!ct.equals((Object)ChangeType.Unknown)) continue;
            this.results.errorf("unknown change not handled: %s", new Object[]{change.toString()});
        }
        tbd = this.handleAttributeChanges(tbd);
        tbd = this.handleRelationChanges(tbd);
        tbd = this.handleTupleChanges(tbd);
        tbd.setBranch(this.currentBranch.getIdString());
        this.orcsApi.getTransactionFactory().getTx(txId2);
        TransactionReadable txReadable = this.orcsApi.getTransactionFactory().getTx(txId2);
        if (txReadable.isValid()) {
            tbd.setTxComment(txReadable.getComment());
        } else {
            tbd.setTxComment(String.format("Set from JSON data that exports a change report from txId %s to txId %s", txId1.getIdString(), txId2.getIdString()));
        }
        ArtifactId commitArt = txReadable.getCommitArt();
        if (commitArt.isValid()) {
            tbd.setTxCommitArtId(commitArt.getId());
        } else {
            tbd.setTxCommitArtId(ArtifactId.SENTINEL.getId());
        }
        if (this.results.isFailed()) {
            tbd.setResults("Failed");
            tbd.setMessage(this.results.getResults().toString());
        }
        return tbd;
    }

    public XResultData getResults() {
        return this.results;
    }

    public TransactionBuilder loadFromJson(String json) {
        return this.loadFromJson(json, null);
    }

    public TransactionBuilder loadFromJson(String json, TransactionBuilder tx) {
        Long commitArtId;
        ArtifactId commitArt;
        if (Objects.isNull(json)) {
            throw new OseeArgumentException("Invalid String in loadFromJson", new Object[0]);
        }
        JsonNode readTree = this.orcsApi.jaxRsApi().readTree(json);
        BranchId branch = BranchId.valueOf((Long)readTree.get("branch").asLong());
        HashMap<String, ArtifactToken> artifactsByName = new HashMap<String, ArtifactToken>();
        HashMap<String, ArtifactToken> artifactsByKeys = new HashMap<String, ArtifactToken>();
        if (tx == null) {
            String txComment = readTree.get("txComment").asText();
            if (Strings.isInValid((String)txComment)) {
                txComment = "create transaction REST call";
            }
            tx = this.orcsApi.getTransactionFactory().createTransaction(branch, txComment);
        }
        this.createArtifacts(readTree, artifactsByName, artifactsByKeys, tx);
        this.modifyArtifacts(readTree, artifactsByName, tx);
        this.deleteArtifacts(readTree, tx);
        this.deleteRelations(readTree, tx);
        this.addRelations(readTree, artifactsByKeys, tx);
        JsonNode commitArtNode = readTree.get("txCommitArtId");
        if (commitArtNode != null && (commitArtNode.isLong() || commitArtNode.isInt()) && (commitArt = ArtifactId.valueOf((Long)(commitArtId = Long.valueOf(commitArtNode.asLong())))).isValid()) {
            tx.setCommitArtId(commitArt);
        }
        return tx;
    }

    private boolean isGoodChange(ChangeItem change) {
        Boolean good = change.getIgnoreType().isNone() || change.getIgnoreType().isResurrected() || change.getIgnoreType().isAlreadyOnDestination();
        if (this.currentBranch == null) {
            this.currentBranch = change.getCurrentVersion().getTransactionToken().getBranch();
        } else {
            TransactionToken currentTransaction = change.getCurrentVersion().getTransactionToken();
            BranchId changeBranch = currentTransaction.getBranch();
            if (this.currentBranch != changeBranch) {
                this.results.logf("branch switch during creation: was %s is %s", new Object[]{this.currentBranch, changeBranch});
            }
        }
        return good;
    }

    private TransactionBuilderData deleteArtifact(ChangeItem change, TransactionBuilderData tbd) {
        Long id;
        List<Long> artifacts = tbd.getDeleteArtifacts();
        if (artifacts == null) {
            artifacts = new ArrayList<Long>();
            tbd.setDeleteArtifacts(artifacts);
        }
        if (!artifacts.contains(id = change.getArtId().getId())) {
            artifacts.add(id);
        }
        return tbd;
    }

    private TransactionBuilderData modifyArtifact(ChangeItem change, TransactionBuilderData tbd, TransactionId txId) {
        ArtifactSortContainer artSort = this.addArtFromChange(change, txId);
        List<ModifyArtifact> artifacts = tbd.getModifyArtifacts();
        if (artifacts == null) {
            artifacts = new ArrayList<ModifyArtifact>();
            tbd.setModifyArtifacts(artifacts);
        }
        ModifyArtifact modifiedArt = new ModifyArtifact();
        modifiedArt.setApplicabilityId(change.getCurrentVersion().getApplicabilityToken().getIdString());
        modifiedArt.setId(change.getArtId().getIdString());
        if (artSort instanceof ArtifactSortContainerModify) {
            ((ArtifactSortContainerModify)artSort).setModifyArt(modifiedArt);
        }
        return tbd;
    }

    private TransactionBuilderData newArtifact(ChangeItem change, TransactionBuilderData tbd, TransactionId txId) {
        this.addArtFromChange(change, txId);
        List<CreateArtifact> artifacts = tbd.getCreateArtifacts();
        if (artifacts == null) {
            artifacts = new ArrayList<CreateArtifact>();
            tbd.setCreateArtifacts(artifacts);
        }
        return tbd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArtifactSortContainer addArtFromChange(ChangeItem change, TransactionId txId) {
        ArtifactSortContainer artSort;
        ArtifactReadable art;
        ArtifactId artId = change.getArtId();
        ModificationType modType = change.getNetChange().getModType();
        if (this.workingArtsById.containsKey(artId)) {
            return this.workingArtsById.get(artId);
        }
        if (this.currentBranch.isInvalid()) {
            this.results.error("current branch is invalid");
            throw new OseeCoreException("Branch in TransactionBuilderDataFactory invalid", new Object[0]);
        }
        try {
            art = this.orcsApi.getQueryFactory().fromBranch(this.currentBranch).fromTransaction(txId).includeDeletedArtifacts().andId(artId).asArtifact();
        }
        catch (Exception exception) {
            this.results.errorf("Exception to find artifact for art id: ", new Object[]{artId.toString()});
            throw new OseeCoreException("Artifact ID %s not found", new Object[]{artId.toString()});
        }
        if (!art.isValid()) {
            this.results.errorf("Can't find artifact for art id: ", new Object[]{artId.toString()});
            throw new OseeCoreException("Artifact for art id %s failed in query", new Object[]{artId.toString()});
        }
        if (modType.equals(ModificationType.NEW)) {
            if (change.getIgnoreType().isAlreadyOnDestination()) {
                artSort = new ArtifactSortContainerModify(art);
                ModifyArtifact modifiedArt = new ModifyArtifact();
                modifiedArt.setId(art.getIdString());
                ((ArtifactSortContainerModify)artSort).setModifyArt(modifiedArt);
                this.workingArtsById.put((ArtifactId)art, artSort);
                return artSort;
            }
            ArtifactSortContainerCreate artSortCreate = new ArtifactSortContainerCreate(art);
            CreateArtifact createdArt = new CreateArtifact();
            createdArt.setId(art.getIdString());
            createdArt.setApplicabilityId(change.getCurrentVersion().getApplicabilityToken().getIdString());
            createdArt.setTypeId(change.getItemTypeId().getIdString());
            createdArt.setkey(art.getIdString());
            artSortCreate.setCreateArtifact(createdArt);
            this.workingArtsById.put(artId, artSortCreate);
            return artSortCreate;
        }
        if (!modType.equals(ModificationType.MODIFIED) && !modType.equals(ModificationType.MERGED)) {
            artSort = new ArtifactSortContainer(art);
            this.workingArtsById.put(artId, artSort);
            return artSort;
        }
        artSort = new ArtifactSortContainerModify(art);
        ModifyArtifact modifiedArt = new ModifyArtifact();
        modifiedArt.setId(art.getIdString());
        modifiedArt.setApplicabilityId(change.getCurrentVersion().getApplicabilityToken().getIdString());
        this.workingArtsById.put((ArtifactId)art, artSort);
        return artSort;
    }

    private TransactionBuilderData handleAttributeChanges(TransactionBuilderData tbd) {
        for (ChangeItem change : this.attributeChanges) {
            ChangeVersion net = change.getNetChange();
            ModificationType mt = net.getModType();
            if (ModificationType.NEW.equals(mt)) {
                this.newAttribute(change, tbd);
                continue;
            }
            if (ModificationType.MODIFIED.equals(mt)) {
                this.modifyAttribute(change, tbd);
                continue;
            }
            if (!ModificationType.DELETED.equals(mt)) continue;
            this.deleteAttribute(change, tbd);
        }
        return this.fillData(tbd);
    }

    private TransactionBuilderData fillData(TransactionBuilderData tbd) {
        this.workingArtsById.forEach((artId, sortArt) -> this.addSortContent(tbd, (ArtifactSortContainer)sortArt));
        return tbd;
    }

    private void addSortContent(TransactionBuilderData tbd, ArtifactSortContainer sortArt) {
        if (sortArt instanceof ArtifactSortContainerCreate) {
            List<CreateArtifact> createArts = tbd.getCreateArtifacts();
            if (createArts != null) {
                createArts.add(((ArtifactSortContainerCreate)sortArt).getCreateArt());
            }
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            List<ModifyArtifact> modArts = tbd.getModifyArtifacts();
            if (modArts != null) {
                modArts.add(((ArtifactSortContainerModify)sortArt).getModifyArt());
            }
        } else {
            this.results.errorf("default sort container not handled %s", new Object[]{sortArt.getArtifact().getIdString()});
        }
    }

    private TransactionBuilderData deleteAttribute(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer sortArt = this.workingArtsById.get(change.getArtId());
        if (sortArt == null) {
            List<Long> artifacts = tbd.getDeleteArtifacts();
            if (!artifacts.contains(change.getArtId().getId())) {
                this.results.errorf("artifact for deleted attribute not in deleted artifact list: %s", new Object[]{change.getArtId()});
            }
        } else if (sortArt instanceof ArtifactSortContainerCreate) {
            this.results.errorf("must not delete attribute in creation container: %s", new Object[]{change});
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            ModifyArtifact art = ((ArtifactSortContainerModify)sortArt).getModifyArt();
            List<DeleteAttribute> attrs = art.getDeleteAttributes();
            if (attrs == null) {
                attrs = new ArrayList<DeleteAttribute>();
                art.setDeleteAttributes(attrs);
            }
            DeleteAttribute attr = new DeleteAttribute();
            attr.setTypeId(change.getItemTypeId().getIdString());
            attr.setId(change.getItemId().getIdString());
            attrs.add(attr);
        } else {
            this.results.errorf("incorrect default sort container for deleted attribute %s", new Object[]{change.getItemId().toString()});
        }
        return tbd;
    }

    private TransactionBuilderData modifyAttribute(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer sortArt = this.workingArtsById.get(change.getArtId());
        if (sortArt == null) {
            this.results.errorf("artifact for modified attribute not in change report: %s", new Object[]{change.getArtId()});
        } else if (sortArt instanceof ArtifactSortContainerCreate) {
            this.results.warningf("modify attribute in create artifact, change: %s", new Object[]{change});
            CreateArtifact art = ((ArtifactSortContainerCreate)sortArt).getCreateArt();
            List<Attribute> attrs = art.getAttributes();
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                art.setAttributes(attrs);
            }
            try {
                attrs.add((Attribute)this.setupTransferArtifact(change, sortArt.getArtifact(), Attribute::new));
            }
            catch (AttributeValueDoesNotExist ex) {
                this.results.warningf(ex.getMessage(), new Object[0]);
            }
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            ModifyArtifact art = ((ArtifactSortContainerModify)sortArt).getModifyArt();
            List<SetAttribute> attrs = art.getSetAttributes();
            if (attrs == null) {
                attrs = new ArrayList<SetAttribute>();
                art.setSetAttributes(attrs);
            }
            try {
                attrs.add((SetAttribute)this.setupTransferArtifact(change, sortArt.getArtifact(), SetAttribute::new));
            }
            catch (AttributeValueDoesNotExist ex) {
                this.results.warningf(ex.getMessage(), new Object[0]);
            }
        } else {
            this.results.errorf("incorrect default sort container for modified attribute %s", new Object[]{change.getItemId().toString()});
        }
        return tbd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AttributeTransfer setupTransferArtifact(ChangeItem change, ArtifactReadable art, Function<String, AttributeTransfer> attrTrans) {
        AttributeTypeGeneric attrType = this.orcsApi.tokenService().getAttributeType(change.getItemTypeId().getId());
        AttributeTransfer item = attrTrans.apply(attrType.getIdString());
        ChangeVersion cv = change.getNetChange();
        item.setId(change.getItemId().toString());
        if (cv != null && cv.isValid()) {
            String value = cv.getValue();
            String uri = cv.getUri();
            boolean validValue = Strings.isValidAndNonBlank((String)value);
            boolean validURI = Strings.isValidAndNonBlank((String)uri);
            if (!validValue && !validURI) {
                cv = change.getCurrentVersion();
                value = cv.getValue();
                uri = cv.getUri();
                validValue = Strings.isValidAndNonBlank((String)value);
                validURI = Strings.isValidAndNonBlank((String)uri);
            }
            if (validValue) {
                item.setValue(Arrays.asList(value));
                return item;
            } else {
                if (!validURI) throw new AttributeValueDoesNotExist("Invalid value in artifact: " + art.getArtifactId().getIdString() + ", attribute type: " + change.getItemTypeId().getId(), new Object[0]);
                if (attrType.isInputStream()) {
                    ArrayList<String> list = new ArrayList<String>();
                    Base64.Encoder encoder = Base64.getEncoder();
                    byte[] data = this.resourceManager.acquire(new DataResource("application/zip", "UTF-8", ".zip", uri));
                    list.add(encoder.encodeToString(data));
                    item.setValue(list);
                    return item;
                } else {
                    try {
                        ArrayList<String> list = new ArrayList<String>();
                        byte[] data = this.resourceManager.acquire(new DataResource("application/zip", "UTF-8", ".zip", uri));
                        if (data == null) {
                            throw new OseeCoreException("invalid data for zip: %s", new Object[]{uri.toString()});
                        }
                        ByteBuffer decompressed = ByteBuffer.wrap(Zip.decompressBytes((InputStream)new ByteArrayInputStream(data)));
                        list.add(new String(decompressed.array(), "UTF-8"));
                        item.setValue(list);
                        return item;
                    }
                    catch (IOException ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                    }
                }
            }
            return item;
        } else {
            this.results.errorf("unhandled data for art %s setting type %s", new Object[]{art, attrType});
        }
        return item;
    }

    private void addToTransferArtifact(ChangeItem change, ArtifactReadable art, Attribute item) {
        AttributeTypeGeneric attrType;
        ArtifactTypeToken token = art.getArtifactType();
        if (token.getMax((AttributeTypeToken)(attrType = this.orcsApi.tokenService().getAttributeType(change.getItemTypeId().getId()))) > 1) {
            ChangeVersion cv = change.getNetChange();
            ArrayList<String> list = new ArrayList<String>(item.getValue());
            if (cv != null && cv.isValid()) {
                String value = cv.getValue();
                String uri = cv.getUri();
                if (Strings.isValidAndNonBlank((String)value)) {
                    list.add(value);
                } else if (Strings.isValidAndNonBlank((String)uri)) {
                    if (attrType.isInputStream()) {
                        Base64.Encoder encoder = Base64.getEncoder();
                        byte[] data = this.resourceManager.acquire(new DataResource("application/zip", "UTF-8", ".zip", uri));
                        list.add(encoder.encodeToString(data));
                    } else {
                        this.results.errorf("uri %s is not attr type input stream", new Object[]{uri});
                    }
                } else {
                    this.results.errorf("change %s has invalid net change", new Object[]{change.toString()});
                }
                item.setValue(list);
            } else {
                this.results.errorf("unhandled data for art %s setting type %s", new Object[]{art, attrType});
            }
        } else {
            this.results.errorf("Attempting to add multiple values to single valued item %s", new Object[]{change.toString()});
        }
    }

    private TransactionBuilderData newAttribute(ChangeItem change, TransactionBuilderData tbd) {
        ArtifactSortContainer sortArt = this.workingArtsById.get(change.getArtId());
        if (sortArt == null) {
            this.results.errorf("artifact for new attribute not in change report: %s", new Object[]{change.getArtId()});
        } else if (sortArt instanceof ArtifactSortContainerCreate) {
            CreateArtifact art = ((ArtifactSortContainerCreate)sortArt).getCreateArt();
            List<Attribute> attrs = art.getAttributes();
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                art.setAttributes(attrs);
            }
            try {
                attrs.add((Attribute)this.setupTransferArtifact(change, sortArt.getArtifact(), Attribute::new));
            }
            catch (AttributeValueDoesNotExist ex) {
                this.results.warningf(ex.getMessage(), new Object[0]);
            }
        } else if (sortArt instanceof ArtifactSortContainerModify) {
            ModifyArtifact art = ((ArtifactSortContainerModify)sortArt).getModifyArt();
            List<AddAttribute> attrs = art.getAddAttributes();
            if (attrs == null) {
                attrs = new ArrayList<AddAttribute>();
                art.setAddAttributes(attrs);
            }
            try {
                attrs.add((AddAttribute)this.setupTransferArtifact(change, sortArt.getArtifact(), AddAttribute::new));
            }
            catch (AttributeValueDoesNotExist ex) {
                this.results.warningf(ex.getMessage(), new Object[0]);
            }
        } else {
            this.results.errorf("incorrect default sort container for modified attribute %s", new Object[]{change.getItemId().toString()});
        }
        return tbd;
    }

    private TransactionBuilderData handleRelationChanges(TransactionBuilderData tbd) {
        for (ChangeItem change : this.relationChanges) {
            ChangeVersion current = change.getCurrentVersion();
            ModificationType mt = current.getModType();
            if (ModificationType.NEW.equals(mt) || ModificationType.MODIFIED.equals(mt)) {
                tbd = this.newRelation(change, tbd);
                continue;
            }
            if (!ModificationType.DELETED.equals(mt)) continue;
            tbd = this.deleteRelation(change, tbd);
        }
        return tbd;
    }

    private TransactionBuilderData deleteRelation(ChangeItem change, TransactionBuilderData tbd) {
        List<DeleteRelation> rels = tbd.getDeleteRelations();
        if (rels == null) {
            rels = new ArrayList<DeleteRelation>();
            tbd.setDeleteRelations(rels);
        }
        DeleteRelation dr = new DeleteRelation();
        dr.setaArtId(change.getArtId().getIdString());
        dr.setbArtId(change.getArtIdB().toString());
        dr.setTypeId(change.getItemTypeId().getIdString());
        dr.setId(change.getItemId().getIdString());
        rels.add(dr);
        return tbd;
    }

    private TransactionBuilderData newRelation(ChangeItem change, TransactionBuilderData tbd) {
        List<AddRelation> rels = tbd.getAddRelations();
        if (rels == null) {
            rels = new ArrayList<AddRelation>();
            tbd.setAddRelations(rels);
        }
        AddRelation dr = new AddRelation();
        dr.setaArtId(change.getArtId().getIdString());
        dr.setbArtId(change.getArtIdB().toString());
        dr.setTypeId(change.getItemTypeId().getIdString());
        dr.setId(change.getItemId().getIdString());
        rels.add(dr);
        return tbd;
    }

    private TransactionBuilderData handleTupleChanges(TransactionBuilderData tbd) {
        return tbd;
    }

    private void createArtifacts(JsonNode root, Map<String, ArtifactToken> artifactsByName, Map<String, ArtifactToken> artifactsByKeys, TransactionBuilder tx) {
        if (root.has("createArtifacts")) {
            for (JsonNode artifactJson : root.get("createArtifacts")) {
                ArtifactToken artifact;
                ApplicabilityId appId = artifactJson.has("applicabilityId") ? ApplicabilityId.valueOf((Long)artifactJson.get("applicabilityId").asLong()) : ApplicabilityId.BASE;
                ArtifactTypeToken artifactType = this.getArtifactType(artifactJson);
                if (artifactJson.has("id")) {
                    ArtifactId artId = ArtifactId.valueOf((Long)artifactJson.get("id").asLong());
                    if (artifactJson.has("name")) {
                        artifact = tx.createArtifact(artifactType, artifactJson.get("name").asText(), artId, appId);
                        this.readAttributes(tx, artifactJson, artifact, "attributes");
                    } else {
                        artifact = tx.createArtifactWithNoName(artifactType, artId, appId);
                        this.addAttributes(tx, artifactJson, artifact, "attributes");
                    }
                } else if (artifactJson.has("name")) {
                    artifact = tx.createArtifact(artifactType, artifactJson.get("name").asText(), appId);
                    this.readAttributes(tx, artifactJson, artifact, "attributes");
                } else {
                    artifact = tx.createArtifactWithNoName(artifactType, null, appId);
                    this.addAttributes(tx, artifactJson, artifact, "attributes");
                }
                if (artifactJson.has("key")) {
                    artifactsByKeys.put(artifactJson.get("key").asText(), artifact);
                }
                artifactsByName.put(artifact.getName(), artifact);
                this.readrelations(tx, artifactsByName, artifactsByKeys, artifactJson, artifact);
            }
        }
    }

    private void modifyArtifacts(JsonNode root, Map<String, ArtifactToken> artifactsByName, TransactionBuilder tx) {
        if (root.has("modifyArtifacts")) {
            for (JsonNode artifactJson : root.get("modifyArtifacts")) {
                ArtifactToken artifact = this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((Long)artifactJson.get("id").asLong())).asArtifactToken();
                artifactsByName.put(artifact.getName(), artifact);
                if (artifactJson.has("applicabilityId")) {
                    tx.setApplicability((ArtifactId)artifact, ApplicabilityId.valueOf((Long)artifactJson.get("applicabilityId").asLong()));
                }
                this.readAttributes(tx, artifactJson, artifact, "setAttributes");
                this.addAttributes(tx, artifactJson, artifact, "addAttributes");
                this.deleteAttributes(tx, artifactJson, artifact, "deleteAttributes");
            }
        }
    }

    private void deleteArtifacts(JsonNode root, TransactionBuilder tx) {
        if (root.has("deleteArtifacts")) {
            for (JsonNode artifactId : root.get("deleteArtifacts")) {
                tx.deleteArtifact(ArtifactId.valueOf((Long)artifactId.asLong()));
            }
        }
    }

    private void deleteRelations(JsonNode root, TransactionBuilder tx) {
        if (root.has("deleteRelations")) {
            for (JsonNode relation : root.get("deleteRelations")) {
                RelationTypeToken relationType = this.getRelationType(relation);
                ArtifactId artA = ArtifactId.valueOf((Long)relation.get("aArtId").asLong());
                ArtifactId artB = ArtifactId.valueOf((Long)relation.get("bArtId").asLong());
                if (!artA.isValid() || !artB.isValid()) continue;
                if (relation.has("gamma")) {
                    tx.unrelate(artA, relationType, artB, GammaId.valueOf((String)relation.get("gamma").asText()));
                    continue;
                }
                tx.unrelate(artA, relationType, artB);
            }
        }
        if (root.has("deleteInvalidRelations")) {
            for (JsonNode relation : root.get("deleteInvalidRelations")) {
                ArtifactId artA = ArtifactId.valueOf((Long)relation.get("validArt").asLong());
                ArtifactId artB = ArtifactId.valueOf((Long)relation.get("invalidArt").asLong());
                if (!artA.isValid() || !artB.isValid()) continue;
                tx.unrelateFromInvalidArtifact(artA, artB);
            }
        }
    }

    private void addRelations(JsonNode root, Map<String, ArtifactToken> artifactsByKeys, TransactionBuilder tx) {
        if (root.has("addRelations")) {
            for (JsonNode relation : root.get("addRelations")) {
                RelationTypeToken relationType = this.getRelationType(relation);
                String rationale = relation.has("rationale") ? relation.get("rationale").asText() : "";
                ArtifactId relatedArtifact = relation.has("relatedArtifact") ? ArtifactId.valueOf((Long)relation.get("relatedArtifact").asLong()) : ArtifactId.SENTINEL;
                String afterArtifact = relation.has("afterArtifact") ? relation.get("afterArtifact").asText() : "end";
                ArtifactId artA = artifactsByKeys.containsKey(relation.get("aArtId").asText()) ? ArtifactId.valueOf((Long)artifactsByKeys.get(relation.get("aArtId").asText()).getId()) : ArtifactId.valueOf((Long)relation.get("aArtId").asLong());
                ArtifactId artB = artifactsByKeys.containsKey(relation.get("bArtId").asText()) ? ArtifactId.valueOf((Long)artifactsByKeys.get(relation.get("bArtId").asText()).getId()) : ArtifactId.valueOf((Long)relation.get("bArtId").asLong());
                boolean hasGamma = relation.has("gamma");
                if (relationType.isNewRelationTable() && !hasGamma) {
                    tx.relate(artA, relationType, artB, relatedArtifact, afterArtifact);
                    continue;
                }
                if (!hasGamma) {
                    if (relation.has("id")) {
                        tx.relate(artA, relationType, artB, rationale, RelationId.valueOf((String)relation.get("id").asText()));
                        continue;
                    }
                    tx.relate(artA, relationType, artB, rationale);
                    continue;
                }
                if (relationType.isNewRelationTable()) {
                    tx.relate(artA, relationType, artB, relatedArtifact, afterArtifact, GammaId.valueOf((String)relation.get("gamma").asText()));
                    continue;
                }
                tx.relate(artA, relationType, artB, rationale, GammaId.valueOf((String)relation.get("gamma").asText()));
            }
        }
    }

    private <R extends NamedId> R getToken(JsonNode node, Function<Long, R> getById, Function<String, R> getByName) {
        JsonNode id = node.get("typeId");
        if (id == null) {
            JsonNode typeNode = node.get("typeName");
            if (typeNode == null || Strings.isInValid((String)typeNode.asText())) {
                throw new OseeArgumentException("The type must be specified", new Object[0]);
            }
            return (R)((NamedId)getByName.apply(typeNode.asText()));
        }
        return (R)((NamedId)getById.apply(id.asLong()));
    }

    private void readAttributes(TransactionBuilder tx, JsonNode artifactJson, ArtifactToken artifact, String attributesNodeName) {
        if (artifactJson.has(attributesNodeName)) {
            for (JsonNode attribute : artifactJson.get(attributesNodeName)) {
                AttributeTypeGeneric<?> attributeType = this.getAttributeType(attribute);
                JsonNode value = attribute.get("value");
                if (value == null) {
                    throw new OseeCoreException("No data for Attribute: %s in Artifact: %s", new Object[]{attributeType.toString(), artifactJson.get("id").asLong()});
                }
                boolean hasGamma = attribute.has("gamma");
                if (value.isArray()) {
                    JsonNode gamma;
                    ArrayList<String> values = new ArrayList<String>();
                    ArrayList<ByteArrayInputStream> streams = new ArrayList<ByteArrayInputStream>();
                    ArrayList<GammaId> gammas = new ArrayList<GammaId>();
                    for (JsonNode attrValue : value) {
                        if (attributeType.isInputStream()) {
                            Base64.Decoder decoder = Base64.getDecoder();
                            ByteArrayInputStream bais = new ByteArrayInputStream(decoder.decode(attrValue.asText()));
                            streams.add(bais);
                            continue;
                        }
                        values.add(attrValue.asText());
                    }
                    if (hasGamma && (gamma = attribute.get("gamma")).isArray()) {
                        for (JsonNode gammaValue : gamma) {
                            gammas.add(GammaId.valueOf((String)gammaValue.asText()));
                        }
                    }
                    if (!values.isEmpty() && !hasGamma) {
                        tx.setAttributesFromStrings((ArtifactId)artifact, attributeType, values);
                    }
                    if (!streams.isEmpty() && !hasGamma) {
                        tx.setAttributesFromValues((ArtifactId)artifact, attributeType, streams);
                    }
                    if (!values.isEmpty() && hasGamma && !gammas.isEmpty()) {
                        tx.setAttributesFromStrings((ArtifactId)artifact, attributeType, values, gammas);
                    }
                    if (streams.isEmpty() || !hasGamma || gammas.isEmpty()) continue;
                    tx.setAttributesFromValues((ArtifactId)artifact, attributeType, streams, gammas);
                    continue;
                }
                if (hasGamma) {
                    JsonNode gamma = attribute.get("gamma");
                    tx.setSoleAttributeFromString((ArtifactId)artifact, attributeType, value.asText(), GammaId.valueOf((String)gamma.asText()));
                    continue;
                }
                tx.setSoleAttributeFromString((ArtifactId)artifact, attributeType, value.asText());
            }
        }
    }

    private void addAttributes(TransactionBuilder tx, JsonNode artifactJson, ArtifactToken artifact, String attributesNodeName) {
        if (artifactJson.has(attributesNodeName)) {
            for (JsonNode attribute : artifactJson.get(attributesNodeName)) {
                AttributeTypeGeneric<?> attributeType = this.getAttributeType(attribute);
                JsonNode value = attribute.get("value");
                if (attribute.has("id") && AttributeId.valueOf((String)attribute.get("id").asText()).isValid()) {
                    AttributeId attrId = AttributeId.valueOf((String)attribute.get("id").asText());
                    if (value.isArray()) {
                        for (JsonNode attrValue : value) {
                            tx.createAttributeFromString((ArtifactId)artifact, attributeType, attrValue.asText(), attrId);
                        }
                        continue;
                    }
                    tx.createAttributeFromString((ArtifactId)artifact, attributeType, value.asText(), attrId);
                    continue;
                }
                if (value.isArray()) {
                    for (JsonNode attrValue : value) {
                        tx.createAttributeFromString((ArtifactId)artifact, attributeType, attrValue.asText());
                    }
                    continue;
                }
                tx.createAttributeFromString((ArtifactId)artifact, attributeType, value.asText());
            }
        }
    }

    private void deleteAttributes(TransactionBuilder tx, JsonNode artifactJson, ArtifactToken artifact, String attributesNodeName) {
        if (artifactJson.has(attributesNodeName)) {
            for (JsonNode attribute : artifactJson.get(attributesNodeName)) {
                if (attribute.has("gamma")) {
                    tx.deleteAttributes((ArtifactId)artifact, this.getAttributeType(attribute), GammaId.valueOf((String)attribute.get("gamma").asText()));
                    continue;
                }
                if (attribute.has("id")) {
                    tx.deleteByAttributeId((ArtifactId)artifact, AttributeId.valueOf((String)attribute.get("id").asText()));
                    continue;
                }
                tx.deleteAttributes((ArtifactId)artifact, this.getAttributeType(attribute));
            }
        }
    }

    private void readrelations(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, Map<String, ArtifactToken> artifactsByKey, JsonNode artifactJson, ArtifactToken artifact) {
        if (artifactJson.has("relations")) {
            for (JsonNode relation : artifactJson.get("relations")) {
                RelationTypeToken relationType = this.getRelationType(relation);
                if (relation.isTextual() || relation.isArray()) {
                    this.relate(tx, artifactsByName, artifactsByKey, relation, relationType, artifact, RelationSide.SIDE_A, "", ArtifactId.SENTINEL, "end");
                    continue;
                }
                if (relation.isObject()) {
                    String afterArtifact;
                    String rationale = relation.has("rationale") ? relation.get("rationale").asText() : "";
                    ArtifactId relatedArtifact = relation.has("relatedArtifact") ? ArtifactId.valueOf((Long)relation.get("relatedArtifact").asLong()) : ArtifactId.SENTINEL;
                    String string = afterArtifact = relation.has("afterArtifact") ? relation.get("afterArtifact").asText() : "end";
                    if (relation.has("sideA")) {
                        this.relate(tx, artifactsByName, artifactsByKey, relation.get("sideA"), relationType, artifact, RelationSide.SIDE_B, rationale, relatedArtifact, afterArtifact);
                    }
                    if (!relation.has("sideB")) continue;
                    this.relate(tx, artifactsByName, artifactsByKey, relation.get("sideB"), relationType, artifact, RelationSide.SIDE_A, rationale, relatedArtifact, afterArtifact);
                    continue;
                }
                throw new OseeStateException("Json Node of unexpected type %s", new Object[]{relation.getNodeType()});
            }
        }
    }

    private void relate(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, Map<String, ArtifactToken> artifactsByKey, JsonNode relations, RelationTypeToken relationType, ArtifactToken artifact, RelationSide side, String rationale, ArtifactId relatedArtifact, String afterArtifact) {
        if (relations.isTextual()) {
            this.relateOne(tx, artifactsByName, artifactsByKey, relations, relationType, artifact, side, rationale, relatedArtifact, afterArtifact);
        } else if (relations.isArray()) {
            for (JsonNode name : relations) {
                this.relateOne(tx, artifactsByName, artifactsByKey, name, relationType, artifact, side, rationale, relatedArtifact, afterArtifact);
            }
        } else {
            throw new OseeStateException("Json Node of unexpected type %s", new Object[]{relations.getNodeType()});
        }
    }

    private void relate(TransactionBuilder tx, RelationTypeToken relationType, ArtifactToken artifact, RelationSide side, String rationale, ArtifactId otherArtifact, ArtifactId relatedArtifact, String afterArtifact) {
        if (side.isSideA()) {
            if (relationType.isNewRelationTable()) {
                tx.relate((ArtifactId)artifact, relationType, otherArtifact, relatedArtifact, afterArtifact);
            } else {
                tx.relate((ArtifactId)artifact, relationType, otherArtifact, rationale);
            }
        } else if (relationType.isNewRelationTable()) {
            tx.relate(otherArtifact, relationType, (ArtifactId)artifact, relatedArtifact, afterArtifact);
        } else {
            tx.relate(otherArtifact, relationType, (ArtifactId)artifact, rationale);
        }
    }

    private void relateOne(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, Map<String, ArtifactToken> artifactsByKey, JsonNode relation, RelationTypeToken relationType, ArtifactToken artifact, RelationSide side, String rationale, ArtifactId relatedArtifact, String afterArtifact) {
        Object otherArtifact = Strings.isNumeric((String)relation.asText("")) ? ArtifactId.valueOf((Long)relation.asLong()) : this.getArtifactByName(tx, artifactsByName, artifactsByKey, relation.asText());
        this.relate(tx, relationType, artifact, side, rationale, (ArtifactId)otherArtifact, relatedArtifact, afterArtifact);
    }

    private ArtifactToken getArtifactByName(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, Map<String, ArtifactToken> artifactsByKey, String name) {
        ArtifactToken artifact = artifactsByName.get(name);
        if (artifact != null) {
            return artifact;
        }
        artifact = artifactsByKey.get(name);
        if (artifact != null) {
            return artifact;
        }
        return this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andNameEquals(name).asArtifactToken();
    }

    private ArtifactTypeToken getArtifactType(JsonNode artifactJson) {
        return this.getToken(artifactJson, arg_0 -> ((OrcsTokenService)this.tokenService).getArtifactType(arg_0), arg_0 -> ((OrcsTokenService)this.tokenService).getArtifactType(arg_0));
    }

    private AttributeTypeGeneric<?> getAttributeType(JsonNode attribute) {
        return this.getToken(attribute, arg_0 -> ((OrcsTokenService)this.tokenService).getAttributeType(arg_0), arg_0 -> ((OrcsTokenService)this.tokenService).getAttributeType(arg_0));
    }

    private RelationTypeToken getRelationType(JsonNode relation) {
        return this.getToken(relation, arg_0 -> ((OrcsTokenService)this.tokenService).getRelationType(arg_0), arg_0 -> ((OrcsTokenService)this.tokenService).getRelationType(arg_0));
    }
}

