/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.ui;

import net.sourceforge.vrapper.eclipse.ui.CLabel;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ModeContributionItem
extends ContributionItem {
    private static final String DEFAULT_MESSAGE = "vrapper disabled";
    private static final String RECORDING_MESSAGE = "recording: ";
    private static final int LABEL_MARGIN = 3;
    private String mode = "";
    private boolean isRecording;
    private String recMacro;
    private org.eclipse.swt.custom.CLabel recordingText;
    private org.eclipse.swt.custom.CLabel modeText;

    public ModeContributionItem(String id) {
        super(id);
    }

    public void fill(Composite parent) {
        int recordingLabelWidth;
        int modeLabelWidth;
        int fontHeight;
        Font boldFont = JFaceResources.getFontRegistry().getBold("");
        Font regularFont = JFaceResources.getFontRegistry().defaultFont();
        GC gc = null;
        try {
            gc = new GC((Drawable)parent);
            gc.setFont(regularFont);
            fontHeight = gc.getFontMetrics().getHeight();
            modeLabelWidth = gc.textExtent((String)DEFAULT_MESSAGE).x + 6;
            gc.setFont(boldFont);
            recordingLabelWidth = gc.textExtent((String)"recording: @").x + 6;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        Label sep = new Label(parent, 2);
        StatusLineLayoutData layoutData = new StatusLineLayoutData();
        layoutData.heightHint = fontHeight;
        sep.setLayoutData((Object)layoutData);
        if (this.isRecording) {
            this.recordingText = new org.eclipse.swt.custom.CLabel(parent, 0x1000020);
            this.recordingText.setText(this.getRecordingLabelText());
            this.recordingText.setVisible(this.isRecording);
            this.recordingText.setFont(boldFont);
            layoutData = new StatusLineLayoutData();
            layoutData.widthHint = recordingLabelWidth;
            this.recordingText.setLayoutData((Object)layoutData);
        }
        this.modeText = new CLabel(parent, 0x1000020);
        this.modeText.setText(this.mode);
        this.modeText.setFont(regularFont);
        StatusLineLayoutData modeLayoutData = new StatusLineLayoutData();
        modeLayoutData.widthHint = modeLabelWidth;
        this.modeText.setLayoutData((Object)modeLayoutData);
    }

    private String getRecordingLabelText() {
        return RECORDING_MESSAGE + this.recMacro;
    }

    public void setText(String text) {
        this.mode = text;
        if (this.modeText != null && !this.modeText.isDisposed()) {
            this.modeText.setText(text);
        }
    }

    public void setRecording(boolean b, String m) {
        this.isRecording = b;
        this.recMacro = m;
        if (this.recordingText != null && !this.recordingText.isDisposed()) {
            this.recordingText.setText(this.getRecordingLabelText());
            this.recordingText.setVisible(this.isRecording);
        }
        if (this.getParent() != null) {
            this.getParent().update(true);
        }
    }
}

