/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.ui;

import net.sourceforge.vrapper.eclipse.ui.CaretUtils;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.services.IDisposable;

class EclipseCommandLineUI
implements CommandLineUI,
IDisposable,
CaretListener,
SelectionListener {
    private StyledText commandLineText;
    private Register clipboard;
    private String prompt;
    private int contentsOffset;
    private Caret defaultCaret;
    private Caret endCharCaret;
    private Menu contextMenu;
    private MenuItem cutItem;
    private MenuItem copyItem;
    private MenuItem pasteItem;
    private MenuItem selectAllItem;
    private Point registerModeSelection;
    private boolean readOnly;
    private int maxHeight;
    private int width;
    private int bottom;

    public EclipseCommandLineUI(final StyledText commandLineText, EditorAdaptor editorAdaptor) {
        this.clipboard = editorAdaptor.getRegisterManager().getRegister("+");
        this.commandLineText = commandLineText;
        commandLineText.addCaretListener((CaretListener)this);
        commandLineText.addSelectionListener((SelectionListener)this);
        this.defaultCaret = commandLineText.getCaret();
        this.endCharCaret = CaretUtils.createCaret(CaretType.RECTANGULAR, commandLineText);
        commandLineText.setCaret(this.endCharCaret);
        this.contextMenu = new Menu((Control)commandLineText);
        this.cutItem = new MenuItem(this.contextMenu, -1);
        this.cutItem.setText("Cut");
        this.cutItem.setEnabled(false);
        this.copyItem = new MenuItem(this.contextMenu, -1);
        this.copyItem.setText("Copy\tCtrl-Y  ");
        this.copyItem.setEnabled(false);
        this.pasteItem = new MenuItem(this.contextMenu, -1);
        this.pasteItem.setText("Paste\tCtrl-R +");
        this.selectAllItem = new MenuItem(this.contextMenu, -1);
        this.selectAllItem.setText("Select All");
        commandLineText.setMenu(this.contextMenu);
        this.cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EclipseCommandLineUI.this.copySelectionToClipboard();
                EclipseCommandLineUI.this.erase();
            }
        });
        this.copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EclipseCommandLineUI.this.copySelectionToClipboard();
            }
        });
        this.pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegisterContent content = EclipseCommandLineUI.this.clipboard.getContent();
                if (content.getPayloadType() == ContentType.TEXT || content.getPayloadType() == ContentType.LINES) {
                    String text = content.getText();
                    text = VimUtils.replaceNewLines((String)text, (String)" ");
                    EclipseCommandLineUI.this.type(text);
                }
            }
        });
        this.selectAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                commandLineText.setSelection(EclipseCommandLineUI.this.contentsOffset, commandLineText.getCharCount());
                Event e2 = new Event();
                e2.widget = commandLineText;
                e2.x = EclipseCommandLineUI.this.contentsOffset;
                e2.y = commandLineText.getCharCount();
                EclipseCommandLineUI.this.widgetSelected(new SelectionEvent(e2));
            }
        });
    }

    public boolean isOpen() {
        return !this.commandLineText.isDisposed() && this.commandLineText.isVisible();
    }

    public void setPrompt(String newPrompt) {
        this.prompt = newPrompt;
        this.commandLineText.replaceTextRange(0, this.contentsOffset, newPrompt);
        this.contentsOffset = newPrompt.length();
        this.commandLineText.setCaretOffset(this.commandLineText.getCharCount());
        this.updateUISize();
    }

    public void resetContents(String newContents) {
        this.commandLineText.replaceTextRange(this.contentsOffset, this.commandLineText.getCharCount() - this.contentsOffset, newContents);
        this.commandLineText.setCaret(this.endCharCaret);
        this.commandLineText.setSelection(this.commandLineText.getCharCount());
    }

    public String getContents() {
        int charCount = this.commandLineText.getCharCount();
        if (charCount == this.contentsOffset) {
            return "";
        }
        return this.commandLineText.getText(this.contentsOffset, charCount - 1);
    }

    public String getContents(int start, int end) {
        int endPosition = this.getEndPosition();
        if (!(start <= endPosition && start >= 0 || end <= endPosition && end >= 0)) {
            throw new IllegalArgumentException("Cannot get command line contents, start offset " + start + " and end offset " + end + " are out of commandline bounds");
        }
        if (start > endPosition || start < 0) {
            throw new IllegalArgumentException("Cannot get command line contents, start offset " + start + " is out of commandline bounds");
        }
        if (end > endPosition || end < 0) {
            throw new IllegalArgumentException("Cannot get command line contents, end offset " + end + " is out of commandline bounds");
        }
        int offset = Math.min(start, end) + this.contentsOffset;
        int length = Math.abs(end - start);
        return this.commandLineText.getTextRange(offset, length);
    }

    public String getFullContents() {
        return this.commandLineText.getText();
    }

    public void type(String characters) {
        this.clipSelection();
        this.setMode(CommandLineUI.CommandLineMode.DEFAULT);
        int start = this.commandLineText.getCaretOffset();
        if (this.commandLineText.getSelectionCount() > 0) {
            Point selection = this.commandLineText.getSelection();
            start = Math.min(selection.x, selection.y);
        }
        this.commandLineText.insert(characters);
        this.commandLineText.setCaretOffset(start + characters.length());
        this.updateCaret();
        this.updateUISize();
    }

    public void copySelectionToClipboard() {
        this.clipSelection();
        String selection = this.commandLineText.getSelectionText();
        if (selection.isEmpty()) {
            selection = this.getContents();
        }
        this.clipboard.setContent((RegisterContent)new StringRegisterContent(ContentType.TEXT, selection));
    }

    public void open() {
        Composite parent = this.commandLineText.getParent();
        this.commandLineText.setForeground(parent.getForeground());
        this.commandLineText.setBackground(parent.getBackground());
        this.commandLineText.setVisible(true);
        this.commandLineText.getParent().redraw();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                EclipseCommandLineUI.this.updateUISize();
                EclipseCommandLineUI.this.commandLineText.setFocus();
            }
        });
    }

    public int getPosition() {
        return this.commandLineText.getCaretOffset() - this.contentsOffset;
    }

    public void setPosition(int offset) {
        offset = offset < 0 ? this.contentsOffset : (offset + this.contentsOffset > this.commandLineText.getCharCount() ? this.commandLineText.getCharCount() : (offset += this.contentsOffset));
        this.commandLineText.setCaretOffset(offset);
        this.updateCaret();
    }

    public int getSelectionLength() {
        return this.commandLineText.getSelectionCount();
    }

    public int getSelectionStart() {
        Point selection = this.commandLineText.getSelection();
        int caretOffset = this.commandLineText.getCaretOffset();
        if (caretOffset == selection.x) {
            return selection.y - this.contentsOffset;
        }
        return selection.x - this.contentsOffset;
    }

    public int getSelectionEnd() {
        return this.getPosition();
    }

    public void setSelection(int start, int end) {
        int startOffset = start + this.contentsOffset;
        int endOffset = end + this.contentsOffset;
        if (!(startOffset <= this.commandLineText.getCharCount() && start >= 0 || endOffset <= this.commandLineText.getCharCount() && end >= 0)) {
            throw new IllegalArgumentException("Cannot set command line selection, start offset " + start + " and end offset " + end + " are out of commandline bounds");
        }
        if (startOffset > this.commandLineText.getCharCount() || start < 0) {
            throw new IllegalArgumentException("Cannot set command line selection, start offset " + start + " is out of commandline bounds");
        }
        if (endOffset > this.commandLineText.getCharCount() || end < 0) {
            throw new IllegalArgumentException("Cannot set command line selection, end offset " + end + " is out of commandline bounds");
        }
        this.commandLineText.setSelection(startOffset, endOffset);
    }

    public void close() {
        this.commandLineText.setVisible(false);
        this.commandLineText.setEditable(true);
        this.registerModeSelection = null;
        this.prompt = "";
        this.contentsOffset = 0;
        this.resetContents("");
        this.commandLineText.setWordWrap(true);
        this.readOnly = false;
        this.copyItem.setEnabled(false);
        this.cutItem.setEnabled(false);
        this.pasteItem.setEnabled(true);
    }

    public void setMode(CommandLineUI.CommandLineMode mode) {
        if (mode == CommandLineUI.CommandLineMode.DEFAULT) {
            this.commandLineText.setEditable(true);
            if (this.registerModeSelection != null) {
                this.commandLineText.replaceTextRange(this.registerModeSelection.x, 1, "");
                this.commandLineText.setSelection(this.registerModeSelection.x);
                this.registerModeSelection = null;
            } else if (this.readOnly) {
                this.commandLineText.setSelection(this.commandLineText.getCaretOffset());
            }
            this.readOnly = false;
        } else if (mode == CommandLineUI.CommandLineMode.REGISTER) {
            if (this.registerModeSelection == null) {
                Point sel = this.commandLineText.getSelection();
                int leftOffset = Math.min(sel.x, sel.y);
                this.commandLineText.replaceTextRange(leftOffset, 0, "\"");
                this.registerModeSelection = sel;
                this.readOnly = true;
            }
        } else if (mode == CommandLineUI.CommandLineMode.MESSAGE || mode == CommandLineUI.CommandLineMode.MESSAGE_CLIPPED) {
            this.commandLineText.setEditable(false);
            this.setPosition(0);
            this.commandLineText.setTopIndex(0);
            this.readOnly = true;
            this.pasteItem.setEnabled(false);
            this.commandLineText.setWordWrap(mode == CommandLineUI.CommandLineMode.MESSAGE);
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void addOffsetToPosition(int offset) {
        int endOffset;
        if (offset == 0) {
            return;
        }
        int newOffset = this.commandLineText.getCaretOffset() + offset;
        if (newOffset > (endOffset = this.commandLineText.getCharCount())) {
            newOffset = endOffset;
        } else if (newOffset < this.contentsOffset) {
            newOffset = this.contentsOffset;
        }
        this.commandLineText.setCaretOffset(newOffset);
    }

    public void erase() {
        this.clipSelection();
        if (this.commandLineText.getSelectionCount() > 0) {
            this.commandLineText.insert("");
        } else {
            int startOffset = this.commandLineText.getCaretOffset();
            if (startOffset > this.contentsOffset) {
                this.commandLineText.replaceTextRange(startOffset - 1, 1, "");
                this.updateCaret();
            }
        }
        this.updateUISize();
    }

    public void delete() {
        this.clipSelection();
        if (this.commandLineText.getSelectionCount() > 0) {
            this.commandLineText.insert("");
        } else {
            int startOffset = this.commandLineText.getCaretOffset();
            if (startOffset < this.commandLineText.getCharCount()) {
                this.commandLineText.replaceTextRange(startOffset, 1, "");
            }
        }
        this.updateCaret();
    }

    public int getEndPosition() {
        return this.commandLineText.getCharCount() - this.contentsOffset;
    }

    public void replace(int start, int end, String text) {
        int startOffset = start + this.contentsOffset;
        int endOffset = end + this.contentsOffset;
        this.commandLineText.replaceTextRange(startOffset, endOffset - startOffset, text);
        this.updateUISize();
    }

    public void dispose() {
        this.endCharCaret.dispose();
        this.cutItem.dispose();
        this.copyItem.dispose();
        this.pasteItem.dispose();
        this.selectAllItem.dispose();
        this.contextMenu.dispose();
    }

    public void caretMoved(CaretEvent event) {
        this.updateCaret();
    }

    protected void updateCaret() {
        if (this.commandLineText.getCaretOffset() == this.commandLineText.getCharCount()) {
            this.commandLineText.setCaret(this.endCharCaret);
        } else {
            this.commandLineText.setCaret(this.defaultCaret);
        }
    }

    protected void clipSelection() {
        if (this.commandLineText.getSelectionCount() > 0) {
            Point sel = this.commandLineText.getSelection();
            boolean isReversed = this.commandLineText.getCaretOffset() == sel.x;
            int leftOffset = sel.x;
            int rightOffset = sel.y;
            if (leftOffset < this.contentsOffset) {
                leftOffset = this.contentsOffset;
            }
            if (rightOffset < this.contentsOffset) {
                rightOffset = this.contentsOffset;
            }
            Point newSel = isReversed ? new Point(rightOffset, leftOffset) : new Point(leftOffset, rightOffset);
            this.commandLineText.setSelection(newSel);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.clipSelection();
        int selectionLen = Math.abs(e.y - e.x);
        this.cutItem.setEnabled(!this.readOnly && selectionLen > 0);
        this.copyItem.setEnabled(selectionLen > 0);
        this.pasteItem.setEnabled(!this.readOnly);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setWidth(int width) {
        Point size = this.commandLineText.getSize();
        this.commandLineText.setSize(width, size.y);
        this.width = width;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    protected void updateUISize() {
        if (this.commandLineText == null || this.commandLineText.isDisposed()) {
            VrapperLog.error((String)"Command line UI is already disposed or nulled.");
            return;
        }
        Point preferredSize = this.commandLineText.computeSize(this.width, -1, true);
        int selHeight = Math.min(preferredSize.y, this.maxHeight);
        this.commandLineText.setSize(this.width, selHeight);
        if (this.bottom > 0) {
            this.commandLineText.setLocation(0, this.bottom - selHeight);
        }
        this.commandLineText.redraw();
    }

    public boolean isLastLineShown() {
        int bottomLine = this.commandLineText.getLineIndex(this.commandLineText.getBounds().y);
        return bottomLine >= this.commandLineText.getLineCount() - 1;
    }

    public void scrollDown(boolean wholeScreen) {
        int topLine = this.commandLineText.getTopIndex();
        if (wholeScreen) {
            int bottomLine = this.commandLineText.getLineIndex(this.commandLineText.getBounds().y - 1);
            int nLines = bottomLine - topLine;
            this.commandLineText.setTopIndex(topLine + nLines);
        } else {
            this.commandLineText.setTopIndex(topLine);
        }
    }
}

