/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.eclipse.interceptor.VimInputInterceptorFactory;
import net.sourceforge.vrapper.eclipse.ui.EclipseCommandLineUI;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CommandLineUIFactory {
    private static final int COMMAND_CHAR_INDENT = 5;
    private final StyledText parent;
    private StyledText commandLineText;
    private EclipseCommandLineUI commandLineUI;
    private InputInterceptor inputInterceptor;

    public CommandLineUIFactory(StyledText parentText) {
        this.parent = parentText;
        StyledText widget = new StyledText((Composite)this.parent, 16896);
        try {
            Method method = widget.getClass().getMethod("setAlwaysShowScrollBars", Boolean.TYPE);
            method.invoke((Object)widget, false);
        }
        catch (SecurityException e) {
            VrapperLog.info((String)("No permissions to use reflection on StyledText widget. " + e));
        }
        catch (IllegalArgumentException e) {
            VrapperLog.info((String)("Wrong method signature for StyledText method. " + e));
        }
        catch (IllegalAccessException e) {
            VrapperLog.info((String)("No access to StyledText method. " + e));
        }
        catch (InvocationTargetException e) {
            VrapperLog.error((String)"Unexpected error while setting always show scrollbars property", (Throwable)e);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        widget.setFont(this.parent.getFont());
        widget.setMargins(5, 3, 3, 3);
        widget.setSize(5, 5);
        widget.setBackground(this.parent.getBackground());
        widget.setForeground(this.parent.getForeground());
        widget.setWordWrap(true);
        widget.setEnabled(true);
        widget.moveAbove((Control)this.parent);
        widget.setVisible(false);
        widget.addPaintListener((PaintListener)new BorderPaintListener());
        this.commandLineText = widget;
        this.parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CommandLineUIFactory.this.commandLineUI == null || !CommandLineUIFactory.this.commandLineUI.isOpen()) {
                            return;
                        }
                        CommandLineUIFactory.this.parent.redraw();
                        CommandLineUIFactory.this.parent.update();
                        CommandLineUIFactory.this.commandLineUI.updateUISize();
                    }
                });
            }
        });
        this.parent.addPaintListener((PaintListener)new TextEditorPaintListener());
        this.parent.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (CommandLineUIFactory.this.commandLineUI != null && CommandLineUIFactory.this.commandLineUI.isOpen()) {
                    CommandLineUIFactory.this.commandLineText.forceFocus();
                }
            }
        });
        this.parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommandLineUIFactory.this.commandLineText.dispose();
                if (CommandLineUIFactory.this.commandLineUI != null) {
                    CommandLineUIFactory.this.commandLineUI.dispose();
                }
            }
        });
    }

    public CommandLineUI createCommandLineUI(EditorAdaptor editorAdaptor) {
        if (this.inputInterceptor == null) {
            this.inputInterceptor = VimInputInterceptorFactory.INSTANCE.createInterceptor(editorAdaptor);
            this.commandLineText.addVerifyKeyListener((VerifyKeyListener)this.inputInterceptor);
        }
        if (this.commandLineUI == null) {
            this.commandLineUI = new EclipseCommandLineUI(this.commandLineText, editorAdaptor);
        }
        return this.commandLineUI;
    }

    class BorderPaintListener
    implements PaintListener {
        BorderPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            StyledText parent = (StyledText)e.widget;
            Rectangle r = parent.getBounds();
            r = new Rectangle(0, 0, r.width - 1, r.height - 1);
            e.gc.setForeground(parent.getForeground());
            e.gc.setBackground(parent.getForeground());
            e.gc.setLineWidth(1);
            e.gc.drawRectangle(r);
        }
    }

    class TextEditorPaintListener
    implements PaintListener {
        private int horScroll = 0;
        private int verScroll = 0;

        TextEditorPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            if (CommandLineUIFactory.this.commandLineUI == null || !CommandLineUIFactory.this.commandLineUI.isOpen()) {
                return;
            }
            final StyledText parent = (StyledText)e.widget;
            e.gc.setForeground(parent.getForeground());
            e.gc.setBackground(parent.getBackground());
            int newHScroll = 0;
            int newVScroll = 0;
            int bottom = parent.getBounds().height;
            if (parent.getHorizontalBar() != null) {
                bottom -= parent.getHorizontalBar().getSize().y;
                newHScroll = parent.getHorizontalBar().getSelection();
            }
            int right = parent.getBounds().width;
            if (parent.getVerticalBar() != null) {
                right -= parent.getVerticalBar().getSize().x;
                newVScroll = parent.getVerticalBar().getSelection();
            }
            CommandLineUIFactory.this.commandLineUI.setMaxHeight(parent.getBounds().height / 2);
            CommandLineUIFactory.this.commandLineUI.setWidth(right - 1);
            CommandLineUIFactory.this.commandLineUI.setBottom(bottom);
            Point size = CommandLineUIFactory.this.commandLineText.getSize();
            if (this.horScroll == newHScroll && this.verScroll == newVScroll) {
                CommandLineUIFactory.this.commandLineText.setLocation(0, bottom - size.y);
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        parent.update();
                        CommandLineUIFactory.this.commandLineText.redraw();
                        CommandLineUIFactory.this.commandLineText.update();
                    }
                });
            } else {
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        parent.redraw();
                        parent.update();
                    }
                });
                this.horScroll = newHScroll;
                this.verScroll = newVScroll;
            }
        }
    }
}

