/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.ui;

import net.sourceforge.vrapper.utils.CaretType;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;

public class CaretUtils {
    public static Caret createCaret(CaretType caretType, StyledText styledText) {
        GC gc = new GC((Drawable)styledText);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        EvilCaret caret = new EvilCaret((Canvas)styledText, 0, height);
        switch (caretType) {
            case VERTICAL_BAR: {
                caret.setSize(2, height);
                break;
            }
            case RECTANGULAR: {
                caret.setSize(width, height);
                break;
            }
            case LEFT_SHIFTED_RECTANGULAR: {
                caret.setSize(width, height);
                caret.setShiftLeft(true);
                break;
            }
            case HALF_RECT: {
                caret.setSize(width, height / 2);
                break;
            }
            case UNDERLINE: {
                caret.setSize(width, 3);
                break;
            }
            case OVERLINE: {
                caret.setSize(width, 3);
                caret.setShiftTop(false);
            }
        }
        return caret;
    }

    private static final class EvilCaret
    extends Caret {
        private final int textHeight;
        private boolean shiftLeft;
        private boolean shiftTop;
        private boolean isReentrant;

        private EvilCaret(Canvas parent, int style, int textHeight) {
            super(parent, style);
            this.textHeight = textHeight;
            this.shiftTop = true;
        }

        protected void checkSubclass() {
        }

        public void setLocation(int x, int y) {
            boolean temp = this.isReentrant;
            try {
                if (!this.isReentrant) {
                    Point p = this.shift(new Point(x, y));
                    x = p.x;
                    y = p.y;
                    this.isReentrant = true;
                }
                super.setLocation(x, y);
            }
            finally {
                this.isReentrant = temp;
            }
        }

        public void setLocation(Point location) {
            boolean temp = this.isReentrant;
            try {
                Point p = location;
                if (!this.isReentrant) {
                    p = this.shift(location);
                    this.isReentrant = true;
                }
                super.setLocation(p);
            }
            finally {
                this.isReentrant = temp;
            }
        }

        public void setBounds(int x, int y, int width, int height) {
            boolean temp = this.isReentrant;
            try {
                if (!this.isReentrant) {
                    Point p = this.shift(new Point(x, y));
                    x = p.x;
                    y = p.y;
                    this.isReentrant = true;
                }
                super.setBounds(x, y, width, height);
            }
            finally {
                this.isReentrant = temp;
            }
        }

        public void setBounds(Rectangle rect) {
            boolean temp = this.isReentrant;
            try {
                Point p = new Point(rect.x, rect.y);
                if (!this.isReentrant) {
                    p = this.shift(p);
                    this.isReentrant = true;
                }
                super.setBounds(new Rectangle(p.x, p.y, rect.width, rect.height));
            }
            finally {
                this.isReentrant = temp;
            }
        }

        private Point shift(Point p) {
            int x = p.x;
            int y = p.y;
            if (this.shiftLeft) {
                x -= this.getSize().x;
            }
            if (this.shiftTop) {
                y += this.textHeight - this.getSize().y;
            }
            return new Point(x, y);
        }

        private void setShiftLeft(boolean shift) {
            this.shiftLeft = shift;
        }

        private void setShiftTop(boolean shift) {
            this.shiftTop = shift;
        }
    }
}

