/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.List;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.platform.PlatformSpecificTextObjectProvider;
import net.sourceforge.vrapper.vim.TextObjectProvider;
import net.sourceforge.vrapper.vim.commands.DelimitedText;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class UnionTextObjectProvider
implements PlatformSpecificTextObjectProvider {
    private String name;
    private State<DelimitedText> delimitedTexts = EmptyState.getInstance();
    private State<TextObject> textObjects = EmptyState.getInstance();

    public UnionTextObjectProvider(String name, List<PlatformSpecificTextObjectProvider> providers) {
        this.name = name;
        for (TextObjectProvider textObjectProvider : providers) {
            State providerDelimitedTexts = textObjectProvider.delimitedTexts();
            if (providerDelimitedTexts == null) {
                throw new NullPointerException(String.valueOf(textObjectProvider.getClass().getCanonicalName()) + "#delimitedTexts() returned null!");
            }
            this.delimitedTexts = this.delimitedTexts.union(providerDelimitedTexts);
            State providerTextObjects = textObjectProvider.textObjects();
            if (providerTextObjects == null) {
                throw new NullPointerException(String.valueOf(textObjectProvider.getClass().getCanonicalName()) + "#textObjects() returned null!");
            }
            this.textObjects = this.textObjects.union(providerTextObjects);
        }
    }

    public State<DelimitedText> delimitedTexts() {
        return this.delimitedTexts;
    }

    public State<TextObject> textObjects() {
        return this.textObjects;
    }

    public String getName() {
        return this.name;
    }
}

