/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.Locale;
import net.sourceforge.vrapper.eclipse.platform.OffsetConverter;
import net.sourceforge.vrapper.utils.AbstractPosition;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Space;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;

public class TextViewerPosition
extends AbstractPosition {
    private final ITextViewerExtension5 converter;
    private final Space space;
    private final int offset;

    public TextViewerPosition(ITextViewer textViewer, Space space, int offset) {
        this.converter = OffsetConverter.create(textViewer);
        this.space = space;
        this.offset = offset;
    }

    public TextViewerPosition(ITextViewerExtension5 converter, Space space, int offset) {
        this.converter = converter;
        this.space = space;
        this.offset = offset;
    }

    public Position addModelOffset(int delta) {
        return new TextViewerPosition(this.converter, Space.MODEL, this.getModelOffset() + delta);
    }

    public Position addViewOffset(int delta) {
        return new TextViewerPosition(this.converter, Space.VIEW, this.getViewOffset() + delta);
    }

    public int getModelOffset() {
        switch (this.space) {
            case MODEL: {
                return this.offset;
            }
            case VIEW: {
                return this.converter.widgetOffset2ModelOffset(this.offset);
            }
        }
        throw new RuntimeException("bad space: " + this.space);
    }

    public int getViewOffset() {
        switch (this.space) {
            case VIEW: {
                return this.offset;
            }
            case MODEL: {
                return this.converter.modelOffset2WidgetOffset(this.offset);
            }
        }
        throw new RuntimeException("bad space: " + this.space);
    }

    public Position setModelOffset(int offset) {
        return new TextViewerPosition(this.converter, Space.MODEL, offset);
    }

    public Position setViewOffset(int offset) {
        return new TextViewerPosition(this.converter, Space.VIEW, offset);
    }

    public String toString() {
        String spaceId = "?";
        if (this.space != null) {
            spaceId = this.space.name().substring(0, 1).toUpperCase(Locale.ENGLISH);
        }
        return String.valueOf(spaceId) + ' ' + this.offset;
    }
}

