/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import net.sourceforge.vrapper.eclipse.platform.RegisterSelection;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class SWTClipboardRegister
implements Register {
    private Clipboard clipboard;
    private int clipboardId;

    public SWTClipboardRegister(Display d, int clipboardId) {
        this.clipboardId = clipboardId;
        this.clipboard = new Clipboard(d);
    }

    public RegisterContent getContent() {
        TextBlockRegisterContent registerContent = (TextBlockRegisterContent)this.clipboard.getContents((Transfer)RegisterSelection.getInstance());
        if (registerContent != null) {
            return registerContent;
        }
        String s = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance(), this.clipboardId);
        if (s == null) {
            return RegisterContent.DEFAULT_CONTENT;
        }
        if (s.length() > 0 && (VimUtils.isNewLine((String)("" + s.charAt(0))) || VimUtils.isNewLine((String)("" + s.charAt(s.length() - 1))))) {
            return new StringRegisterContent(ContentType.LINES, s);
        }
        return new StringRegisterContent(ContentType.TEXT, s);
    }

    public void setContent(RegisterContent content) {
        this.setContent(content, true);
    }

    public void setContent(RegisterContent content, boolean copyToUnnamed) {
        ContentType contentType = content.getPayloadType();
        if (contentType == ContentType.TEXT_RECTANGLE) {
            this.clipboard.setContents(new Object[]{content, content.getText()}, new Transfer[]{RegisterSelection.getInstance(), TextTransfer.getInstance()}, this.clipboardId);
        } else {
            String s = content.getText();
            this.clipboard.setContents(new Object[]{s}, new Transfer[]{TextTransfer.getInstance()}, this.clipboardId);
        }
    }
}

