/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.vim.VimConstants;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

class RegisterSelection
extends ByteArrayTransfer {
    private static final String REGISTER = "text/vrapper-block-selection";
    private static final int TYPEID = RegisterSelection.registerType((String)"text/vrapper-block-selection");
    private static RegisterSelection _instance = new RegisterSelection();

    RegisterSelection() {
    }

    public static RegisterSelection getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof TextBlockRegisterContent)) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            TextBlockRegisterContent registerContent = (TextBlockRegisterContent)object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                writeOut.writeInt(registerContent.getPayloadType().ordinal());
                writeOut.writeInt(registerContent.getVisualWidth());
                writeOut.writeInt(registerContent.getNumLines());
                int j = 0;
                while (j < registerContent.getNumLines()) {
                    byte[] buffer = registerContent.getLine(j).getBytes();
                    writeOut.writeInt(buffer.length);
                    writeOut.write(buffer);
                    ++j;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException iOException) {}
        }
    }

    public Object nativeToJava(TransferData transferData) {
        TextBlockRegisterContent registerContent = null;
        if (this.isSupportedType(transferData)) {
            DataInputStream readIn;
            block7: {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                readIn = new DataInputStream(in);
                ContentType ct = ContentType.values()[readIn.readInt()];
                if (ContentType.TEXT_RECTANGLE.equals((Object)ct)) break block7;
                return null;
            }
            try {
                int vOffset = readIn.readInt();
                int lines = readIn.readInt();
                registerContent = new TextBlockRegisterContent(vOffset, VimConstants.REGISTER_NEWLINE);
                int i = 0;
                while (i < lines) {
                    int len = readIn.readInt();
                    byte[] line = new byte[len];
                    readIn.read(line);
                    registerContent.appendLine(new String(line));
                    ++i;
                }
                readIn.close();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return registerContent;
    }

    protected String[] getTypeNames() {
        return new String[]{REGISTER};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

