/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.vrapper.eclipse.platform.TextViewerPosition;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.HighlightingService;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.utils.Space;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.Options;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class EclipseSearchAndReplaceService
implements SearchAndReplaceService {
    private static final String INC_ANNOTATION_TYPE = "net.sourceforge.vrapper.eclipse.incsearchhighlight";
    private static final String ANNOTATION_TYPE = "net.sourceforge.vrapper.eclipse.searchhighlight";
    private final HighlightingService highlightingService;
    private final Configuration configuration;
    private Search lastHighlightedSearch;
    private List<Object> annotations;
    private Object incSearchAnnotation;
    private ITextViewer textViewer;

    public EclipseSearchAndReplaceService(ITextViewer textViewer, Configuration configuration, HighlightingService highlightingService) {
        this.textViewer = textViewer;
        this.highlightingService = highlightingService;
        this.configuration = configuration;
        this.annotations = Collections.emptyList();
    }

    public SearchResult find(Search search, Position start) {
        try {
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(this.textViewer.getDocument());
            IRegion result = this.find(search, start.getModelOffset(), adapter);
            Position resultPosition = result != null ? start.setModelOffset(result.getOffset()) : null;
            Position endPosition = result != null ? start.setModelOffset(result.getOffset() + result.getLength()) : null;
            return new SearchResult(resultPosition, endPosition);
        }
        catch (BadLocationException badLocationException) {
            return new SearchResult(null, null);
        }
        catch (PatternSyntaxException e) {
            throw new VrapperPlatformException("Regex uses bad format: " + e.getMessage(), (Throwable)e);
        }
    }

    public int replace(int start, int end, String toFind, String replace, String flags) {
        boolean replaceAll = flags.contains("g");
        boolean reportMatches = flags.contains("n");
        boolean caseSensitive = this.isCaseSensitive(toFind, flags);
        int numReplaces = 0;
        toFind = this.convertRegexSearch(toFind);
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(this.textViewer.getDocument());
        try {
            IRegion replacedresult;
            IRegion result = adapter.find(start, toFind, true, caseSensitive, false, true);
            if (result != null && result.getOffset() < end) {
                ++numReplaces;
                if (!reportMatches) {
                    replacedresult = adapter.replace(replace, true);
                    end += replacedresult.getLength() - result.getLength();
                    result = replacedresult;
                }
                result = adapter.find(result.getOffset() + result.getLength(), toFind, true, caseSensitive, false, true);
            }
            while (replaceAll && result != null && result.getOffset() < end) {
                ++numReplaces;
                if (!reportMatches) {
                    replacedresult = adapter.replace(replace, true);
                    end += replacedresult.getLength() - result.getLength();
                    result = replacedresult;
                }
                result = adapter.find(result.getOffset() + result.getLength(), toFind, true, caseSensitive, false, true);
            }
        }
        catch (BadLocationException e) {
            VrapperLog.error((String)("Failed to replace '" + toFind + "'"), (Throwable)e);
        }
        return numReplaces;
    }

    public boolean isCaseSensitive(String toFind, String flags) {
        boolean caseSensitive;
        boolean bl = caseSensitive = (Boolean)this.configuration.get(Options.IGNORE_CASE) == false || (Boolean)this.configuration.get(Options.SMART_CASE) != false && StringUtils.containsUppercase((String)toFind);
        if (flags.contains("i")) {
            caseSensitive = false;
        }
        if (flags.contains("I")) {
            caseSensitive = true;
        }
        return caseSensitive;
    }

    public boolean substitute(int start, String toFind, String flags, String toReplace) {
        boolean success = false;
        try {
            toFind = this.convertRegexSearch(toFind);
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(this.textViewer.getDocument());
            IRegion result = adapter.find(start, toFind, true, this.isCaseSensitive(toFind, flags), false, true);
            if (result != null) {
                adapter.replace(toReplace, true);
                success = true;
            }
        }
        catch (BadLocationException e) {
            VrapperLog.error((String)("Failed to substitute starting from M" + start), (Throwable)e);
        }
        return success;
    }

    private IRegion find(Search search, int begin, FindReplaceDocumentAdapter adapter) throws BadLocationException {
        IRegion result;
        if (search.isRegExSearch()) {
            search = this.convertRegexSearch(search);
        }
        try {
            result = adapter.find(begin, search.getKeyword(), !search.isBackward(), search.isCaseSensitive(), false, search.isRegExSearch());
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to find '" + search.getKeyword() + "' at " + "offset" + begin + ", offset is invalid.", (Throwable)e);
        }
        catch (PatternSyntaxException e) {
            throw new VrapperPlatformException("Failed to find '" + search.getKeyword() + "' at " + "offset" + begin + ", search pattern is invalid.", (Throwable)e);
        }
        return result;
    }

    private Search convertRegexSearch(Search search) {
        String keyword = search.getKeyword();
        keyword = this.convertRegexSearch(keyword);
        return new Search(keyword, search.isBackward(), search.isCaseSensitive(), search.getSearchOffset(), search.isRegExSearch());
    }

    private String convertRegexSearch(String keyword) {
        String boundaries = (String)this.configuration.get(Options.KEYWORDS);
        keyword = keyword.replaceAll("\\\\k", "[" + boundaries + "]");
        keyword = keyword.replaceAll("\\\\<", "(?<![" + boundaries + "])");
        return keyword.replaceAll("\\\\>", "(?![" + boundaries + "])");
    }

    public void removeHighlighting() {
        this.lastHighlightedSearch = null;
        this.highlightingService.removeHighlights(this.annotations);
        this.annotations = Collections.emptyList();
    }

    public void highlight(Search search) {
        if (this.lastHighlightedSearch != null && this.lastHighlightedSearch.getKeyword().equals(search.getKeyword()) && this.lastHighlightedSearch.isCaseSensitive() == search.isCaseSensitive()) {
            return;
        }
        this.removeHighlighting();
        if (search.isBackward()) {
            search = search.reverse();
        }
        Region result = new Region(0, 0);
        this.annotations = new ArrayList<Object>();
        this.lastHighlightedSearch = search;
        try {
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(this.textViewer.getDocument());
            ArrayList<TextRange> rangesToHL = new ArrayList<TextRange>();
            TextViewerPosition temp = new TextViewerPosition(this.textViewer, Space.MODEL, 0);
            while ((result = this.find(search, result.getOffset() + result.getLength(), adapter)) != null) {
                Position start = temp.setModelOffset(result.getOffset());
                Position end = temp.setModelOffset(result.getOffset() + result.getLength());
                rangesToHL.add(StartEndTextRange.exclusive((Position)start, (Position)end));
            }
            this.annotations = this.highlightingService.highlightRegions(ANNOTATION_TYPE, "Vrapper Search", rangesToHL);
        }
        catch (BadLocationException e) {
            VrapperLog.error((String)"while highlighting search", (Throwable)e);
        }
    }

    public void incSearchhighlight(Position start, int length) {
        this.removeIncSearchHighlighting();
        this.incSearchAnnotation = this.highlightingService.highlightRegion(INC_ANNOTATION_TYPE, "Incremental Search", start.getModelOffset(), length);
    }

    public void removeIncSearchHighlighting() {
        if (this.incSearchAnnotation != null) {
            this.highlightingService.removeHighlighting(this.incSearchAnnotation);
        }
    }
}

