/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import net.sourceforge.vrapper.platform.HistoryService;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;

public class EclipseHistoryService
implements IUndoManager,
IUndoManagerExtension,
HistoryService {
    private final IUndoManager delegate;
    private boolean locked;
    private String lockName = "";
    private final ITextViewer textViewer;

    public EclipseHistoryService(ITextViewer textViewer, IUndoManager delegate) {
        this.textViewer = textViewer;
        this.delegate = delegate;
    }

    public void lock(String name) {
        if (!this.locked) {
            this.locked = true;
            this.lockName = name;
        }
    }

    public void unlock(String name) {
        if (this.locked && this.lockName.equals(name)) {
            this.locked = false;
            this.lockName = "";
        }
    }

    public void lock() {
        this.lock("unnamed");
    }

    public void unlock() {
        this.unlock("unnamed");
    }

    public void beginCompoundChange() {
        if (!this.locked) {
            this.delegate.beginCompoundChange();
        }
    }

    public void endCompoundChange() {
        if (!this.locked) {
            this.delegate.endCompoundChange();
        }
    }

    public void connect(ITextViewer arg0) {
        this.delegate.connect(arg0);
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    public void undo() {
        this.delegate.undo();
        this.deselectAll();
    }

    public void redo() {
        this.delegate.redo();
        this.deselectAll();
    }

    public boolean undoable() {
        return this.delegate.undoable();
    }

    public boolean redoable() {
        return this.delegate.redoable();
    }

    public void reset() {
        this.delegate.reset();
    }

    public void setMaximalUndoLevel(int arg0) {
        this.delegate.setMaximalUndoLevel(arg0);
    }

    private void deselectAll() {
        int caretOffset = this.textViewer.getSelectedRange().x;
        this.textViewer.setSelectedRange(caretOffset, 0);
    }

    public IUndoContext getUndoContext() {
        if (this.delegate instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)this.delegate).getUndoContext();
        }
        return null;
    }
}

