/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.FileService;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EclipseFileService
implements FileService {
    private final AbstractTextEditor editor;
    private String lastFindPath;
    private String lastFindPrevious;

    public EclipseFileService(AbstractTextEditor editor) {
        this.editor = editor;
    }

    public boolean openInGvim(String gvimpath, String gvimargs, int row, int col) throws IOException {
        IFile currentFile;
        if (this.editor.isDirty()) {
            this.editor.doSave(null);
        }
        if ((currentFile = this.getCurrentFile()) == null) {
            throw new IOException("Current editor did not have an associated IFile.");
        }
        String filePath = currentFile.getRawLocation().toString();
        String[] defaultCmd = new String[]{gvimpath, "+" + row, "-c normal zv" + col + "|", "-c set nobackup", "-f", "-n", filePath};
        String[] customCmd = new String[]{};
        if (gvimargs.length() > 0) {
            String gvimArgsExpanded = gvimargs.replace("{line}", "" + row).replace("{col}", "" + col).replace("{file}", filePath);
            ArrayList<String> args = new ArrayList<String>();
            args.add(gvimpath);
            Matcher m = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(gvimArgsExpanded);
            while (m.find()) {
                if (m.group(1) != null) {
                    args.add(m.group(1));
                    continue;
                }
                args.add(m.group(2));
            }
            customCmd = args.toArray(new String[args.size()]);
        }
        final String[] cmd = gvimargs.length() > 0 ? customCmd : defaultCmd;
        new Thread(){

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                    EclipseFileService.this.runCommand("org.eclipse.ui.file.refresh");
                }
                catch (Exception e) {
                    VrapperLog.error((String)e.getMessage());
                }
            }
        }.start();
        return true;
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public boolean checkModifiable() {
        return this.editor.validateEditorInputState();
    }

    public boolean isReadOnly() {
        return this.editor.isEditorInputReadOnly();
    }

    private boolean runCommand(String commandId) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(commandId, null);
        }
        catch (CommandException commandException) {
            return false;
        }
        return true;
    }

    public boolean refreshFile() {
        return this.runCommand("org.eclipse.ui.file.refresh");
    }

    public boolean revertFile() {
        return this.runCommand("org.eclipse.ui.file.revert");
    }

    public boolean close(boolean force) {
        if (force || !this.editor.isDirty()) {
            final IWorkbenchPage workbenchPage = this.editor.getSite().getPage();
            final IEditorPart topLevelEditor = workbenchPage.getActiveEditor();
            this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    workbenchPage.closeEditor(topLevelEditor, false);
                }
            });
            return true;
        }
        return false;
    }

    public boolean closeAll(boolean force) {
        boolean success = false;
        IWorkbenchPage page = this.editor.getSite().getPage();
        if (force || page.getDirtyEditors().length == 0) {
            success = this.closeOthers(force);
            success = success && this.close(force);
        }
        return success;
    }

    public boolean closeOthers(boolean force) {
        IWorkbenchPage page = this.editor.getSite().getPage();
        if (page.getEditorReferences().length < 2) {
            return true;
        }
        boolean success = force || page.getDirtyEditors().length == 0;
        IEditorPart current = page.getActiveEditor();
        IEditorReference[] references = page.getEditorReferences();
        ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart editor = reference.getEditor(false);
            if (editor == null || !editor.equals(current) && (force || !editor.isDirty())) {
                toClose.add(reference);
            }
            ++n2;
        }
        page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), false);
        return success;
    }

    public boolean save() {
        if (this.editor.isDirty() && this.editor.isEditable()) {
            return this.runCommand("org.eclipse.ui.file.save");
        }
        return false;
    }

    public boolean saveAll() {
        return this.runCommand("org.eclipse.ui.file.saveAll");
    }

    public boolean createFile(String filename) {
        IProject project = this.getCurrentSelectedProject();
        IFile file = project.getFile(filename);
        if (file.exists()) {
            return false;
        }
        try {
            file.create(new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            }, false, null);
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public String findFileInPath(String filename, String previous, boolean reverse, String[] paths) {
        List<String> dirs = this.expandPathNames(paths);
        if (reverse) {
            Collections.reverse(dirs);
        }
        if (this.lastFindPath != null && this.lastFindPrevious.equals(previous)) {
            int i = 0;
            while (i < dirs.size()) {
                if (dirs.get(0).equals(this.lastFindPath)) break;
                dirs.add(dirs.remove(0));
                ++i;
            }
        }
        for (String path : dirs) {
            IContainer dir = this.resolvePath(path);
            String fullPath = this.findNextMatchWithPrefix(filename, previous, reverse, dir);
            if (fullPath.equals(filename)) continue;
            this.lastFindPath = path;
            this.lastFindPrevious = fullPath;
            return fullPath;
        }
        return filename;
    }

    public String getDirPathMatch(String prefix, String previous, boolean reverse, String startDir) {
        String file;
        while (!(file = this.getFilePathMatch(prefix, previous, reverse, startDir)).equals(prefix) && !file.endsWith("/")) {
            previous = file;
        }
        return file;
    }

    public String getFilePathMatch(String prefix, String previous, boolean reverse, String startDir) {
        Object start;
        IProject project = this.getCurrentSelectedProject();
        boolean absolutePath = false;
        if (prefix.startsWith("/")) {
            absolutePath = true;
            start = project;
            prefix = prefix.substring(1);
            if (previous != null && previous.startsWith("/")) {
                previous = previous.substring(1);
            }
        } else {
            start = "".equals(startDir) || "/".equals(startDir) ? project : (".".equals(startDir) ? this.getCurrentFileDir() : project.getFolder(startDir));
        }
        String unresolvedPathToPrefix = "";
        if (prefix.contains("../")) {
            unresolvedPathToPrefix = prefix.substring(0, prefix.lastIndexOf(47) + 1);
            prefix = prefix.substring(prefix.lastIndexOf(47) + 1);
            if (previous != null && previous.startsWith(unresolvedPathToPrefix)) {
                previous = previous.substring(unresolvedPathToPrefix.length());
            }
            start = absolutePath ? this.resolvePath("/" + unresolvedPathToPrefix) : this.resolvePath(String.valueOf(startDir) + "/" + unresolvedPathToPrefix);
        }
        String nextMatch = "..".equals(prefix) || prefix.endsWith("/..") ? (previous != null ? prefix : String.valueOf(prefix) + "/") : this.findNextMatchWithPrefix(prefix, previous, reverse, (IContainer)start);
        if (unresolvedPathToPrefix.length() > 0) {
            nextMatch = String.valueOf(unresolvedPathToPrefix) + nextMatch;
        }
        if (absolutePath) {
            nextMatch = "/" + nextMatch;
        }
        return nextMatch;
    }

    private String findNextMatchWithPrefix(String prefix, String previous, boolean reverse, IContainer startDir) {
        boolean foundPrevious = previous == null;
        try {
            IResource[] toSearch = startDir.members();
            if (reverse) {
                Collections.reverse(Arrays.asList(toSearch));
            }
            IResource[] iResourceArray = toSearch;
            int n = toSearch.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String path = resource.getName();
                if (resource.getType() == 2) {
                    path = String.valueOf(path) + '/';
                }
                if (resource.getType() == 2 && prefix.startsWith(path)) {
                    if (previous != null && previous.startsWith(path)) {
                        previous = previous.substring(path.length());
                    }
                    return String.valueOf(path) + this.findNextMatchWithPrefix(prefix.substring(path.length()), previous, reverse, (IContainer)((IFolder)resource));
                }
                if (!foundPrevious) {
                    if (path.equals(previous) || resource.getProjectRelativePath().toString().equals(previous)) {
                        foundPrevious = true;
                    }
                } else if (path.startsWith(prefix)) {
                    return path;
                }
                ++n2;
            }
            if (!foundPrevious) {
                return this.findNextMatchWithPrefix(prefix, null, reverse, startDir);
            }
        }
        catch (CoreException coreException) {
            return prefix;
        }
        return prefix;
    }

    public boolean findAndOpenFile(String filename, String[] paths) {
        List<String> expandedPaths = this.expandPathNames(paths);
        String fullPath = filename;
        for (String path : expandedPaths) {
            IContainer dir = this.resolvePath(path);
            if (dir.findMember(filename) == null) continue;
            fullPath = String.valueOf(dir.getProjectRelativePath().toString()) + '/' + filename;
            break;
        }
        return this.openFile(fullPath);
    }

    public boolean openFile(String filename) {
        IFile fileToBeOpened;
        if (filename == null || filename.length() == 0) {
            return false;
        }
        IProject project = this.getCurrentSelectedProject();
        if (project == null) {
            return false;
        }
        if (filename.startsWith("./")) {
            String file = filename.substring(1);
            String dir = this.resolvePath(".").getProjectRelativePath().toString();
            filename = String.valueOf(dir) + file;
        }
        if (!(fileToBeOpened = project.getFile(filename)).exists()) {
            return false;
        }
        FileEditorInput editorInput = new FileEditorInput(fileToBeOpened);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileToBeOpened.getName());
        try {
            if (desc == null) {
                page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor");
            } else {
                page.openEditor((IEditorInput)editorInput, desc.getId());
            }
        }
        catch (PartInitException partInitException) {
            return false;
        }
        return true;
    }

    public String getCurrentFilePath() {
        return "/" + this.getCurrentFileDir().getProjectRelativePath().toString();
    }

    public String getCurrentFileName() {
        return "/" + this.getCurrentFile().getProjectRelativePath().toString();
    }

    public String getFileNameOfGlobalMark(String name) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMarker mark = null;
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = root.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                if (m.getAttribute("message", "--").equals(name)) {
                    mark = m;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        if (mark == null) {
            return "";
        }
        return "/" + mark.getResource().getProjectRelativePath().toString();
    }

    private List<String> expandPathNames(String[] paths) {
        ArrayList<String> dirs = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.endsWith("**")) {
                List<String> expandedDirs = this.getWildcardDirectoryNames(path);
                dirs.addAll(expandedDirs);
            } else {
                dirs.add(path);
            }
            ++n2;
        }
        return dirs;
    }

    private List<String> getWildcardDirectoryNames(String path) {
        Object start = path.equals("**") ? this.getCurrentSelectedProject() : this.resolvePath(path.substring(0, path.indexOf(42)));
        ArrayList<IResource> folders = new ArrayList<IResource>();
        try {
            folders.add((IResource)start);
            IResource[] members = start.members();
            this.getAllDirectories(folders, members);
        }
        catch (CoreException coreException) {
            return new ArrayList<String>();
        }
        ArrayList<String> dirs = new ArrayList<String>();
        for (IResource folder : folders) {
            dirs.add(folder.getProjectRelativePath().toString());
        }
        Collections.sort(dirs);
        if (path.equals("**") || path.equals("/**")) {
            int i = 0;
            while (i < dirs.size()) {
                if (dirs.get(i).equals("")) {
                    dirs.remove(i);
                    dirs.add(0, "/");
                }
                ++i;
            }
        }
        return dirs;
    }

    private void getAllDirectories(List<IResource> folders, IResource[] members) throws CoreException {
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 2) {
                folders.add(member);
                this.getAllDirectories(folders, ((IContainer)member).members());
            }
            ++n2;
        }
    }

    private IContainer resolvePath(String path) {
        Object dir;
        IProject project = this.getCurrentSelectedProject();
        if (path.equals("/")) {
            dir = project;
        } else if (path.equals(".") || path.equals("")) {
            dir = this.getCurrentFileDir();
        } else if (path.contains("../")) {
            String[] pieces;
            dir = path.startsWith("/") ? project : this.getCurrentFileDir();
            String[] stringArray = pieces = path.split("/");
            int n = pieces.length;
            int n2 = 0;
            while (n2 < n) {
                String piece = stringArray[n2];
                if (!"".equals(piece)) {
                    if ("..".equals(piece)) {
                        if (!dir.getProjectRelativePath().toString().equals("")) {
                            dir = dir.getParent();
                        }
                    } else {
                        dir = project.getFolder(String.valueOf(dir.getProjectRelativePath().toString()) + "/" + piece);
                    }
                }
                ++n2;
            }
        } else {
            dir = project.getFolder(path);
        }
        return dir;
    }

    private IProject getCurrentSelectedProject() {
        IFile file = this.getCurrentFile();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    private IContainer getCurrentFileDir() {
        IFile file = this.getCurrentFile();
        if (file != null) {
            IProject project = file.getProject();
            String dir = file.getParent().getProjectRelativePath().toString();
            return "".equals(dir) ? project : project.getFolder(dir);
        }
        return null;
    }

    private IFile getCurrentFile() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editorPart = activeWindow.getActivePage().getActiveEditor();
        if (editorPart != null) {
            IEditorInput input = editorPart.getEditorInput();
            return (IFile)input.getAdapter(IFile.class);
        }
        return null;
    }

    public String getCurrentFileLocation() throws IOException {
        IFile currentFile = this.getCurrentFile();
        if (currentFile == null) {
            throw new IOException("Current editor did not have an associated IFile.");
        }
        return currentFile.getRawLocation().makeAbsolute().toOSString();
    }
}

