/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.modes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.eclipse.interceptor.UnknownEditorException;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class InsertExpandMode
extends InsertMode {
    public static final String NAME = InsertExpandMode.class.getName();
    public static final String DISPLAY_NAME = "^X mode (^L^N^P)";
    private static final Pattern indentPattern = Pattern.compile("(^\\s*)\\S*");
    private ITextEditor textEditor;
    private String lastIndent = "";
    private String lastPrefix = "";
    private String lastSuffix = "";
    private List<String> lastMatches = new ArrayList<String>();
    private int lastIndex = 0;
    private int lastLineNo = 0;

    public InsertExpandMode(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        super(editorAdaptor);
        InputInterceptor interceptor;
        try {
            interceptor = VrapperPlugin.getDefault().findActiveInterceptor();
        }
        catch (VrapperPlatformException e) {
            CommandExecutionException e2 = new CommandExecutionException("Failed to initialize InsertExpandMode.");
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (UnknownEditorException e) {
            CommandExecutionException e2 = new CommandExecutionException("Failed to initialize InsertExpandMode.");
            e2.initCause((Throwable)e);
            throw e2;
        }
        assert (editorAdaptor.equals(interceptor.getEditorAdaptor()));
        this.textEditor = interceptor.getPlatform().getUnderlyingEditor();
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public boolean handleKey(KeyStroke stroke) {
        if (stroke.equals(ConstructorWrappers.ctrlKey((char)'l'))) {
            this.doLineCompletion(1, true);
            return true;
        }
        if (stroke.equals(ConstructorWrappers.ctrlKey((char)'n'))) {
            this.doLineCompletion(1, false);
            return true;
        }
        if (stroke.equals(ConstructorWrappers.ctrlKey((char)'p'))) {
            this.doLineCompletion(-1, false);
            return true;
        }
        this.clearLineMatches();
        this.editorAdaptor.changeModeSafely("insert mode", new ModeSwitchHint[]{InsertMode.RESUME_ON_MODE_ENTER});
        return super.handleKey(stroke);
    }

    private void doLineCompletion(int step, boolean nextLine) {
        TextContent model = this.editorAdaptor.getModelContent();
        Position cursorPos = this.editorAdaptor.getCursorService().getPosition();
        int cursorOffset = cursorPos.getModelOffset();
        LineInformation lineInfo = model.getLineInformationOfOffset(cursorOffset);
        String line = model.getText(lineInfo.getBeginOffset(), lineInfo.getLength());
        if (this.lastLineNo != lineInfo.getNumber() || !line.equals(String.valueOf(this.lastIndent) + this.lastPrefix) && this.lastIndex == 0) {
            this.rebuildLineMatches(cursorOffset - lineInfo.getBeginOffset(), line, lineInfo.getNumber());
        }
        if (this.lastMatches.size() == 1) {
            this.editorAdaptor.getUserInterfaceService().setErrorMessage("Pattern not found");
        } else {
            this.lastIndex = (this.lastIndex + step) % this.lastMatches.size();
            String newString = String.valueOf(this.lastIndent) + this.lastMatches.get(this.lastIndex) + this.lastSuffix;
            model.replace(lineInfo.getBeginOffset(), lineInfo.getLength(), newString);
            int newCursor = lineInfo.getBeginOffset() + this.lastIndent.length() + this.lastMatches.get(this.lastIndex).length();
            this.editorAdaptor.getCursorService().setPosition(cursorPos.setModelOffset(newCursor), StickyColumnPolicy.ON_CHANGE);
            if (this.lastIndex == 0) {
                this.editorAdaptor.getUserInterfaceService().setInfoMessage("Back at original");
            } else {
                this.editorAdaptor.getUserInterfaceService().setInfoMessage("match " + this.lastIndex + " of " + (this.lastMatches.size() - 1));
            }
        }
    }

    private void rebuildLineMatches(int cursorPos, String line, int lineNo) {
        List<IDocument> hippieDocuments = this.computeDocuments(this.textEditor);
        Matcher matcher = indentPattern.matcher(line);
        this.lastIndent = matcher.find() ? matcher.group(1) : "";
        this.lastPrefix = line.substring(this.lastIndent.length(), cursorPos);
        this.lastSuffix = line.substring(cursorPos);
        this.lastLineNo = lineNo;
        this.lastIndex = 0;
        this.lastMatches.clear();
        this.lastMatches.add(this.lastPrefix);
        HashSet<String> alreadySeen = new HashSet<String>();
        alreadySeen.add(this.lastPrefix);
        alreadySeen.add("");
        try {
            for (IDocument model : hippieDocuments) {
                int i = 0;
                while (i < model.getNumberOfLines()) {
                    IRegion matchLine = model.getLineInformation(i);
                    String matchText = model.get(matchLine.getOffset(), matchLine.getLength());
                    if ((matchText = matchText.replaceFirst("^\\s+", "")).startsWith(this.lastPrefix) && !alreadySeen.contains(matchText)) {
                        this.lastMatches.add(matchText);
                        alreadySeen.add(matchText);
                    }
                    ++i;
                }
            }
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to find line completions", (Throwable)e);
        }
    }

    private List<IDocument> computeDocuments(ITextEditor currentTextEditor) {
        ArrayList<IDocument> documentsForSearch = new ArrayList<IDocument>();
        if (currentTextEditor == null) {
            return documentsForSearch;
        }
        IDocumentProvider provider = currentTextEditor.getDocumentProvider();
        if (provider == null) {
            return documentsForSearch;
        }
        IDocument currentDocument = provider.getDocument((Object)currentTextEditor.getEditorInput());
        if (currentDocument == null) {
            return documentsForSearch;
        }
        ArrayList<IDocument> computedDocuments = new ArrayList<IDocument>();
        IWorkbenchWindow window = currentTextEditor.getSite().getWorkbenchWindow();
        IEditorReference[] editorsArray = window.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorsArray.length) {
            IDocument doc;
            ITextEditor textEditor;
            IEditorPart realEditor = editorsArray[i].getEditor(false);
            if (realEditor instanceof ITextEditor && !realEditor.equals(currentTextEditor) && (provider = (textEditor = (ITextEditor)realEditor).getDocumentProvider()) != null && (doc = provider.getDocument((Object)textEditor.getEditorInput())) != null) {
                computedDocuments.add(doc);
            }
            ++i;
        }
        computedDocuments.add(0, currentDocument);
        return computedDocuments;
    }

    private void clearLineMatches() {
        this.lastIndex = 0;
        this.lastMatches.clear();
        this.lastLineNo = 0;
        this.lastIndent = "";
        this.lastPrefix = "";
        this.lastSuffix = "";
    }
}

