/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.keymap;

import java.util.HashMap;
import java.util.Queue;
import net.sourceforge.vrapper.eclipse.commands.EclipseCommand;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.KeyMapInfo;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.PlatformSpecificStateProvider;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.TextObjectProvider;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.commandline.CommandLineMode;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;
import net.sourceforge.vrapper.vim.modes.commandline.EvaluatorMapping;
import org.eclipse.core.runtime.IConfigurationElement;

public class AbstractEclipseSpecificStateProvider
implements PlatformSpecificStateProvider,
Comparable<AbstractEclipseSpecificStateProvider> {
    protected final HashMap<String, State<Command>> states = new HashMap();
    protected final HashMap<String, State<KeyMapInfo>> keyMaps = new HashMap();
    protected final EvaluatorMapping commands = new EvaluatorMapping();
    protected int priority = 1;
    protected String name;
    protected TextObjectProvider textObjectProvider;

    protected AbstractEclipseSpecificStateProvider() {
    }

    public void configure(IConfigurationElement config) {
        try {
            String stringValue = config.getAttribute("priority");
            this.name = config.getAttribute("name");
            if (stringValue != null) {
                this.priority = Integer.parseInt(stringValue);
            }
        }
        catch (NumberFormatException e) {
            VrapperLog.error((String)"wrong format of priority", (Throwable)e);
        }
    }

    public final void initializeProvider(TextObjectProvider textObjProvider) {
        this.textObjectProvider = textObjProvider;
        this.states.put("normal mode", this.normalModeBindings());
        this.states.put("all visual modes", this.visualModeBindings());
        this.keyMaps.put("normal mode", this.normalModeKeymap());
        this.keyMaps.put("all visual modes", this.visualModeKeymap());
        this.states.put("insert mode", this.insertModeBindings());
        this.states.put("content assist", this.contentAssistModeBindings());
    }

    protected State<Command> normalModeBindings() {
        return EmptyState.getInstance();
    }

    protected State<KeyMapInfo> normalModeKeymap() {
        return EmptyState.getInstance();
    }

    protected State<Command> visualModeBindings() {
        return EmptyState.getInstance();
    }

    protected State<KeyMapInfo> visualModeKeymap() {
        return EmptyState.getInstance();
    }

    protected State<Command> insertModeBindings() {
        return EmptyState.getInstance();
    }

    protected State<Command> contentAssistModeBindings() {
        return EmptyState.getInstance();
    }

    protected static Command go(String where) {
        return new EclipseCommand("org.eclipse.ui.edit.text.goto." + where);
    }

    protected static Command cmd(String command) {
        return new EclipseCommand(command);
    }

    protected static EclipseCommand editText(String command) {
        return new EclipseCommand("org.eclipse.ui.edit.text." + command);
    }

    public String getName() {
        return this.name;
    }

    public String getFileType() {
        return "text";
    }

    public State<Command> getState(String modeName) {
        return this.states.get(modeName);
    }

    public State<KeyMapInfo> getKeyMaps(String name) {
        return this.keyMaps.get(name);
    }

    public final EvaluatorMapping getCommands() {
        return this.commands;
    }

    protected void addFormatCommands(Command formatAll) {
        if (formatAll != null) {
            this.commands.add("formatall", formatAll);
            this.commands.add("format", formatAll);
            this.commands.add("fmt", formatAll);
            this.commands.add("fm", formatAll);
        }
    }

    @Override
    public int compareTo(AbstractEclipseSpecificStateProvider o) {
        return -Integer.valueOf(this.priority).compareTo(o.priority);
    }

    protected static class EclipseActionEvaluator
    implements Evaluator {
        private boolean force;
        private boolean async;

        protected EclipseActionEvaluator(boolean force, boolean async) {
            this.force = force;
            this.async = async;
        }

        public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
            String name = command.poll();
            if ("!".equals(name)) {
                this.force = true;
                name = command.poll();
            }
            String action = command.poll();
            if (name != null && action != null) {
                CommandLineMode mode = (CommandLineMode)vim.getMode("command mode");
                mode.addCommand(name, (Command)new EclipseCommand(action, this.async), this.force);
            }
            return null;
        }
    }
}

