/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.eclipse.platform.EclipseCursorAndSelection;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.vim.DefaultEditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;
import net.sourceforge.vrapper.vim.modes.CommandBasedMode;
import net.sourceforge.vrapper.vim.modes.EditorMode;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.NormalMode;
import net.sourceforge.vrapper.vim.modes.TemporaryMode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionVisualHandler
implements ISelectionChangedListener {
    private DefaultEditorAdaptor editorAdaptor;
    private EclipseCursorAndSelection selectionService;
    private ITextViewer textViewer;
    private int selectionResetOffset = -1;

    public SelectionVisualHandler(DefaultEditorAdaptor editorAdaptor, EclipseCursorAndSelection selectionService, ITextViewer viewer) {
        this.editorAdaptor = editorAdaptor;
        this.textViewer = viewer;
        this.selectionService = selectionService;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!VrapperPlugin.isVrapperEnabled() || !(event.getSelection() instanceof TextSelection) || this.selectionService.isSelectionInProgress()) {
            return;
        }
        TextSelection selection = (TextSelection)event.getSelection();
        if (selection.getLength() == 0) {
            this.selectionService.setSelection(null);
            try {
                int offset = selection.getOffset();
                IRegion lineInfo = this.textViewer.getDocument().getLineInformationOfOffset(offset);
                this.selectionResetOffset = lineInfo.getOffset() + lineInfo.getLength() == offset ? offset : -1;
            }
            catch (BadLocationException e) {
                VrapperLog.error((String)"Received bad selection offset in selectionchange handler", (Throwable)e);
            }
            EditorMode currentMode = this.editorAdaptor.getMode(this.editorAdaptor.getCurrentModeName());
            if (currentMode instanceof TemporaryMode) {
                this.editorAdaptor.changeModeSafely("insert mode", new ModeSwitchHint[0]);
            } else if (currentMode instanceof AbstractVisualMode) {
                this.editorAdaptor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
            } else if (currentMode instanceof CommandBasedMode) {
                CommandBasedMode commandMode = (CommandBasedMode)currentMode;
                commandMode.placeCursor(StickyColumnPolicy.RESET_EOL);
            }
        } else {
            if (!VrapperPlugin.isMouseDown() || !((Boolean)this.editorAdaptor.getConfiguration().get(Options.VISUAL_MOUSE)).booleanValue()) {
                if (this.editorAdaptor.getCurrentMode() instanceof NormalMode) {
                    ((CommandBasedMode)this.editorAdaptor.getCurrentMode()).placeCursor(StickyColumnPolicy.NEVER);
                }
                return;
            }
            if (this.selectionResetOffset != -1 && selection.getOffset() + selection.getLength() + 1 == this.selectionResetOffset) {
                this.textViewer.setSelectedRange(this.selectionResetOffset, -(selection.getLength() + 1));
                this.selectionResetOffset = -1;
            } else if (selection.getLength() != 0) {
                if ("normal mode".equals(this.editorAdaptor.getCurrentModeName())) {
                    this.editorAdaptor.changeModeSafely("visual mode", new ModeSwitchHint[]{AbstractVisualMode.KEEP_SELECTION_HINT});
                } else if ("insert mode".equals(this.editorAdaptor.getCurrentModeName())) {
                    this.editorAdaptor.changeModeSafely("temporary visual mode", new ModeSwitchHint[]{AbstractVisualMode.KEEP_SELECTION_HINT, InsertMode.DONT_MOVE_CURSOR});
                }
                this.editorAdaptor.rememberLastActiveSelection();
            }
        }
    }
}

