/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.widgets.Display;

public class LinkedModeHandler
implements IDocumentListener,
ILinkedModeListener {
    private final EditorAdaptor hintReceiver;

    public LinkedModeHandler(EditorAdaptor editorAdaptor) {
        this.hintReceiver = editorAdaptor;
    }

    public void onCheckForLinkedMode(final IDocument document) {
        Display current = Display.getCurrent();
        if (current != null) {
            current.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LinkedModeHandler.this.checkInternal(document);
                }
            });
        }
    }

    protected void checkInternal(IDocument document) {
        LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)0);
        if (model != null) {
            model.removeLinkingListener((ILinkedModeListener)this);
            model.addLinkingListener((ILinkedModeListener)this);
            String mode = this.hintReceiver.getCurrentModeName();
            if (VrapperPlugin.isVrapperEnabled() && !"insert mode".equals(mode) && !"content assist".equals(mode) && !"normal mode".equals(mode)) {
                this.hintReceiver.changeModeSafely("normal mode", new ModeSwitchHint[0]);
                this.hintReceiver.setSelection(null);
            }
        }
    }

    public void left(LinkedModeModel model, int flags) {
        if (VrapperPlugin.isVrapperEnabled() && (flags & 1) != 0) {
            this.hintReceiver.changeModeSafely("normal mode", new ModeSwitchHint[0]);
        }
    }

    public void suspend(LinkedModeModel model) {
    }

    public void resume(LinkedModeModel model, int flags) {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.onCheckForLinkedMode(event.fDocument);
    }

    public static void registerListener(IDocument document, LinkedModeHandler handler) {
        document.addDocumentListener((IDocumentListener)handler);
    }

    public static void unregisterListener(IDocument document, LinkedModeHandler handler) {
        document.removeDocumentListener((IDocumentListener)handler);
    }
}

