/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import org.eclipse.ui.IEditorPart;

public class EditorInfo {
    protected Map<IEditorPart, EditorInfo> childEditors = new IdentityHashMap<IEditorPart, EditorInfo>();
    protected EditorInfo parent;
    protected IEditorPart current;

    protected EditorInfo(IEditorPart current) {
        this.current = current;
    }

    protected EditorInfo(EditorInfo parent, IEditorPart current) {
        this.parent = parent;
        this.current = current;
    }

    public EditorInfo createChildInfo(IEditorPart editorPart) {
        if (editorPart == null) {
            throw new VrapperPlatformException("Child editor cannot be null! Error while traversing " + this.current);
        }
        EditorInfo child = new EditorInfo(this, editorPart);
        this.childEditors.put(editorPart, child);
        return child;
    }

    public Map<IEditorPart, EditorInfo> getChildEditors() {
        return Collections.unmodifiableMap(this.childEditors);
    }

    public void setChildEditors(Set<IEditorPart> childEditors) {
        this.childEditors = new IdentityHashMap<IEditorPart, EditorInfo>();
        for (IEditorPart editor : childEditors) {
            this.childEditors.put(editor, new EditorInfo(editor));
        }
    }

    public EditorInfo getChild(IEditorPart subPart) {
        return this.childEditors.get(subPart);
    }

    public boolean isTopLevelEditor() {
        return this.parent == null;
    }

    public boolean isSimpleEditor() {
        return this.parent == null && this.childEditors.isEmpty();
    }

    public IEditorPart getTopLevelEditor() {
        if (this.parent == null) {
            return this.current;
        }
        return this.parent.getTopLevelEditor();
    }

    public EditorInfo getParentInfo() {
        return this.parent;
    }

    public IEditorPart getCurrent() {
        return this.current;
    }
}

