/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import java.util.WeakHashMap;
import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.VrapperEventAdapter;
import net.sourceforge.vrapper.vim.modes.EditorMode;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.text.ITextViewer;

public class CaretPositionUndoHandler
extends VrapperEventAdapter
implements IOperationHistoryListener {
    private ITextViewer textViewer;
    private EditorAdaptor editorAdaptor;
    private WeakHashMap<IUndoableOperation, VrapperState> historyInfo;
    private int previousCaretOffset;

    public CaretPositionUndoHandler(EditorAdaptor editorAdaptor, ITextViewer textViewer) {
        this.editorAdaptor = editorAdaptor;
        this.textViewer = textViewer;
        this.historyInfo = new WeakHashMap();
    }

    public void historyNotification(OperationHistoryEvent event) {
        ObjectUndoContext testContext = new ObjectUndoContext((Object)this.textViewer.getDocument());
        boolean isHandlerEnabled = (Boolean)this.editorAdaptor.getConfiguration().get(Options.UNDO_MOVES_CURSOR);
        if (VrapperPlugin.isVrapperEnabled() && isHandlerEnabled && event.getOperation().hasContext((IUndoContext)testContext)) {
            switch (event.getEventType()) {
                case 1: {
                    this.previousCaretOffset = this.textViewer.getSelectedRange().x;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (this.previousCaretOffset != -1) {
                        this.historyInfo.put(event.getOperation(), new VrapperState(this.previousCaretOffset));
                    }
                    this.previousCaretOffset = -1;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    VrapperState state = this.historyInfo.get(event.getOperation());
                    if (state == null) break;
                    this.textViewer.setSelectedRange(state.caretOffset, 0);
                    break;
                }
                default: {
                    VrapperLog.info((String)("Unknown history event type " + event.getEventType()));
                }
            }
        }
    }

    public void commandAboutToExecute(EditorMode mode) {
        this.previousCaretOffset = this.textViewer.getSelectedRange().x;
    }

    public void commandExecuted(EditorMode mode) {
        this.previousCaretOffset = -1;
    }

    protected static class VrapperState {
        public int caretOffset;

        public VrapperState(int caretOffset) {
            this.caretOffset = caretOffset;
        }
    }
}

