/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.vim.DefaultEditorAdaptor;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.EditorMode;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.NormalMode;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class CaretPositionHandler
implements CaretListener,
MouseListener {
    private boolean caretMoved;
    private ITextViewer textViewer;
    private DefaultEditorAdaptor editorAdaptor;

    public CaretPositionHandler(DefaultEditorAdaptor editorAdaptor, ITextViewer textViewer) {
        this.editorAdaptor = editorAdaptor;
        this.textViewer = textViewer;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseDown(MouseEvent e) {
        EditorMode mode = CaretPositionHandler.getCurrentMode((EditorAdaptor)this.editorAdaptor);
        if (!VrapperPlugin.isVrapperEnabled() || !this.caretMoved || !(mode instanceof NormalMode) && !(mode instanceof InsertMode)) {
            return;
        }
        StyledText w = this.textViewer.getTextWidget();
        if (mode instanceof NormalMode) {
            w.setRedraw(false);
            try {
                try {
                    int currentOffset = w.getCaretOffset();
                    int lineNo = w.getLineAtOffset(currentOffset);
                    int lineStartOffset = w.getOffsetAtLine(lineNo);
                    String lineContents = w.getLine(lineNo);
                    int lineEndOffset = lineStartOffset + lineContents.length();
                    if (currentOffset != lineEndOffset) return;
                    this.editorAdaptor.getCursorService().setCaret(CaretType.LEFT_SHIFTED_RECTANGULAR);
                    return;
                }
                catch (RuntimeException ex) {
                    VrapperLog.error((String)"CaretPositionHandler failed on mouse click.", (Throwable)ex);
                    w.setRedraw(true);
                }
                return;
            }
            finally {
                w.setRedraw(true);
            }
        } else {
            if (!(mode instanceof InsertMode)) return;
            ((InsertMode)mode).resetEditingSession();
        }
    }

    public void mouseUp(MouseEvent e) {
        EditorMode mode = CaretPositionHandler.getCurrentMode((EditorAdaptor)this.editorAdaptor);
        int selectionLength = this.textViewer.getSelectedRange().y;
        if (!(VrapperPlugin.isVrapperEnabled() && this.caretMoved && selectionLength <= 0 && mode instanceof NormalMode)) {
            this.caretMoved = false;
            return;
        }
        this.textViewer.getTextWidget().setRedraw(false);
        try {
            this.editorAdaptor.getCursorService().setCaret(CaretType.RECTANGULAR);
            NormalMode normalMode = (NormalMode)mode;
            normalMode.placeCursor(StickyColumnPolicy.RESET_EOL);
        }
        finally {
            this.textViewer.getTextWidget().setRedraw(true);
            this.caretMoved = false;
        }
    }

    public void caretMoved(CaretEvent event) {
        this.caretMoved = VrapperPlugin.isMouseDown();
    }

    protected static EditorMode getCurrentMode(EditorAdaptor editorAdaptor) {
        return editorAdaptor.getMode(editorAdaptor.getCurrentModeName());
    }
}

