/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class BufferInfo {
    public final int bufferId;
    public IEditorInput input;
    public final IEditorReference reference;
    public String editorType;
    public IEditorInput parentInput;
    public WeakReference<IEditorPart> lastSeenEditor;
    public WeakHashMap<IWorkbenchWindow, Void> seenWindows = new WeakHashMap();

    public BufferInfo(int bufferId, IEditorPart editorPart, IEditorInput parentInput, String documentType, IEditorInput subResourceInput) {
        this.bufferId = bufferId;
        this.parentInput = parentInput;
        this.input = subResourceInput;
        this.editorType = documentType;
        this.reference = null;
        this.lastSeenEditor = new WeakReference<IEditorPart>(editorPart);
        this.seenWindows.put(editorPart.getEditorSite().getWorkbenchWindow(), null);
    }

    public BufferInfo(int bufferId, IEditorReference editorReference, String pluginId) {
        this.bufferId = bufferId;
        this.parentInput = null;
        this.input = null;
        this.editorType = pluginId;
        this.reference = editorReference;
        this.seenWindows.put(editorReference.getPage().getWorkbenchWindow(), null);
    }

    public String getDisplayName() {
        if (this.input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)this.input;
            return fileInput.getFile().getFullPath().toFile().getPath();
        }
        if (this.input != null) {
            return this.input.getName();
        }
        if (this.reference != null) {
            return this.reference.getPartName();
        }
        return "?";
    }
}

