/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.commands;

import net.sourceforge.vrapper.eclipse.commands.EclipseCommand;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BorderPolicy;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.motions.CountAwareMotion;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class EclipseCommandMotion
extends CountAwareMotion {
    private final String motionName;
    private final BorderPolicy borderPolicy;

    public EclipseCommandMotion(String motionName, BorderPolicy borderPolicy) {
        this.motionName = motionName;
        this.borderPolicy = borderPolicy;
    }

    public BorderPolicy borderPolicy() {
        return this.borderPolicy;
    }

    public Position destination(EditorAdaptor editorAdaptor) {
        return this.destination(editorAdaptor, 1);
    }

    public Position destination(EditorAdaptor editorAdaptor, int count) {
        Position oldCarretOffset = editorAdaptor.getPosition();
        if (count == 0) {
            count = 1;
        }
        int i = 0;
        while (i < count) {
            EclipseCommand.doIt(this.motionName, editorAdaptor, false);
            ++i;
        }
        Position newCarretOffset = editorAdaptor.getPosition();
        editorAdaptor.setPosition(oldCarretOffset, StickyColumnPolicy.ON_CHANGE);
        return newCarretOffset;
    }

    public StickyColumnPolicy stickyColumnPolicy() {
        return StickyColumnPolicy.ON_CHANGE;
    }

    public Command command() {
        return new EclipseCommand(this.motionName);
    }
}

