/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.activator;

import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptorManager;
import net.sourceforge.vrapper.eclipse.interceptor.UnknownEditorException;
import net.sourceforge.vrapper.log.Log;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class VrapperPlugin
extends AbstractUIPlugin
implements IStartup,
Log {
    public static final String PLUGIN_ID = "net.sourceforge.vrapper.eclipse";
    static VrapperPlugin plugin;
    private static boolean vrapperEnabled;
    private static final String KEY_VRAPPER_ENABLED = "vrapperEnabled";
    private static final String COMMAND_TOGGLE_VRAPPER = "net.sourceforge.vrapper.eclipse.commands.toggle";
    private static final IPreferencesService PREFERENCES_SERVICE;
    private static final IEclipsePreferences PLUGIN_PREFERENCES;
    private static MouseButtonListener mouseButton;
    private boolean debugLogEnabled = Boolean.parseBoolean(System.getProperty("vrapper.debuglog")) || Boolean.parseBoolean(Platform.getDebugOption((String)"net.sourceforge.vrapper.eclipse/debug"));

    static {
        PREFERENCES_SERVICE = Platform.getPreferencesService();
        PLUGIN_PREFERENCES = new InstanceScope().getNode(PLUGIN_ID);
        mouseButton = new MouseButtonListener();
    }

    public InputInterceptor findActiveInterceptor() throws VrapperPlatformException, UnknownEditorException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        return InputInterceptorManager.INSTANCE.findActiveInterceptor((IWorkbenchPart)activeEditor);
    }

    public InputInterceptor findActiveInterceptor(IEditorPart toplevelEditor) throws VrapperPlatformException, UnknownEditorException {
        return InputInterceptorManager.INSTANCE.findActiveInterceptor((IWorkbenchPart)toplevelEditor);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        VrapperLog.setImplementation((Log)this);
    }

    public void earlyStartup() {
    }

    public void stop(BundleContext context) throws Exception {
        this.preShutdown();
        plugin = null;
        VrapperLog.setImplementation(null);
        super.stop(context);
    }

    private void preShutdown() throws BackingStoreException {
        VrapperPlugin.storeVimEmulationOfActiveEditors();
    }

    void restoreVimEmulationInActiveEditors() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = plugin.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    InputInterceptorManager.INSTANCE.registerEditorRef(ref);
                    InputInterceptorManager.INSTANCE.partOpened((IWorkbenchPartReference)ref);
                    ++n6;
                }
                if (page.getActiveEditor() != null) {
                    IWorkbenchPartReference partReference = page.getReference((IWorkbenchPart)page.getActiveEditor());
                    InputInterceptorManager.INSTANCE.partActivated(partReference);
                }
                ++n4;
            }
            ++n2;
        }
        this.addEditorListeners();
    }

    void addEditorListeners() {
        IWorkbenchWindow[] iWorkbenchWindowArray = plugin.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            VrapperPlugin.addInterceptingListener(window);
            ++n2;
        }
        plugin.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                VrapperPlugin.addInterceptingListener(window);
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }
        });
    }

    private static void addInterceptingListener(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)InputInterceptorManager.INSTANCE);
        window.getWorkbench().getDisplay().addFilter(3, (Listener)mouseButton);
        window.getWorkbench().getDisplay().addFilter(4, (Listener)mouseButton);
    }

    void addShutdownListener() {
        this.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench arg0) {
            }

            public boolean preShutdown(IWorkbench arg0, boolean arg1) {
                try {
                    VrapperPlugin.storeVimEmulationOfActiveEditors();
                }
                catch (BackingStoreException e) {
                    VrapperLog.error((String)"Error storing vrapper toggle state", (Throwable)e);
                }
                return true;
            }
        });
    }

    private static void storeVimEmulationOfActiveEditors() throws BackingStoreException {
        PLUGIN_PREFERENCES.clear();
        PLUGIN_PREFERENCES.putBoolean(KEY_VRAPPER_ENABLED, vrapperEnabled);
    }

    void toggleVrapper() {
        boolean enable = PREFERENCES_SERVICE.getBoolean(PLUGIN_ID, KEY_VRAPPER_ENABLED, true, null);
        if (enable) {
            IHandlerService s = (IHandlerService)this.getWorkbench().getService(IHandlerService.class);
            try {
                s.executeCommand(COMMAND_TOGGLE_VRAPPER, null);
            }
            catch (Exception e) {
                VrapperLog.error((String)"Error when toggling Vrapper", (Throwable)e);
            }
        }
    }

    private static void log(int status, String msg, Throwable exception) {
        VrapperPlugin instance = VrapperPlugin.getDefault();
        if (instance != null) {
            instance.getLog().log((IStatus)new Status(status, PLUGIN_ID, msg, exception));
        } else if (status == 4) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void info(String msg) {
        VrapperPlugin.log(1, msg, null);
    }

    public void error(String msg, Throwable exception) {
        VrapperPlugin.log(4, msg, exception);
    }

    public void debug(String msg) {
        if (this.debugLogEnabled) {
            VrapperPlugin.log(1, msg, null);
        }
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugLogEnabled = enabled;
    }

    public boolean isDebugEnabled() {
        return this.debugLogEnabled;
    }

    public static VrapperPlugin getDefault() {
        return plugin;
    }

    public static void setVrapperEnabled(boolean enabled) {
        vrapperEnabled = enabled;
        for (InputInterceptor interceptor : InputInterceptorManager.INSTANCE.getInterceptors().values()) {
            EditorAdaptor adaptor = interceptor.getEditorAdaptor();
            if (adaptor == null) continue;
            adaptor.onChangeEnabled(enabled);
        }
    }

    public static boolean isVrapperEnabled() {
        return vrapperEnabled;
    }

    public static boolean isMouseDown() {
        return mouseButton.down;
    }

    private static final class MouseButtonListener
    implements Listener {
        private boolean down;

        private MouseButtonListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 3) {
                this.down = true;
            } else if (event.type == 4) {
                this.down = false;
            }
        }
    }
}

