/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.search.IndexerCollector;

public class IndexerCollectorNotifier
implements IndexerCollector {
    private final Set<IndexerCollector> listeners = new CopyOnWriteArraySet<IndexerCollector>();
    private final Log logger;

    public IndexerCollectorNotifier(Log logger) {
        this.logger = logger;
    }

    private void handleError(IndexerCollector collector, Exception ex) {
        this.logger.error((Throwable)ex, "Error notifying collector: [%s] ", new Object[]{collector.getClass().getName()});
    }

    public void addCollector(IndexerCollector collector) {
        if (collector != null) {
            this.listeners.add(collector);
        }
    }

    public void removeCollector(IndexerCollector collector) {
        if (collector != null) {
            this.listeners.remove(collector);
        }
    }

    public void onIndexTaskError(Long indexerId, Throwable throwable) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexTaskError(indexerId, throwable);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }

    public void onIndexTaskTotalToProcess(int totalIndexTasks) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexTaskTotalToProcess(totalIndexTasks);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }

    public void onIndexTaskSubmit(Long indexerId) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexTaskSubmit(indexerId);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }

    public void onIndexTaskComplete(Long indexerId, long waitTime, long processingTime) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexTaskComplete(indexerId, waitTime, processingTime);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }

    public void onIndexItemAdded(Long indexerId, long itemId, String word, long codedTag) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexItemAdded(indexerId, itemId, word, codedTag);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }

    public void onIndexItemComplete(Long indexerId, long itemId, int totalTags, long processingTime) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexItemComplete(indexerId, itemId, totalTags, processingTime);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }

    public void onIndexTotalTaskItems(long totalItems) {
        for (IndexerCollector collector : this.listeners) {
            try {
                collector.onIndexTotalTaskItems(totalItems);
            }
            catch (Exception ex) {
                this.handleError(collector, ex);
            }
        }
    }
}

