/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaMapAssocArtToRelatedAttributes;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class BranchMapAssocArtToRelatedAttributesSqlHandler
extends SqlHandler<CriteriaMapAssocArtToRelatedAttributes> {
    private CriteriaMapAssocArtToRelatedAttributes criteria;
    private String branchAlias;
    private String relatedBranchAlias;
    private final List<String> artifactAlias = new LinkedList<String>();
    private final List<String> artifactTxAlias = new LinkedList<String>();
    private final List<String> attributeAlias = new LinkedList<String>();
    private final List<String> attributeTxAlias = new LinkedList<String>();

    @Override
    public void setData(CriteriaMapAssocArtToRelatedAttributes criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.write(String.valueOf(this.relatedBranchAlias) + ".branch_id=" + this.criteria.getRelatedBranch().getId());
        writer.writeAnd();
        Optional firstArtifactAlias = this.artifactAlias.stream().findFirst();
        Optional firstArtifactTxAlias = this.artifactTxAlias.stream().findFirst();
        Optional firstAttrAlias = this.attributeAlias.stream().findFirst();
        Optional firstAttrTxAlias = this.attributeTxAlias.stream().findFirst();
        if (firstArtifactTxAlias.isPresent() && firstArtifactAlias.isPresent() && firstAttrAlias.isPresent() && firstAttrTxAlias.isPresent()) {
            writer.writeEqualsAnd((String)firstArtifactTxAlias.get(), "branch_id", this.relatedBranchAlias, "branch_id");
            writer.write(String.valueOf((String)firstArtifactTxAlias.get()) + ".tx_current=1");
            writer.writeAnd();
            writer.writeEqualsAnd((String)firstArtifactTxAlias.get(), "gamma_id", (String)firstArtifactAlias.get(), "gamma_id");
            writer.write(String.valueOf((String)firstArtifactAlias.get()) + ".art_type_id=" + ((ArtifactTypeToken)((Pair)this.criteria.getArtAttrPairs().get(0)).getFirst()).getIdString());
            writer.writeAnd();
            writer.writeEqualsAnd((String)firstAttrTxAlias.get(), "branch_id", this.relatedBranchAlias, "branch_id");
            writer.write(String.valueOf((String)firstAttrTxAlias.get()) + ".tx_current=1");
            writer.writeAnd();
            writer.writeEqualsAnd((String)firstAttrTxAlias.get(), "gamma_id", (String)firstAttrAlias.get(), "gamma_id");
            writer.writeEqualsAnd((String)firstAttrAlias.get(), "art_id", (String)firstArtifactAlias.get(), "art_id");
            writer.write(String.valueOf((String)firstAttrAlias.get()) + ".attr_type_id=" + ((AttributeTypeToken)((Pair)this.criteria.getArtAttrPairs().get(0)).getSecond()).getIdString());
            writer.writeAnd();
            writer.write(String.valueOf((String)firstAttrAlias.get()) + ".value='" + this.criteria.getRelatedValue() + "'");
            writer.writeAnd();
        }
        String lookupVal = String.valueOf((String)firstAttrAlias.get()) + ".value";
        int i = 1;
        while (i < this.artifactAlias.size() - 1) {
            writer.writeEqualsAnd(this.artifactTxAlias.get(i), "branch_id", this.relatedBranchAlias, "branch_id");
            writer.write(String.valueOf(this.artifactTxAlias.get(i)) + ".tx_current=1");
            writer.writeAnd();
            writer.writeEqualsAnd(this.artifactTxAlias.get(i), "gamma_id", this.artifactAlias.get(i), "gamma_id");
            writer.write(String.valueOf(this.artifactAlias.get(i)) + ".art_type_id=" + ((ArtifactTypeToken)((Pair)this.criteria.getArtAttrPairs().get(i)).getFirst()).getIdString());
            writer.writeAnd();
            writer.writeEqualsAnd(this.attributeTxAlias.get(i), "branch_id", this.relatedBranchAlias, "branch_id");
            writer.write(String.valueOf(this.attributeTxAlias.get(i)) + ".tx_current=1");
            writer.writeAnd();
            writer.writeEqualsAnd(this.attributeTxAlias.get(i), "gamma_id", this.attributeAlias.get(i), "gamma_id");
            writer.writeEquals(this.attributeAlias.get(i), "art_id", this.artifactAlias.get(i), "art_id");
            writer.write(String.valueOf(this.attributeAlias.get(i)) + ".attr_type_id=" + ((AttributeTypeToken)((Pair)this.criteria.getArtAttrPairs().get(i)).getSecond()).getIdString());
            writer.writeAnd();
            writer.write(String.valueOf(this.attributeAlias.get(i)) + lookupVal);
            lookupVal = String.valueOf(this.attributeAlias.get(i)) + ".value";
            ++i;
        }
        Optional lastArtifactAlias = this.artifactAlias.stream().reduce((previous, current) -> current);
        Optional lastArtifactTxAlias = this.artifactTxAlias.stream().reduce((previous, current) -> current);
        Optional lastAttrAlias = this.attributeAlias.stream().reduce((previous, current) -> current);
        Optional lastAttrTxAlias = this.attributeTxAlias.stream().reduce((previous, current) -> current);
        if (lastArtifactTxAlias.isPresent() && lastArtifactAlias.isPresent() && lastAttrAlias.isPresent() && lastAttrTxAlias.isPresent()) {
            writer.writeAnd();
            writer.writeEqualsAnd((String)lastArtifactTxAlias.get(), "branch_id", this.relatedBranchAlias, "branch_id");
            writer.write(String.valueOf((String)lastArtifactTxAlias.get()) + ".tx_current=1");
            writer.writeAnd();
            writer.writeEqualsAnd((String)lastArtifactTxAlias.get(), "gamma_id", (String)lastArtifactAlias.get(), "gamma_id");
            writer.write(String.valueOf((String)lastArtifactAlias.get()) + ".art_type_id=" + ((ArtifactTypeToken)((Pair)this.criteria.getArtAttrPairs().get(this.criteria.getArtAttrPairs().size() - 1)).getFirst()).getIdString());
            writer.writeAnd();
            writer.writeEqualsAnd((String)lastAttrTxAlias.get(), "branch_id", this.relatedBranchAlias, "branch_id");
            writer.write(String.valueOf((String)lastAttrTxAlias.get()) + ".tx_current=1");
            writer.writeAnd();
            writer.writeEqualsAnd((String)lastAttrTxAlias.get(), "gamma_id", (String)lastAttrAlias.get(), "gamma_id");
            writer.writeEqualsAnd((String)lastAttrAlias.get(), "art_id", (String)lastArtifactAlias.get(), "art_id");
            writer.write(String.valueOf((String)lastAttrAlias.get()) + ".attr_type_id=" + ((AttributeTypeToken)((Pair)this.criteria.getArtAttrPairs().get(this.criteria.getArtAttrPairs().size() - 1)).getSecond()).getIdString());
            writer.writeAnd();
            writer.write(String.valueOf((String)lastAttrAlias.get()) + ".value= " + this.artifactAlias.get(this.artifactAlias.size() - 2) + ".art_id" + writer.getJdbcClient().getDbType().getStringConversion());
            writer.writeAnd();
            writer.writeEquals(this.branchAlias, "associated_art_id", (String)lastArtifactAlias.get(), "art_id");
        }
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.branchAlias = writer.getMainTableAlias(OseeDb.BRANCH_TABLE);
        this.relatedBranchAlias = writer.addTable(OseeDb.BRANCH_TABLE);
        int i = 0;
        while (i < this.criteria.getArtAttrPairs().size()) {
            this.artifactAlias.add(writer.addTable(OseeDb.ARTIFACT_TABLE));
            this.attributeAlias.add(writer.addTable(OseeDb.ATTRIBUTE_TABLE));
            this.artifactTxAlias.add(writer.addTable(OseeDb.TXS_TABLE, ObjectType.ARTIFACT));
            this.attributeTxAlias.add(writer.addTable(OseeDb.TXS_TABLE, ObjectType.ATTRIBUTE));
            ++i;
        }
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_MAP_ASSOC_ART_TO_REL_ATTR.ordinal();
    }
}

