/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class PurgeTransactionTxCallable
extends AbstractDatastoreTxCallable<Integer> {
    private static final String UPDATE_TXS_DETAILS_COMMENT = "UPDATE osee_tx_details SET osee_comment = replace(osee_comment, ?, ?) WHERE osee_comment like ?";
    private static final String DELETE_TXS = "delete from osee_txs where branch_id = ? and transaction_id = ?";
    private static final String DELETE_TX_DETAILS = "delete from osee_tx_details where branch_id = ? and transaction_id = ?";
    private static final String SELECT_AFFECTED_ITEMS = "SELECT %s as item_id from osee_txs txs, %s item where txs.branch_id = ? and txs.transaction_id = ? AND txs.gamma_id = item.gamma_id";
    private static final String SELECT_AFFECTED_ITEMS_REL2 = "SELECT %s as id1, %s as id2, %s as id3, %s as id4 from osee_txs txs, %s item where txs.branch_id = ? and txs.transaction_id = ? AND txs.gamma_id = item.gamma_id";
    private static final String FIND_NEW_TX_CURRENTS = "SELECT oj.id as item_id, txs.mod_type, txs.gamma_id, txs.transaction_id from osee_join_id oj, %s item, osee_txs txs where oj.query_id = ? and oj.id = item.%s and item.gamma_id = txs.gamma_id and txs.branch_id = ? order by oj.id desc, txs.transaction_id desc";
    private static final String FIND_NEW_TX_CURRENTS_REL2 = "SELECT oj.id1 as rel_type, oj.id2 as a_art_id, oj.id3 as b_art_id, txs.mod_type, txs.gamma_id, txs.transaction_id from osee_join_id4 oj, %s item, osee_txs txs where oj.query_id = ? and oj.id1 = item.%s and oj.id2 = item.%s and oj.id3 = item.%s and item.gamma_id = txs.gamma_id and txs.branch_id = ? order by oj.id1, oj.id2, oj.id3, txs.transaction_id desc";
    private static final String UPDATE_TX_CURRENT = "update osee_txs set tx_current = ? where branch_id = ? and transaction_id = ? and gamma_id = ?";
    private static final String GET_PRIOR_TRANSACTION = "select max(transaction_id) FROM osee_tx_details where branch_id = ? and transaction_id < ?";
    private static final String SELECT_TRANSACTION_BRANCH_ID = "select branch_id from osee_tx_details WHERE transaction_id = ?";
    private final SqlJoinFactory joinFactory;
    private final Collection<? extends TransactionId> txIdsToDelete;
    private final ActivityLog activityLog;
    private Long previousItem;
    private String previousItemId4;

    public PurgeTransactionTxCallable(ActivityLog activityLog, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, Collection<? extends TransactionId> txIdsToDelete) {
        super(null, session, jdbcClient);
        this.activityLog = activityLog;
        this.joinFactory = joinFactory;
        this.txIdsToDelete = txIdsToDelete;
        this.previousItem = -1L;
        this.previousItemId4 = "-1";
    }

    private List<TransactionId> sortTxs(Collection<? extends TransactionId> txIdsToDelete) {
        ArrayList<TransactionId> txs = new ArrayList<TransactionId>(txIdsToDelete);
        if (txs.size() > 1) {
            Collections.sort(txs, new Comparator<TransactionId>(){

                @Override
                public int compare(TransactionId o1, TransactionId o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
        }
        return txs;
    }

    @Override
    protected Integer handleTxWork(JdbcConnection connection) {
        Conditions.checkNotNull(this.txIdsToDelete, (String)"transaction ids to delete");
        Conditions.checkExpressionFailOnTrue((boolean)this.txIdsToDelete.isEmpty(), (String)"transaction ids to delete cannot be empty", (Object[])new Object[0]);
        List<TransactionId> txIds = this.sortTxs(this.txIdsToDelete);
        int purgeCount = 0;
        for (TransactionId txIdToDelete : txIds) {
            Long logEntryId = this.activityLog.createUpdateableEntry(CoreActivityTypes.PURGE_TRANSACTION, new Object[]{"Purging transaction: " + txIdToDelete.getIdString()});
            ArrayList<Object[]> txsToDelete = new ArrayList<Object[]>();
            BranchId txBranchId = (BranchId)this.getJdbcClient().fetch((Object)BranchId.SENTINEL, SELECT_TRANSACTION_BRANCH_ID, new Object[]{txIdToDelete});
            if (txBranchId.isInvalid()) {
                throw new OseeArgumentException("Cannot find branch for transaction record [%s]", new Object[]{txIdToDelete});
            }
            txsToDelete.add(new Object[]{txBranchId, txIdToDelete});
            TransactionId previousTransactionId = (TransactionId)this.getJdbcClient().fetch((Object)TransactionId.SENTINEL, GET_PRIOR_TRANSACTION, new Object[]{txBranchId, txIdToDelete});
            if (previousTransactionId.isInvalid()) {
                throw new OseeArgumentException("You are trying to delete transaction [%d] which is a baseline transaction.  If your intent is to delete the Branch use the delete Branch Operation.  \n\nNO TRANSACTIONS WERE DELETED.", new Object[]{txIdToDelete});
            }
            StringBuilder artsMsg = new StringBuilder(4000);
            Map<BranchId, IdJoinQuery> arts = this.findAffectedItems(connection, "art_id", "osee_artifact", txsToDelete, artsMsg);
            Map<BranchId, IdJoinQuery> attrs = this.findAffectedItems(connection, "attr_id", "osee_attribute", txsToDelete, null);
            Map<BranchId, IdJoinQuery> rels = this.findAffectedItems(connection, "rel_link_id", "osee_relation_link", txsToDelete, null);
            Map<BranchId, Id4JoinQuery> rels2 = this.findAffectedItemsRel2(connection, "rel_type", "a_art_id", "b_art_id", "osee_relation", txsToDelete, null);
            this.setChildBranchBaselineTxs(connection, txIdToDelete, previousTransactionId);
            this.getJdbcClient().runBatchUpdate(connection, DELETE_TX_DETAILS, txsToDelete);
            this.getJdbcClient().runBatchUpdate(connection, DELETE_TXS, txsToDelete);
            ArrayList<Object[]> updateData = new ArrayList<Object[]>();
            this.computeNewTxCurrents(connection, updateData, "art_id", "osee_artifact", arts);
            this.computeNewTxCurrents(connection, updateData, "attr_id", "osee_attribute", attrs);
            this.computeNewTxCurrents(connection, updateData, "rel_link_id", "osee_relation_link", rels);
            this.computeNewTxCurrentsRel2(connection, updateData, "rel_type", "a_art_id", "b_art_id", "osee_relation", rels2);
            this.getJdbcClient().runBatchUpdate(connection, UPDATE_TX_CURRENT, updateData);
            ++purgeCount;
            this.activityLog.createEntry(CoreActivityTypes.PURGE_TRANSACTION, logEntryId, ActivityLog.COMPLETE_STATUS, new Object[]{"Purged transaction " + txIdToDelete.getIdString() + " with artifacts " + artsMsg});
        }
        return purgeCount;
    }

    private void computeNewTxCurrents(JdbcConnection connection, Collection<Object[]> updateData, String itemId, String tableName, Map<BranchId, IdJoinQuery> affected) {
        String query = String.format(FIND_NEW_TX_CURRENTS, tableName, itemId);
        for (Map.Entry<BranchId, IdJoinQuery> entry : affected.entrySet()) {
            BranchId branch = entry.getKey();
            Throwable throwable = null;
            Object var11_12 = null;
            try (IdJoinQuery joinQuery = entry.getValue();){
                Consumer<JdbcStatement> consumer = stmt -> {
                    Long currentItem = stmt.getLong("item_id");
                    if (this.previousItem != currentItem) {
                        ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
                        TxCurrent txCurrent = TxCurrent.getCurrent((ModificationType)modType);
                        updateData.add(new Object[]{txCurrent, branch, stmt.getLong("transaction_id"), stmt.getLong("gamma_id")});
                        this.previousItem = currentItem;
                    }
                };
                this.getJdbcClient().runQuery(connection, consumer, joinQuery.size() * 2, query, new Object[]{joinQuery.getQueryId(), branch});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void computeNewTxCurrentsRel2(JdbcConnection connection, Collection<Object[]> updateData, String id1, String id2, String id3, String tableName, Map<BranchId, Id4JoinQuery> affected) {
        String query = String.format(FIND_NEW_TX_CURRENTS_REL2, tableName, id1, id2, id3);
        for (Map.Entry<BranchId, Id4JoinQuery> entry : affected.entrySet()) {
            BranchId branch = entry.getKey();
            Throwable throwable = null;
            Object var13_14 = null;
            try (Id4JoinQuery joinQuery = entry.getValue();){
                Consumer<JdbcStatement> consumer = stmt -> {
                    String currentItemId4 = String.valueOf(stmt.getLong(id1)) + "/" + stmt.getLong(id2) + "/" + stmt.getLong(id3);
                    if (!this.previousItemId4.equals(currentItemId4)) {
                        ModificationType modType = ModificationType.valueOf((long)stmt.getInt("mod_type"));
                        TxCurrent txCurrent = TxCurrent.getCurrent((ModificationType)modType);
                        updateData.add(new Object[]{txCurrent, branch, stmt.getLong("transaction_id"), stmt.getLong("gamma_id")});
                        this.previousItemId4 = currentItemId4;
                    }
                };
                this.getJdbcClient().runQuery(connection, consumer, joinQuery.size() * 2, query, new Object[]{joinQuery.getQueryId(), branch});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Map<BranchId, IdJoinQuery> findAffectedItems(JdbcConnection connection, String itemId, String itemTable, List<Object[]> bindDataList, StringBuilder artsMsg) {
        HashMap<BranchId, IdJoinQuery> items = new HashMap<BranchId, IdJoinQuery>();
        try (JdbcStatement statement = this.getJdbcClient().getStatement(connection);){
            for (Object[] bindData : bindDataList) {
                String query = String.format(SELECT_AFFECTED_ITEMS, itemId, itemTable);
                statement.runPreparedQueryWithMaxFetchSize(query, bindData);
                IdJoinQuery joinId = this.joinFactory.createIdJoinQuery();
                items.put((BranchId)bindData[0], joinId);
                while (statement.next()) {
                    Long id = statement.getLong("item_id");
                    if (artsMsg != null && artsMsg.length() < 4000) {
                        artsMsg.append(id);
                        artsMsg.append(",");
                    }
                    joinId.add(id);
                }
                joinId.store();
            }
        }
        return items;
    }

    private Map<BranchId, Id4JoinQuery> findAffectedItemsRel2(JdbcConnection connection, String id1, String id2, String id3, String itemTable, List<Object[]> bindDataList, StringBuilder artsMsg) {
        HashMap<BranchId, Id4JoinQuery> items = new HashMap<BranchId, Id4JoinQuery>();
        try (JdbcStatement statement = this.getJdbcClient().getStatement(connection);){
            for (Object[] bindData : bindDataList) {
                String query = String.format(SELECT_AFFECTED_ITEMS_REL2, id1, id2, id3, null, itemTable);
                statement.runPreparedQueryWithMaxFetchSize(query, bindData);
                Id4JoinQuery joinId = this.joinFactory.createId4JoinQuery();
                items.put((BranchId)bindData[0], joinId);
                while (statement.next()) {
                    Id relType = Id.valueOf((Long)statement.getLong("id1"));
                    Id artA = Id.valueOf((Long)statement.getLong("id2"));
                    Id artB = Id.valueOf((Long)statement.getLong("id3"));
                    if (artsMsg != null && artsMsg.length() < 4000) {
                        artsMsg.append(String.valueOf(relType.toString()) + '/' + artA.toString() + "/" + artB.toString());
                        artsMsg.append(",");
                    }
                    joinId.add(relType, artA, artB);
                }
                joinId.store();
            }
        }
        return items;
    }

    private void setChildBranchBaselineTxs(JdbcConnection connection, TransactionId toDeleteTransactionId, TransactionId previousTransactionId) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        if (previousTransactionId.isValid()) {
            data.add(new Object[]{String.valueOf(toDeleteTransactionId.getId()), String.valueOf(previousTransactionId), "%" + toDeleteTransactionId.getId()});
        }
        if (!data.isEmpty()) {
            this.getJdbcClient().runBatchUpdate(connection, UPDATE_TXS_DETAILS_COMMENT, data);
        }
    }
}

