/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElement;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElementList;
import org.eclipse.osee.framework.core.xml.publishing.WordBody;
import org.eclipse.osee.framework.core.xml.publishing.WordDocument;
import org.eclipse.osee.framework.core.xml.publishing.WordParagraph;
import org.eclipse.osee.framework.core.xml.publishing.WordParagraphList;
import org.eclipse.osee.framework.core.xml.publishing.WordSection;
import org.eclipse.osee.framework.core.xml.publishing.WordSectionList;
import org.eclipse.osee.framework.core.xml.publishing.WordSubSection;
import org.eclipse.osee.framework.core.xml.publishing.WordSubSectionList;
import org.eclipse.osee.framework.core.xml.publishing.WordTable;
import org.eclipse.osee.framework.core.xml.publishing.WordTableColumn;
import org.eclipse.osee.framework.core.xml.publishing.WordTableColumnList;
import org.eclipse.osee.framework.core.xml.publishing.WordTableList;
import org.eclipse.osee.framework.core.xml.publishing.WordTableRow;
import org.eclipse.osee.framework.core.xml.publishing.WordTableRowList;
import org.eclipse.osee.framework.core.xml.publishing.WordText;
import org.eclipse.osee.framework.core.xml.publishing.WordTextList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PublishingXmlUtils {
    public static String WordDocumentTagName = "w:wordDocument";
    public static String BodyTagName = "w:body";
    public static String ParagraphTagName = "w:p";
    public static String SectionTagName = "wx:sect";
    public static String SubSectionTagName = "wx:sub-section";
    public static String TableTagName = "w:tbl";
    public static String TableRowTagName = "w:tr";
    public static String TableColumnTagName = "w:tc";
    public static String TextTagName = "w:t";
    private final ThreadLocal<Cause> lastCause = new ThreadLocal<Cause>(){

        @Override
        protected Cause initialValue() {
            return Cause.OK;
        }
    };
    private final ThreadLocal<Exception> lastError = new ThreadLocal();

    private Optional<Element> findChildElementByTagName(Element parent, String tagName) {
        Node node = parent.getFirstChild();
        while (Objects.nonNull(node)) {
            Element element;
            if (node.getNodeType() == 1 && tagName.equals((element = (Element)node).getTagName())) {
                return Optional.of(element);
            }
            node = node.getNextSibling();
        }
        return Optional.empty();
    }

    public Optional<WordTable> findTableByColumnText(WordDocument wordDocument, int row, int column, int text, String expectedColumnText) {
        this.startOperation();
        try {
            return wordDocument.getWordBody().flatMap(wordBody -> wordBody.getWordTableList()).map(AbstractElementList::stream).orElseGet(Stream::empty).filter(wordTable -> PublishingXmlUtils.rawFindTableColumnText(wordTable, row, column, text).map(foundColumnText -> foundColumnText.equals(expectedColumnText)).orElse(false)).findFirst();
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<String> findTableColumnText(WordTable wordTable, int row, int column, int text) {
        this.startOperation();
        try {
            return PublishingXmlUtils.rawFindTableColumnText(wordTable, row, column, text);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Cause getLastCause() {
        return this.lastCause.get();
    }

    public boolean isOk() {
        return this.lastCause.get().equals((Object)Cause.OK);
    }

    public boolean isKo() {
        return !this.isOk();
    }

    public Optional<Exception> getLastError() {
        return Optional.ofNullable(this.lastError.get());
    }

    public Optional<Document> parse(File file) {
        this.startOperation();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream autoCloseInputStream = new FileInputStream(file);){
                return this.parseInternal(autoCloseInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<Document> parse(InputStream inputStream) {
        this.startOperation();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream autoCloseInputStream = inputStream;){
                return this.parseInternal(autoCloseInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<Document> parse(String xmlString) {
        this.startOperation();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream autoCloseInputStream = new ByteArrayInputStream(xmlString.getBytes());){
                return this.parseInternal(autoCloseInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    private Optional<Document> parseInternal(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        return Optional.of(document);
    }

    private <P extends AbstractElement, L extends AbstractElementList<? super P, ? super C>, C extends AbstractElement> L parseAbstractElementList(P parent, Function<P, L> listFactory, BiFunction<P, Element, C> childFactory, String childTagName) {
        try (AbstractElementList list = (AbstractElementList)listFactory.apply(parent);){
            NodeList nodeList = parent.getElement().getElementsByTagName(childTagName);
            int nodeCount = nodeList.getLength();
            if (nodeCount <= 0) {
                AbstractElementList abstractElementList = list;
                return (L)abstractElementList;
            }
            int i = 0;
            while (i < nodeCount) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    AbstractElement child = (AbstractElement)childFactory.apply(parent, element);
                    list.add(child);
                }
                ++i;
            }
            AbstractElementList abstractElementList = list;
            return (L)abstractElementList;
        }
    }

    private <P extends AbstractElement, L extends AbstractElementList<? super P, ? super C>, C extends AbstractElement> L parseNonNestedAbstractElementList(P parent, Function<P, L> listFactory, BiFunction<P, Element, C> childFactory, String childTagName) {
        try (AbstractElementList list = (AbstractElementList)listFactory.apply(parent);){
            Element possiblyNestedElement;
            NodeList possiblyNestedNodeList = parent.getElement().getElementsByTagName(childTagName);
            int possiblyNestedNodeCount = possiblyNestedNodeList.getLength();
            if (possiblyNestedNodeCount <= 0) {
                AbstractElementList abstractElementList = list;
                return (L)abstractElementList;
            }
            ArrayList<Element> possiblyNestedElementList = new ArrayList<Element>(possiblyNestedNodeCount);
            int possiblyNestedElementCount = 0;
            int i = 0;
            while (i < possiblyNestedNodeCount) {
                Node possiblyNestedNode = possiblyNestedNodeList.item(i);
                if (possiblyNestedNode.getNodeType() == 1) {
                    possiblyNestedElement = (Element)possiblyNestedNode;
                    possiblyNestedElementList.add(possiblyNestedElement);
                    ++possiblyNestedElementCount;
                }
                ++i;
            }
            HashSet<Integer> nestedElementIndexSet = new HashSet<Integer>(possiblyNestedElementCount);
            int i2 = 0;
            while (i2 < possiblyNestedElementCount) {
                possiblyNestedElement = (Element)possiblyNestedElementList.get(i2);
                NodeList subNodeList = possiblyNestedElement.getElementsByTagName(childTagName);
                int subNodeCount = subNodeList.getLength();
                if (subNodeCount > 0) {
                    int j = 0;
                    while (j < subNodeCount) {
                        Node subNode = subNodeList.item(j);
                        Element nestedElement = (Element)possiblyNestedElementList.get(i2 + 1 + j);
                        if (!nestedElement.isSameNode(subNode)) {
                            throw new RuntimeException("I died");
                        }
                        nestedElementIndexSet.add(i2 + 1 + j);
                        ++j;
                    }
                    i2 += subNodeCount;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < possiblyNestedElementCount) {
                if (!nestedElementIndexSet.contains(i2)) {
                    Element firstLevelElement = (Element)possiblyNestedElementList.get(i2);
                    AbstractElement child = (AbstractElement)childFactory.apply(parent, firstLevelElement);
                    list.add(child);
                }
                ++i2;
            }
            AbstractElementList abstractElementList = list;
            return (L)abstractElementList;
        }
    }

    private <P extends AbstractElement, L extends AbstractElementList<? super P, ? super C>, C extends AbstractElement> L parseImmediateChildrenAbstractElementList(P parent, Function<P, L> listFactory, BiFunction<P, Element, C> childFactory, String childTagName) {
        try (AbstractElementList list = (AbstractElementList)listFactory.apply(parent);){
            NodeList childNodeList = parent.getElement().getChildNodes();
            int i = 0;
            while (i < childNodeList.getLength()) {
                Element childElement;
                Node childNode = childNodeList.item(i);
                if (1 == childNode.getNodeType() && childTagName.equals((childElement = (Element)childNode).getNodeName())) {
                    AbstractElement child = (AbstractElement)childFactory.apply(parent, childElement);
                    list.add(child);
                }
                ++i;
            }
            AbstractElementList abstractElementList = list;
            return (L)abstractElementList;
        }
    }

    public Optional<WordBody> parseWordBody(WordDocument wordDocument) {
        this.startOperation();
        try {
            Optional<Element> wordBodyElementOptional = this.findChildElementByTagName(wordDocument.getElement(), BodyTagName);
            if (wordBodyElementOptional.isEmpty()) {
                this.lastCause.set(Cause.NOT_FOUND);
                return Optional.empty();
            }
            Element wordBodyElement = wordBodyElementOptional.get();
            WordBody wordBody = new WordBody(wordDocument, wordBodyElement);
            wordDocument.setChild(wordBody);
            return Optional.of(wordBody);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordDocument> parseWordDocument(Document document) {
        this.startOperation();
        try {
            Element rootElement = document.getDocumentElement();
            if (WordDocumentTagName.equals(rootElement.getTagName())) {
                WordDocument wordDocument = new WordDocument(rootElement);
                return Optional.of(wordDocument);
            }
            this.lastCause.set(Cause.NOT_FOUND);
            return Optional.empty();
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordParagraphList> parseWordParagraphListFromWordSubSection(WordSubSection wordSubSection) {
        this.startOperation();
        try {
            WordParagraphList wordParagraphList = this.parseNonNestedAbstractElementList(wordSubSection, WordParagraphList::new, WordParagraph::new, ParagraphTagName);
            wordSubSection.setChild(wordParagraphList);
            return Optional.of(wordParagraphList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordParagraphList> parseImmediateChildrenWordParagraphListFromWordSubSection(WordSubSection wordSubSection) {
        this.startOperation();
        try {
            WordParagraphList wordParagraphList = this.parseImmediateChildrenAbstractElementList(wordSubSection, WordParagraphList::new, WordParagraph::new, ParagraphTagName);
            wordSubSection.setChild(wordParagraphList);
            return Optional.of(wordParagraphList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordSectionList> parseWordSectionListFromWordBody(WordBody wordBody) {
        this.startOperation();
        try {
            WordSectionList wordSectionList = this.parseNonNestedAbstractElementList(wordBody, WordSectionList::new, WordSection::new, SectionTagName);
            wordBody.setChild(wordSectionList);
            return Optional.of(wordSectionList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordSubSectionList> parseWordSubSectionListFromWordSection(WordSection wordSection) {
        this.startOperation();
        try {
            WordSubSectionList wordSubSectionList = this.parseNonNestedAbstractElementList(wordSection, WordSubSectionList::new, WordSubSection::new, SubSectionTagName);
            wordSection.setChild(wordSubSectionList);
            return Optional.of(wordSubSectionList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordSubSectionList> parseWordSubSectionListFromWordSubSection(WordSubSection wordSubSection) {
        this.startOperation();
        try {
            WordSubSectionList wordSubSectionList = this.parseNonNestedAbstractElementList(wordSubSection, WordSubSectionList::new, WordSubSection::new, SubSectionTagName);
            wordSubSection.setChild(wordSubSectionList);
            return Optional.of(wordSubSectionList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordTableColumnList> parseWordTableColumnListFromWordTableRow(WordTableRow wordTableRow) {
        this.startOperation();
        try {
            WordTableColumnList wordTableColumnList = this.parseNonNestedAbstractElementList(wordTableRow, WordTableColumnList::new, WordTableColumn::new, TableColumnTagName);
            wordTableRow.setChild(wordTableColumnList);
            return Optional.of(wordTableColumnList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordTableList> parseWordTableListFromWordBody(WordBody wordBody) {
        this.startOperation();
        try {
            WordTableList wordTableList = this.parseNonNestedAbstractElementList(wordBody, WordTableList::new, WordTable::new, TableTagName);
            wordBody.setChild(wordTableList);
            return Optional.of(wordTableList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordTableRowList> parseWordTableRowListFromWordTable(WordTable wordTable) {
        this.startOperation();
        try {
            WordTableRowList wordTableRowList = this.parseNonNestedAbstractElementList(wordTable, WordTableRowList::new, WordTableRow::new, TableRowTagName);
            wordTable.setChild(wordTableRowList);
            return Optional.of(wordTableRowList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordTextList> parseWordTextListFromWordParagraph(WordParagraph wordParagraph) {
        this.startOperation();
        try {
            WordTextList wordTextList = this.parseAbstractElementList(wordParagraph, WordTextList::new, WordText::new, TextTagName);
            wordParagraph.setChild(wordTextList);
            return Optional.of(wordTextList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<WordTextList> parseWordTextListFromWordTableColumn(WordTableColumn wordTableColumn) {
        this.startOperation();
        try {
            WordTextList wordTextList = this.parseAbstractElementList(wordTableColumn, WordTextList::new, WordText::new, TextTagName);
            wordTableColumn.setChild(wordTextList);
            return Optional.of(wordTextList);
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    public Optional<String> prettyPrint(Document document) {
        this.startOperation();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return Optional.of(stringWriter.toString());
        }
        catch (Exception e) {
            this.lastCause.set(Cause.ERROR);
            this.lastError.set(e);
            return Optional.empty();
        }
    }

    private static Optional<String> rawFindTableColumnText(WordTable wordTable, int row, int column, int text) {
        return wordTable.getWordTableRowList().flatMap(wordTableRowList -> wordTableRowList.get(row)).flatMap(wordTableRow -> wordTableRow.getWordTableColumnList()).flatMap(wordTableColumnList -> wordTableColumnList.get(column)).flatMap(wordTableColumn -> wordTableColumn.getWordTextList()).flatMap(wordTextList -> wordTextList.get(text)).map(wordText -> wordText.getText());
    }

    private void startOperation() {
        this.lastCause.remove();
        this.lastError.remove();
    }

    public static enum Cause {
        ERROR,
        MORE_THAN_ONE,
        NODE_NOT_ELEMENT,
        NOT_FOUND,
        OK;

    }
}

