/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public class BranchArchivedState
extends NamedIdBase {
    public static final BranchArchivedState ARCHIVED = new BranchArchivedState(1, "ARCHIVED");
    public static final BranchArchivedState UNARCHIVED = new BranchArchivedState(0, "UNARCHIVED");
    public static final BranchArchivedState ALL = new BranchArchivedState(-1, "ALL");
    public static final BranchArchivedState ARCHIVED_IN_PROGRESS = new BranchArchivedState(2, "ARCHIVED_IN_PROGRESS");
    public static final BranchArchivedState UNARCHIVED_IN_PROGRESS = new BranchArchivedState(3, "UNARCHIVED_IN_PROGRESS");
    private static final BranchArchivedState[] values = new BranchArchivedState[]{ARCHIVED, UNARCHIVED, ALL, ARCHIVED_IN_PROGRESS, UNARCHIVED_IN_PROGRESS};

    BranchArchivedState(int id, String name) {
        super(Long.valueOf(id), name);
    }

    public boolean isBeingArchived() {
        return this == ARCHIVED_IN_PROGRESS;
    }

    public boolean isBeingUnarchived() {
        return this == UNARCHIVED_IN_PROGRESS;
    }

    public boolean isArchived() {
        return this == ARCHIVED;
    }

    public boolean isUnArchived() {
        return this == UNARCHIVED;
    }

    public boolean matches(boolean isArchived) {
        return this == ALL || this == BranchArchivedState.fromBoolean(isArchived);
    }

    public static BranchArchivedState fromBoolean(boolean archived) {
        return archived ? ARCHIVED : UNARCHIVED;
    }

    public static BranchArchivedState valueOf(int id) {
        return (BranchArchivedState)NamedIdBase.valueOf((Long)Long.valueOf(id), (NamedId[])values);
    }

    public static BranchArchivedState valueOf(String id) {
        return (BranchArchivedState)NamedIdBase.valueOf((Long)Long.valueOf(id), (NamedId[])values);
    }

    public static BranchArchivedState[] values() {
        return values;
    }
}

