/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.AutoCRLFInputStream;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;
import org.eclipse.jgit.util.io.AutoLFInputStream;
import org.eclipse.jgit.util.io.AutoLFOutputStream;

public final class EolStreamTypeUtil {
    private EolStreamTypeUtil() {
    }

    public static CoreConfig.EolStreamType detectStreamType(TreeWalk.OperationType op, WorkingTreeOptions options, Attributes attrs) {
        switch (op) {
            case CHECKIN_OP: {
                return EolStreamTypeUtil.checkInStreamType(options, attrs);
            }
            case CHECKOUT_OP: {
                return EolStreamTypeUtil.checkOutStreamType(options, attrs);
            }
        }
        throw new IllegalArgumentException("unknown OperationType " + (Object)((Object)op));
    }

    public static InputStream wrapInputStream(InputStream in, CoreConfig.EolStreamType conversion) {
        switch (conversion) {
            case TEXT_CRLF: {
                return new AutoCRLFInputStream(in, false);
            }
            case TEXT_LF: {
                return new AutoLFInputStream(in, false);
            }
            case AUTO_CRLF: {
                return new AutoCRLFInputStream(in, true);
            }
            case AUTO_LF: {
                return new AutoLFInputStream(in, true);
            }
        }
        return in;
    }

    public static OutputStream wrapOutputStream(OutputStream out, CoreConfig.EolStreamType conversion) {
        switch (conversion) {
            case TEXT_CRLF: {
                return new AutoCRLFOutputStream(out, false);
            }
            case AUTO_CRLF: {
                return new AutoCRLFOutputStream(out, true);
            }
            case TEXT_LF: {
                return new AutoLFOutputStream(out, false);
            }
            case AUTO_LF: {
                return new AutoLFOutputStream(out, true);
            }
        }
        return out;
    }

    private static CoreConfig.EolStreamType checkInStreamType(WorkingTreeOptions options, Attributes attrs) {
        if (attrs.isUnset("text")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("crlf")) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if (attrs.isUnset("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("input".equals(attrs.getValue("crlf"))) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if ("auto".equals(attrs.getValue("text"))) {
            return CoreConfig.EolStreamType.AUTO_LF;
        }
        String eol = attrs.getValue("eol");
        if (eol != null) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if (attrs.isSet("text")) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        switch (options.getAutoCRLF()) {
            case TRUE: 
            case INPUT: {
                return CoreConfig.EolStreamType.AUTO_LF;
            }
            case FALSE: {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }

    private static CoreConfig.EolStreamType getOutputFormat(WorkingTreeOptions options) {
        switch (options.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig.EolStreamType.TEXT_CRLF;
            }
            case INPUT: {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        switch (options.getEOL()) {
            case CRLF: {
                return CoreConfig.EolStreamType.TEXT_CRLF;
            }
            case NATIVE: {
                if (SystemReader.getInstance().isWindows()) {
                    return CoreConfig.EolStreamType.TEXT_CRLF;
                }
                return CoreConfig.EolStreamType.TEXT_LF;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }

    private static CoreConfig.EolStreamType checkOutStreamType(WorkingTreeOptions options, Attributes attrs) {
        if (attrs.isUnset("text")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("crlf")) {
            return EolStreamTypeUtil.getOutputFormat(options);
        }
        if (attrs.isUnset("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("input".equals(attrs.getValue("crlf"))) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        String eol = attrs.getValue("eol");
        if (eol != null) {
            if ("crlf".equals(eol)) {
                if ("auto".equals(attrs.getValue("text"))) {
                    return CoreConfig.EolStreamType.AUTO_CRLF;
                }
                return CoreConfig.EolStreamType.TEXT_CRLF;
            }
            if ("lf".equals(eol)) {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        if (attrs.isSet("text")) {
            return EolStreamTypeUtil.getOutputFormat(options);
        }
        if ("auto".equals(attrs.getValue("text"))) {
            CoreConfig.EolStreamType basic = EolStreamTypeUtil.getOutputFormat(options);
            switch (basic) {
                case TEXT_CRLF: {
                    return CoreConfig.EolStreamType.AUTO_CRLF;
                }
                case TEXT_LF: {
                    return CoreConfig.EolStreamType.AUTO_LF;
                }
            }
            return basic;
        }
        switch (options.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig.EolStreamType.AUTO_CRLF;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }
}

