/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterFactory;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterUtil;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwApplicability;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttribute;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;

public class OrcsWriterSheetProcessorForCreateUpdate
implements RowProcessor {
    private final OwCollector collector;
    private final Map<Integer, OwAttributeType> columnToAttributeType = new HashMap<Integer, OwAttributeType>();
    private final Map<Integer, OwRelationType> columnToRelationType = new HashMap<Integer, OwRelationType>();
    private Integer artTokenColumn = null;
    private Integer nameColumn = null;
    private Integer applicabilityColumn = null;
    private int rowCount = 0;
    private final OrcsWriterFactory factory;
    private final boolean createSheet;

    public OrcsWriterSheetProcessorForCreateUpdate(OwCollector collector, XResultData result, boolean createSheet) {
        this.collector = collector;
        this.createSheet = createSheet;
        this.factory = new OrcsWriterFactory(collector);
    }

    public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
    }

    public void foundStartOfWorksheet(String sheetName) {
    }

    public void processCommentRow(String[] row) {
    }

    public void processEmptyRow() {
    }

    boolean isAttributeColumn(int x) {
        return this.columnToAttributeType.containsKey(x);
    }

    boolean isRelationColumn(int x) {
        return this.columnToRelationType.containsKey(x);
    }

    public void processHeaderRow(String[] headerRow) {
        ++this.rowCount;
        int colCount = 0;
        while (colCount < headerRow.length) {
            String value = headerRow[colCount];
            if (value != null) {
                if (value.toLowerCase().equals("name")) {
                    if (this.nameColumn != null) {
                        throw new OseeArgumentException("Can't have multiple Name columns on %s sheet", new Object[]{this.getSheetName()});
                    }
                    this.nameColumn = colCount;
                } else if (value.toLowerCase().equals("attribute")) {
                    OwAttributeType attrType = new OwAttributeType();
                    attrType.setData(OrcsWriterUtil.getData(this.getSheetName(), this.rowCount, colCount));
                    this.columnToAttributeType.put(colCount, attrType);
                    this.collector.getAttrTypes().add(attrType);
                } else if (value.toLowerCase().equals("relation")) {
                    OwRelationType relType = new OwRelationType(Long.valueOf(0L), "");
                    relType.setData(OrcsWriterUtil.getData(this.getSheetName(), this.rowCount, colCount));
                    this.columnToRelationType.put(colCount, relType);
                    this.collector.getRelTypes().add(relType);
                } else if (value.toLowerCase().equals("applicability")) {
                    this.applicabilityColumn = colCount;
                } else if (value.toLowerCase().startsWith("new art token")) {
                    if (this.artTokenColumn != null) {
                        throw new OseeArgumentException("Can't have multiple \"New Art Token\" columns on %s sheet", new Object[]{this.getSheetName()});
                    }
                    this.artTokenColumn = colCount;
                }
            }
            ++colCount;
        }
        if (this.isCreateSheet() && this.nameColumn == null) {
            throw new OseeArgumentException("Name column must be present on %s sheet", new Object[]{this.getSheetName()});
        }
        if (this.isCreateSheet() && this.artTokenColumn == null) {
            throw new OseeArgumentException("Artifact Token column must be present on %s sheet", new Object[]{this.getSheetName()});
        }
        if (!this.isCreateSheet() && this.artTokenColumn != null) {
            throw new OseeArgumentException("Artifact Token column should NOT be present on %s sheet", new Object[]{this.getSheetName()});
        }
    }

    private boolean isCreateSheet() {
        return this.createSheet;
    }

    private String getSheetName() {
        return this.createSheet ? "CREATE" : "UPDATE";
    }

    public void processRow(String[] row) {
        block27: {
            OwArtifact artifact;
            block26: {
                ++this.rowCount;
                artifact = new OwArtifact();
                artifact.setData(OrcsWriterUtil.getData(this.getSheetName(), this.rowCount, 0));
                if (this.rowCount != 2) break block26;
                int colCount = 0;
                while (colCount < row.length) {
                    String value;
                    if (this.isAttributeColumn(colCount)) {
                        OwAttributeType attrType = this.columnToAttributeType.get(colCount);
                        value = row[colCount];
                        this.factory.processAttributeType(attrType, value);
                    } else if (this.isRelationColumn(colCount)) {
                        OwRelationType relType = this.columnToRelationType.get(colCount);
                        value = row[colCount];
                        this.factory.processRelationType(relType, value);
                    }
                    ++colCount;
                }
                break block27;
            }
            if (this.rowCount <= 2) break block27;
            if (this.createSheet) {
                this.collector.getCreate().add(artifact);
            } else {
                this.collector.getUpdate().add(artifact);
            }
            int colCount = 0;
            while (colCount < row.length) {
                String value;
                OwArtifactToken token;
                String value2;
                if (colCount == 0) {
                    value2 = row[0];
                    if (this.createSheet) {
                        if (!Strings.isValid((String)value2)) {
                            throw new OseeArgumentException("First column must contain artifact type.  row number on CREATE sheet" + this.rowCount, new Object[0]);
                        }
                        OwArtifactType artType = this.factory.getOrCreateArtifactType(value2);
                        if (artType == null) {
                            throw new OseeArgumentException("Invalid Artifact Type row %d value [%s]; expected [name]-[id] on CREATE sheet", new Object[]{this.rowCount, value2});
                        }
                        artifact.setType(artType);
                    } else {
                        if (!Strings.isValid((String)value2)) {
                            throw new OseeArgumentException("First column must contain artifact token.  row number %d on UPDATE sheet", new Object[]{this.rowCount});
                        }
                        OwArtifactToken artifactToken = this.factory.getOrCreateToken(value2);
                        if (artifactToken == null) {
                            throw new OseeArgumentException("Invalid Artifact Token row %d value [%s]; expected [name]-[id] on UPDATE sheet", new Object[]{this.rowCount, value2});
                        }
                        artifact.setId(artifactToken.getId());
                    }
                }
                if (this.isCreateSheet() && this.artTokenColumn == colCount && Strings.isValid((String)(value2 = row[colCount])) && (token = this.factory.getOrCreateToken(value2)) != null) {
                    if (token.getId() > 0L) {
                        artifact.setId(token.getId());
                    } else {
                        throw new OseeStateException("Unexpected string [%s] at %s; expected [name]-[id]", new Object[]{value2, OrcsWriterUtil.getRowColumnStr(colCount, colCount, this.getSheetName())});
                    }
                }
                if (this.nameColumn != null && this.nameColumn == colCount) {
                    value2 = row[colCount];
                    if (Strings.isValid((String)value2)) {
                        artifact.setName(value2);
                    } else {
                        throw new OseeStateException("Unexpected Name [%s] at %s", new Object[]{value2, OrcsWriterUtil.getRowColumnStr(colCount, colCount, this.getSheetName())});
                    }
                }
                if (this.applicabilityColumn != null && this.applicabilityColumn == colCount) {
                    value2 = row[colCount];
                    OwApplicability app = this.factory.getOrCreateApplicability(artifact);
                    app.setValue(value2);
                    artifact.setAppId(app);
                }
                if (this.isAttributeColumn(colCount)) {
                    OwAttributeType attrType = this.columnToAttributeType.get(colCount);
                    if (attrType.getName().equals(CoreAttributeTypes.Name.getName())) {
                        throw new OseeStateException("Name cannot also exist as attribute column at %s", new Object[]{OrcsWriterUtil.getRowColumnStr(this.rowCount, colCount, this.getSheetName())});
                    }
                    value = row[colCount];
                    OwAttribute attr = this.factory.getOrCreateAttribute(artifact, attrType);
                    attr.getValues().add(value);
                    attr.setData(OrcsWriterUtil.getData(this.getSheetName(), this.rowCount, colCount, attr.getData()));
                } else if (this.isRelationColumn(colCount)) {
                    OwRelationType relType = this.columnToRelationType.get(colCount);
                    value = row[colCount];
                    if (Strings.isValid((String)value)) {
                        OwRelation relation = this.factory.createRelationType(relType, value);
                        relation.setData(OrcsWriterUtil.getData(this.getSheetName(), this.rowCount, colCount, relation.getData()));
                        artifact.getRelations().add(relation);
                    }
                }
                ++colCount;
            }
        }
    }

    public void reachedEndOfWorksheet() {
    }
}

