/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.TupleEndpoint;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TupleEndpointImpl
implements TupleEndpoint {
    private final OrcsApi orcsApi;
    @Context
    private UriInfo uriInfo;
    private final BranchId branch;
    private final UserId account;

    public TupleEndpointImpl(OrcsApi orcsApi, BranchId branch) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.account = orcsApi.userService().getUser();
    }

    public <E1, E2> Long getTuple2(@QueryParam(value="tupleType") Tuple2Type<E1, E2> tupleType, @QueryParam(value="e1") E1 e1) {
        Iterable iterable = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(tupleType, this.branch, e1);
        if (iterable.iterator().hasNext()) {
            return (Long)iterable.iterator().next();
        }
        return -1L;
    }

    public <E1, E2> GammaId addTuple2(Tuple2Type<E1, E2> tupleType, E1 e1, E2 e2) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Add Tuple 2");
        GammaId gammaId = tx.addTuple2(tupleType, e1, e2);
        tx.commit();
        return gammaId;
    }

    public <E1, E2, E3> GammaId addTuple3(Tuple3Type<E1, E2, E3> tupleType, E1 e1, E2 e2, E3 e3) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Add Tuple 3");
        GammaId gammaId = tx.addTuple3(tupleType, e1, e2, e3);
        tx.commit();
        return gammaId;
    }

    public <E1, E2, E3, E4> GammaId addTuple4(Tuple4Type<E1, E2, E3, E4> tupleType, E1 e1, E2 e2, E3 e3, E4 e4) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Add Tuple 4");
        GammaId gammaId = tx.addTuple4(tupleType, e1, e2, e3, e4);
        tx.commit();
        return gammaId;
    }

    public TransactionId deleteTuple(int tupleTable, GammaId gammaId) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.account, "Delete tuple");
        if (tupleTable == 2) {
            tx.deleteTuple2(gammaId);
        } else if (tupleTable == 3) {
            tx.deleteTuple3(gammaId);
        } else if (tupleTable == 4) {
            tx.deleteTuple4(gammaId);
        } else {
            throw new OseeArgumentException("Unsupported tuple table [%s]", new Object[]{tupleTable});
        }
        return tx.commit();
    }
}

