/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.IndexResources;
import org.eclipse.osee.orcs.rest.model.IndexerEndpoint;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.IndexerCollector;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.QueryIndexer;

public class IndexerEndpointImpl
implements IndexerEndpoint {
    private final OrcsApi orcsApi;

    public IndexerEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    private QueryIndexer getIndexer() {
        return this.orcsApi.getQueryIndexer();
    }

    private QueryFactory newQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private BranchQuery newBranchQuery() {
        return this.newQuery().branchQuery();
    }

    public Response indexBranches(String branchIdsStr, boolean missingItemsOnly) {
        List branchIds = Collections.fromString((String)branchIdsStr, BranchId::valueOf);
        Objects.requireNonNull((BranchQuery)this.newBranchQuery().andIds((Collection)branchIds));
        ResultSet results = ((BranchQuery)this.newBranchQuery().andIds((Collection)branchIds)).getResults();
        CancellableCallable op = this.getIndexer().indexBranches((Set)Sets.newLinkedHashSet((Iterable)results), missingItemsOnly, new IndexerCollector[0]);
        Integer result = (Integer)OrcsRestUtil.executeCallable(op);
        boolean modified = result > 0;
        return OrcsRestUtil.asResponse(modified);
    }

    public Response indexResources(IndexResources options) {
        boolean modified = false;
        if (!options.getGammaIds().isEmpty()) {
            Callable op = this.getIndexer().indexResources((Iterable)options.getGammaIds(), new IndexerCollector[0]);
            List futures = (List)OrcsRestUtil.executeCallable(op);
            boolean bl = modified = !futures.isEmpty();
            if (options.isWaitForIndexerToComplete()) {
                for (Future future : futures) {
                    try {
                        future.get(1L, TimeUnit.MINUTES);
                    }
                    catch (Exception ex) {
                        throw new OseeWebApplicationException((Throwable)ex, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Error processing indexing operation [%s]", new Object[]{options});
                    }
                }
            }
        }
        return OrcsRestUtil.asResponse(modified);
    }

    public Response deleteIndexQueueItem(int queryId) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        CancellableCallable op = this.getIndexer().deleteIndexByQueryId(queryId);
        Integer result = (Integer)OrcsRestUtil.executeCallable(op);
        boolean modified = result > 0;
        return OrcsRestUtil.asResponse(modified);
    }

    public Response deleteIndexQueue() {
        CancellableCallable op = this.getIndexer().purgeAllIndexes();
        Integer result = (Integer)OrcsRestUtil.executeCallable(op);
        boolean modified = result > 0;
        return OrcsRestUtil.asResponse(modified);
    }
}

