/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdom;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AbstractNode;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeDefinition;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeDefinitionImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeValue;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeValueImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Document;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentObject;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentObjectImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DuplicateNodeException;
import org.eclipse.osee.define.operations.synchronization.publishingdom.HierarchicalNode;
import org.eclipse.osee.define.operations.synchronization.publishingdom.HierarchicalNodeSetter;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Node;
import org.eclipse.osee.define.operations.synchronization.publishingdom.NodeNotFoundException;
import org.eclipse.osee.define.operations.synchronization.publishingdom.NodeNotMemberOfDomException;
import org.eclipse.osee.define.operations.synchronization.publishingdom.NodeWrongTypeException;

class DocumentMapImpl
implements DocumentMap,
HierarchicalNodeSetter {
    private final Map<Identifier, Document> documentMap;
    private int[] hierarchyLevels;
    private String hierarchyLevelsString;
    private final Identifier identifier;
    private final Map<Identifier, Node> nodeMap;

    DocumentMapImpl(Identifier documentMapIdentifier) {
        assert (Objects.nonNull(documentMapIdentifier)) : "DocumentMapImpl::new, parameter \"documentMapIdentifier\" cannot be null.";
        assert (documentMapIdentifier.isType(IdentifierType.FOREST)) : "DocumentMapImpl::new, parameter \"documentMapIdentifier\" is not of \"IdentifierType.FOREST\".";
        this.identifier = documentMapIdentifier;
        this.documentMap = new LinkedHashMap<Identifier, Document>();
        this.nodeMap = new HashMap<Identifier, Node>();
        this.nodeMap.put(documentMapIdentifier, this);
    }

    @Override
    public void appendAttributeDefinition(Identifier parentIdentifier, AttributeDefinition attributeDefinition) {
        Objects.requireNonNull(parentIdentifier, "DocumentMapImpl::appendAttributeDefinition, parameter \"parentIdentifier\" cannot be null.");
        Objects.requireNonNull(attributeDefinition, "DocumentMapImpl::appendAttributeDefinition, parameter \"attributeDefinition\" cannot be null.");
        if (((AttributeDefinitionImpl)attributeDefinition).documentMap != this) {
            throw new NodeNotMemberOfDomException(attributeDefinition, this, "DocumentMapImp::appendAttributeDefinition");
        }
        Node parentNode = this.nodeMap.get(parentIdentifier);
        if (Objects.isNull(parentNode)) {
            throw new NodeNotFoundException(parentIdentifier);
        }
        if (!(parentNode instanceof DocumentObjectImpl) && !(parentNode instanceof DocumentImpl)) {
            throw new NodeWrongTypeException(parentIdentifier, parentNode, DocumentObjectImpl.class);
        }
        AbstractNode parentAbstractNode = (AbstractNode)parentNode;
        Identifier attributeDefinitionIdentifier = attributeDefinition.getIdentifier();
        ((AttributeDefinitionImpl)attributeDefinition).attach(parentIdentifier);
        parentAbstractNode.append(attributeDefinition);
        this.nodeMap.put(attributeDefinitionIdentifier, attributeDefinition);
    }

    @Override
    public void appendAttributeValue(Identifier parentIdentifier, Identifier attributeDefinitionIdentifier, AttributeValue attributeValue) {
        Objects.requireNonNull(parentIdentifier, "DocumentMapImpl::appendAttributeValue, parameter \"parentIdentifier\" cannot be null.");
        Objects.requireNonNull(attributeValue, "DocumentMapImpl::appendAttributeValue, parameter \"attributeValue\" cannot be null.");
        if (((AttributeValueImpl)attributeValue).documentMap != this) {
            throw new NodeNotMemberOfDomException(attributeValue, this, "DocumentMapImp::appendAttributeValue");
        }
        Node parentNode = this.nodeMap.get(parentIdentifier);
        if (Objects.isNull(parentNode)) {
            throw new NodeNotFoundException(parentIdentifier);
        }
        if (!(parentNode instanceof DocumentObjectImpl) && !(parentNode instanceof DocumentImpl)) {
            throw new NodeWrongTypeException(parentIdentifier, parentNode, DocumentObjectImpl.class);
        }
        AbstractNode parentAbstractNode = (AbstractNode)parentNode;
        if (attributeValue.isAttached()) {
            throw new IllegalStateException();
        }
        Identifier attributeValueIdentifier = attributeValue.getIdentifier();
        if (this.nodeMap.containsKey(attributeValueIdentifier)) {
            throw new DuplicateNodeException(attributeValueIdentifier);
        }
        ((AttributeValueImpl)attributeValue).attach(attributeDefinitionIdentifier);
        parentAbstractNode.append(attributeValue);
        this.nodeMap.put(attributeValueIdentifier, attributeValue);
    }

    @Override
    public void appendDocumentObjectToDocument(Identifier parentDocumentIdentifier, DocumentObject documentObject) {
        Objects.requireNonNull(parentDocumentIdentifier, "DocumentMapImpl::appendDocumentObjectToDocument, parameter \"parentDocumentIdentifier\" cannot be null.");
        Objects.requireNonNull(documentObject, "DocumentMapImpl::appendDocumentObjectToDocument, parameter \"documentObject\" cannot be null.");
        if (((DocumentObjectImpl)documentObject).documentMap != this) {
            throw new NodeNotMemberOfDomException(documentObject, this, "DocumentMapImp::appendDocumentObjectToDocument");
        }
        Document parentDocument = this.documentMap.get(parentDocumentIdentifier);
        if (Objects.isNull(parentDocument)) {
            throw new NodeNotFoundException(parentDocumentIdentifier);
        }
        if (documentObject.isAttached()) {
            throw new IllegalStateException();
        }
        Identifier documentObjectIdentifier = documentObject.getIdentifier();
        if (this.nodeMap.containsKey(documentObjectIdentifier)) {
            throw new DuplicateNodeException(documentObjectIdentifier);
        }
        ((DocumentObjectImpl)documentObject).attach(parentDocumentIdentifier);
        ((DocumentImpl)parentDocument).append(documentObject);
        this.nodeMap.put(documentObjectIdentifier, documentObject);
    }

    @Override
    public void appendDocumentObjectToDocumentObject(Identifier parentDocumentObjectIdentifier, DocumentObject documentObject) {
        Objects.requireNonNull(parentDocumentObjectIdentifier, "DocumentMapImpl::appendDocumentObjectToDocumentObject, parameter \"parentDocumentObjectIdentifier\" cannot be null.");
        Objects.requireNonNull(documentObject, "DocumentMapImpl::appendDocumentObjectToDocumentObject, parameter \"documentObject\" cannot be null.");
        if (((DocumentObjectImpl)documentObject).documentMap != this) {
            throw new NodeNotMemberOfDomException(documentObject, this, "DocumentMapImp::appendDocumentObjectToDocumentObject");
        }
        Node parentNode = this.nodeMap.get(parentDocumentObjectIdentifier);
        if (Objects.isNull(parentNode)) {
            throw new NodeNotFoundException(parentDocumentObjectIdentifier);
        }
        if (!(parentNode instanceof DocumentObjectImpl)) {
            throw new NodeWrongTypeException(parentDocumentObjectIdentifier, parentNode, DocumentObjectImpl.class);
        }
        DocumentObjectImpl parentDocumentObject = (DocumentObjectImpl)parentNode;
        if (documentObject.isAttached()) {
            throw new IllegalStateException();
        }
        Identifier documentObjectIdentifier = documentObject.getIdentifier();
        if (this.nodeMap.containsKey(documentObjectIdentifier)) {
            throw new DuplicateNodeException(documentObjectIdentifier);
        }
        ((DocumentObjectImpl)documentObject).attach(parentDocumentObjectIdentifier);
        parentDocumentObject.append(documentObject);
        this.nodeMap.put(documentObjectIdentifier, documentObject);
    }

    @Override
    public void appendDocumentToDocumentMap(Identifier parentDocumentMapIdentifier, Document document) {
        Objects.requireNonNull(parentDocumentMapIdentifier, "DocumentMapImpl::appendDocumentToDocumentMap, parameter \"parentDocumentMapIdentifier\" cannot be null.");
        Objects.requireNonNull(document, "DocumentMapImpl::appendDocumentToDocumentMap, parameter \"document\" cannot be null.");
        if (((DocumentImpl)document).documentMap != this) {
            throw new NodeNotMemberOfDomException(document, this, "DocumentMapImp::appendDocumentObjectToDocumentObject");
        }
        if (!this.identifier.equals(parentDocumentMapIdentifier)) {
            throw new NodeNotFoundException(parentDocumentMapIdentifier);
        }
        if (document.isAttached()) {
            throw new IllegalStateException();
        }
        Identifier documentIdentifier = document.getIdentifier();
        if (this.nodeMap.containsKey(documentIdentifier)) {
            throw new DuplicateNodeException(documentIdentifier);
        }
        ((DocumentImpl)document).attach(this.identifier);
        this.nodeMap.put(documentIdentifier, document);
        this.documentMap.put(documentIdentifier, document);
    }

    @Override
    public int attributeDefinitionSize() {
        return 0;
    }

    @Override
    public AttributeDefinitionImpl createAttributeDefinition(Identifier attributeDefinitionIdentifier, String name, String description) {
        Objects.requireNonNull(attributeDefinitionIdentifier, "DocumentMapImpl::createAttributeDefinition, parameter \"attributeDefintionIdentifier\" cannot be null.");
        Objects.requireNonNull(name, "DocumentMapImpl::createAttributeDefinition, parameter \"name\" cannot be null.");
        Objects.requireNonNull(description, "DocumentMapImpl::createAttributeDefinition, parameter \"description\" cannot be null.");
        attributeDefinitionIdentifier.requireType(IdentifierType.ATTRIBUTE_DEFINITION);
        return new AttributeDefinitionImpl(this, attributeDefinitionIdentifier, name, description);
    }

    @Override
    public AttributeValueImpl createAttributeValue(Identifier attributeValueIdentifier, String value) {
        Objects.requireNonNull(attributeValueIdentifier, "DocumentMapImpl::createAttributeValue, parameter \"attributeValueIdentifier\" cannot be null.");
        Objects.requireNonNull(value, "DocumentMapImpl::createAttributeValue, parameter \"value\" cannot be null.");
        attributeValueIdentifier.requireType(IdentifierType.ATTRIBUTE_VALUE);
        return new AttributeValueImpl(this, attributeValueIdentifier, value);
    }

    @Override
    public Document createDocument(Identifier documentIdentifier, String name, String type) {
        Objects.requireNonNull(documentIdentifier, "DocumentMapImpl::createDocument, parameter \"documentIdentifier\" cannot be null.");
        Objects.requireNonNull(name, "DocumentMapImpl::createDocument, parameter \"name\" cannot be null.");
        Objects.requireNonNull(type, "DocumentMapImpl::createDocument, parameter \"type\" cannot be null.");
        documentIdentifier.requireType(IdentifierType.SPECIFICATION);
        return new DocumentImpl(this, documentIdentifier, name, type);
    }

    @Override
    public DocumentObjectImpl createDocumentObject(Identifier documentObjectIdentifier, String name, String type) {
        Objects.requireNonNull(documentObjectIdentifier, "DocumentMapImpl::createDocumentObject, parameter \"documentObjectIdentifier\" cannot be null.");
        Objects.requireNonNull(name, "DocumentMapImpl::createDocumentObject, parameter \"name\" cannot be null.");
        Objects.requireNonNull(type, "DocumentMapImpl::createDocumentObject, parameter \"type\" cannot be null.");
        documentObjectIdentifier.requireInGroup(IdentifierTypeGroup.SUBORDINATE_OBJECT);
        return new DocumentObjectImpl(this, documentObjectIdentifier, name, type);
    }

    @Override
    public int getHierarchyLevel() {
        return Objects.nonNull(this.hierarchyLevels) ? this.hierarchyLevels.length : -1;
    }

    @Override
    public int[] getHierarchyLevels() {
        return Arrays.copyOf(this.hierarchyLevels, this.hierarchyLevels.length);
    }

    @Override
    public String getHierarchyLevelString() {
        return this.hierarchyLevelsString;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public Identifier getParentIdentifier() {
        return null;
    }

    @Override
    public IdentifierType getType() {
        return this.identifier.getType();
    }

    @Override
    public int hierarchicalSize() {
        return this.documentMap.size();
    }

    @Override
    public boolean isAttached() {
        return true;
    }

    @Override
    public boolean isHierarchical() {
        return true;
    }

    @Override
    public boolean isType(IdentifierType identifierType) {
        return this.identifier.isType(identifierType);
    }

    private void setHierarchyLevelForChildren(HierarchicalNodeSetter parentNode) {
        int[] count = new int[1];
        int[] parentHierarchyLevels = parentNode.getHierarchyLevels();
        parentNode.streamHierarchicalChildren().forEach(childHierarchicalNode -> {
            int n = count[0];
            nArray2[0] = n + 1;
            this.setNodeHierarchyLevel((HierarchicalNodeSetter)((Object)childHierarchicalNode), parentHierarchyLevels, n);
            this.setHierarchyLevelForChildren((HierarchicalNodeSetter)((Object)childHierarchicalNode));
        });
    }

    @Override
    public void setHierarchyLevels() {
        int[] count = new int[1];
        this.setHierarchyLevels(new int[1]);
        int[] parentHierarchyLevels = this.getHierarchyLevels();
        this.streamHierarchicalChildren().forEach(hierarchicalNode -> {
            int n = count[0];
            nArray2[0] = n + 1;
            this.setNodeHierarchyLevel((HierarchicalNodeSetter)((Object)hierarchicalNode), parentHierarchyLevels, n);
            this.setHierarchyLevelForChildren((HierarchicalNodeSetter)((Object)hierarchicalNode));
        });
    }

    @Override
    public void setHierarchyLevels(int[] hierarchyLevels) {
        Objects.requireNonNull(hierarchyLevels, "DocumentImpl:setHierarchyLevels, parameter \"hierarchyLevels\" cannot be null.");
        if (Objects.nonNull(this.hierarchyLevels)) {
            throw new IllegalStateException("Object::setHierarchyLevels, member \"hierarchyLevels\" has already been set.");
        }
        this.hierarchyLevels = hierarchyLevels;
        this.hierarchyLevelsString = Arrays.stream(this.hierarchyLevels).map(level -> level + 1).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }

    private void setNodeHierarchyLevel(HierarchicalNodeSetter childNode, int[] parentHierarchyLevels, int childCount) {
        int childLevel = parentHierarchyLevels.length + 1;
        int[] childHierarchyLevel = Arrays.copyOf(parentHierarchyLevels, childLevel);
        childHierarchyLevel[childLevel - 1] = childCount;
        childNode.setHierarchyLevels(childHierarchyLevel);
    }

    @Override
    public Stream<AttributeDefinitionImpl> streamAttributeDefinitionChildren() {
        return Stream.empty();
    }

    @Override
    public Stream<HierarchicalNode> streamHierarchicalChildren() {
        Collection<Document> nodes = this.documentMap.values();
        return nodes.stream();
    }
}

