/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.define.api.publishing.PublishingArtifactError;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.HasArtifactType;
import org.eclipse.osee.framework.core.publishing.WordMLProducer;
import org.eclipse.osee.framework.jdk.core.type.NamedId;

public class PublishingErrorLog {
    private final List<PublishingArtifactError> publishingErrors = new LinkedList<PublishingArtifactError>();

    public void clear() {
        this.publishingErrors.clear();
    }

    public <T extends NamedId & HasArtifactType> void error(T thing, String message) {
        this.publishingErrors.add(new PublishingArtifactError(thing, message));
    }

    public <T extends NamedId & HasArtifactType> void error(List<T> things, String message) {
        this.publishingErrors.add(new PublishingArtifactError(things, message));
    }

    public void error(String message) {
        this.publishingErrors.add(new PublishingArtifactError((NamedId)ArtifactToken.SENTINEL, message));
    }

    public void publishErrorLog(StringBuilder stringBuilder) {
        if (this.publishingErrors.isEmpty()) {
            return;
        }
        int count = 0;
        for (PublishingArtifactError error : this.publishingErrors) {
            stringBuilder.append(count++).append(":").append("\n");
            error.publish(stringBuilder);
            stringBuilder.append("\n");
        }
    }

    public void publishErrorLog(WordMLProducer wordMl) {
        if (this.publishingErrors.isEmpty()) {
            return;
        }
        wordMl.startErrorLog();
        for (PublishingArtifactError error : this.publishingErrors) {
            error.publish(wordMl);
        }
        wordMl.endErrorLog();
    }

    public int size() {
        return this.publishingErrors.size();
    }
}

