/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.team;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.core.enums.OseeEnum;

public class Priorities
extends OseeEnum {
    public static final String PRIORITY_PARAM_KEY = "Priority";
    private static final Long ENUM_ID = 3452690439L;
    private static final List<Priorities> values = new ArrayList<Priorities>();
    public static final Priorities One = new Priorities("1");
    public static final Priorities Two = new Priorities("2");
    public static final Priorities Three = new Priorities("3");
    public static final Priorities Four = new Priorities("4");
    public static final Priorities Five = new Priorities("5");
    public static final Priorities Six = new Priorities("6");
    public static final Priorities None = new Priorities("None", "");
    public static final List<Priorities> DEFAULT_PRIORITIES = Arrays.asList(One, Two, Three, Four, Five);
    private String description;

    public Priorities() {
        super(ENUM_ID, "");
    }

    private Priorities(String name) {
        this(name, "");
    }

    protected Priorities(String name, String description) {
        super(ENUM_ID, name);
        this.description = description;
        values.add(this);
    }

    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public Long getTypeId() {
        return ENUM_ID;
    }

    @JsonIgnore
    public OseeEnum getDefault() {
        return None;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Priorities valueOf(String priorityStr) {
        return Priorities.valueOfOrNone(priorityStr);
    }

    public static Priorities valueOfOrNone(String priorityTypes) {
        Priorities priority = (Priorities)None.get(priorityTypes);
        if (priority == null) {
            priority = None;
        }
        return priority;
    }

    public static Priorities getPriority(Object priority) {
        String priorityName = "";
        if (priority instanceof Priorities) {
            priorityName = ((Priorities)((Object)priority)).getName();
        } else if (priority instanceof String) {
            priorityName = (String)priority;
        }
        for (Priorities type : values) {
            if (!type.name().equals(priorityName)) continue;
            return type;
        }
        return None;
    }

    public static List<Priorities> getValues() {
        return values;
    }

    public static List<String> getDefaultValuesStrs() {
        ArrayList<String> vals = new ArrayList<String>();
        for (Priorities type : DEFAULT_PRIORITIES) {
            vals.add(type.name());
        }
        return vals;
    }

    public static List<String> getValuesStrs() {
        ArrayList<String> vals = new ArrayList<String>();
        for (Priorities type : values) {
            vals.add(type.name());
        }
        return vals;
    }
}

