/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.workdef.StateColor;
import org.eclipse.osee.ats.api.workdef.StateOption;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.core.task.CreateChangeReportTaskCommitHook;
import org.eclipse.osee.ats.core.task.CreateChangeReportTaskTransitionHook;
import org.eclipse.osee.ats.core.workdef.builder.DecisionReviewDefinitionBuilder;
import org.eclipse.osee.ats.core.workdef.builder.PeerReviewDefinitionBuilder;
import org.eclipse.osee.ats.core.workdef.builder.WorkDefBuilderOption;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class StateDefBuilder {
    StateDefinition state;
    private final WorkDefinition workDef;
    private final List<StateToken> toStateTokens = new ArrayList<StateToken>();
    private final List<DecisionReviewDefinitionBuilder> decRevBldrs = new LinkedList<DecisionReviewDefinitionBuilder>();
    private final List<PeerReviewDefinitionBuilder> peerRevBldrs = new LinkedList<PeerReviewDefinitionBuilder>();
    private final XResultData rd;
    private final List<WorkDefBuilderOption> builderOptions;

    public StateDefBuilder(int ordinal, String name, StateType type, WorkDefinition workDef, WorkDefBuilderOption ... builderOptions) {
        this.workDef = workDef;
        this.state = new StateDefinition(name);
        this.state.setStateType(type);
        this.state.setOrdinal(ordinal);
        this.state.setWorkDefinition(workDef);
        workDef.addState(this.state);
        this.rd = workDef.getResults();
        this.builderOptions = new ArrayList<WorkDefBuilderOption>();
        WorkDefBuilderOption[] workDefBuilderOptionArray = builderOptions;
        int n = builderOptions.length;
        int n2 = 0;
        while (n2 < n) {
            WorkDefBuilderOption opt = workDefBuilderOptionArray[n2];
            this.builderOptions.add(opt);
            ++n2;
        }
    }

    public StateDefBuilder andDescription(String desc) {
        this.state.setDescription(desc);
        return this;
    }

    public StateDefBuilder andColor(StateColor color) {
        this.state.setColor(color);
        return this;
    }

    public StateDefBuilder isStartState() {
        if (this.workDef.getStartState() != null) {
            this.rd.errorf("Duplicate Start States [%s] and [%s] for Work Def %s\n", new Object[]{this.workDef.getStartState(), this.state, this.workDef.getName()});
        }
        this.workDef.setStartState(this.state);
        return this;
    }

    public StateDefBuilder andRecommendedPercentComplete(int percent) {
        this.state.setRecommendedPercentComplete(percent);
        return this;
    }

    public StateDefBuilder andToStates(StateToken ... stateTokens) {
        if (this.state.isCompletedOrCancelled() && !this.hasOption(WorkDefBuilderOption.OVERRIDE_COMP_CANC_TO_STATE_CHECK)) {
            this.rd.errorf("Completed/Cancelled sate [%s] shouldn't have toStates for Work Def %s\n", new Object[]{this.state.getName(), this.workDef.getName()});
        }
        ArrayList<StateToken> processedStates = new ArrayList<StateToken>();
        boolean foundAny = false;
        StateToken[] stateTokenArray = stateTokens;
        int n = stateTokens.length;
        int n2 = 0;
        while (n2 < n) {
            StateToken stateTok = stateTokenArray[n2];
            if (stateTok == StateToken.ANY) {
                foundAny = true;
            }
            if (stateTok.getName().equals(this.state.getName())) {
                this.rd.errorf("toState [%s] shouldn't match state name for Work Def %s\n", new Object[]{stateTok.getName(), this.workDef.getName()});
            }
            if (processedStates.contains(stateTok)) {
                this.rd.errorf("Should not have duplicate [%s] states in andToState call for Work Def %s\n", new Object[]{stateTok.getName(), this.workDef.getName()});
            }
            processedStates.add(stateTok);
            this.toStateTokens.add(stateTok);
            ++n2;
        }
        if (foundAny && this.toStateTokens.size() > 1) {
            this.rd.errorf("Should not use StateToken.ANY with other StateTokens for andToStates in state [%s] for Work Def %s\n", new Object[]{this.state.getName(), this.workDef.getName()});
        }
        return this;
    }

    public StateDefBuilder andRules(RuleDefinitionOption ... rules) {
        RuleDefinitionOption[] ruleDefinitionOptionArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            RuleDefinitionOption rule = ruleDefinitionOptionArray[n2];
            this.state.addRule(rule.name());
            ++n2;
        }
        return this;
    }

    public StateDefBuilder andLayout(LayoutItem ... items) {
        LayoutItem[] layoutItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutItem item = layoutItemArray[n2];
            this.state.getLayoutItems().add(item);
            ++n2;
        }
        return this;
    }

    public void insertLayoutAfter(AttributeTypeToken attrTypeLocation, LayoutItem ... addLayoutItems) {
        AtomicBoolean found = new AtomicBoolean(false);
        ArrayList<LayoutItem> currLayoutItems = new ArrayList<LayoutItem>(this.state.getLayoutItems());
        this.state.getLayoutItems().clear();
        this.insertLayoutAfter(this.state.getLayoutItems(), attrTypeLocation, currLayoutItems, found, addLayoutItems);
        if (!found.get()) {
            this.rd.errorf("Can't find WidgetDef for [%s] for Work Def %s\n", new Object[]{attrTypeLocation, this.workDef.getName()});
        }
    }

    private void insertLayoutAfter(List<LayoutItem> newItems, AttributeTypeToken attrTypeLocation, List<LayoutItem> currItems, AtomicBoolean found, LayoutItem ... insertLayoutItems) {
        for (LayoutItem currItem : currItems) {
            newItems.add(currItem);
            if (currItem instanceof WidgetDefinition) {
                WidgetDefinition widgetDef = (WidgetDefinition)currItem;
                if (!attrTypeLocation.equals(widgetDef.getAttributeType())) continue;
                found.set(true);
                LayoutItem[] layoutItemArray = insertLayoutItems;
                int n = insertLayoutItems.length;
                int n2 = 0;
                while (n2 < n) {
                    LayoutItem newItem = layoutItemArray[n2];
                    newItems.add(newItem);
                    ++n2;
                }
                continue;
            }
            if (!(currItem instanceof CompositeLayoutItem)) continue;
            CompositeLayoutItem compLayoutItem = (CompositeLayoutItem)currItem;
            ArrayList<LayoutItem> currLayoutItems = new ArrayList<LayoutItem>(compLayoutItem.getLayoutItems());
            compLayoutItem.getLayoutItems().clear();
            this.insertLayoutAfter(compLayoutItem.getLayoutItems(), attrTypeLocation, currLayoutItems, found, insertLayoutItems);
        }
    }

    public StateDefBuilder andRules(String ... rules) {
        String[] stringArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            this.state.addRule(rule);
            ++n2;
        }
        return this;
    }

    public StateToken getToDefaultStateToken() {
        if (this.toStateTokens.isEmpty()) {
            return null;
        }
        return this.toStateTokens.iterator().next();
    }

    public List<StateToken> getToStateTokens() {
        return this.toStateTokens;
    }

    public StateDefBuilder andLayoutFromState(StateToken fromState) {
        StateDefinition fromStateDef;
        if (this.state.getOrdinal() == 1) {
            this.rd.errorf("State [%s] cannot import layout from other state if current state is the start state for Work Def %s\n", new Object[]{this.state.getName(), this.workDef.getName()});
        }
        if (!this.state.getLayoutItems().isEmpty()) {
            this.rd.errorf("State [%s] cannot import layout from other state if current state has already defined layout items for Work Def %s\n", new Object[]{this.state.getName(), this.workDef.getName()});
        }
        if ((fromStateDef = this.workDef.getStateByName(fromState.getName())).getLayoutItems().isEmpty()) {
            this.rd.errorf("State [%s] cannot import layout from other state if from state [%s] has no layout items defined for Work Def %s\n", new Object[]{this.state.getName(), fromState.getName(), this.workDef.getName()});
        }
        this.andLayout(fromStateDef.getLayoutItems());
        return this;
    }

    public StateDefBuilder addToState(StateDefinition toState) {
        this.state.getToStates().add(toState);
        return this;
    }

    public String toString() {
        return this.state.getName();
    }

    public StateDefBuilder andDecisionReviewBuilder(DecisionReviewDefinitionBuilder decRevBldr) {
        this.state.addDecisionReview(decRevBldr.getReviewDefinition());
        this.decRevBldrs.add(decRevBldr);
        return this;
    }

    public List<DecisionReviewDefinitionBuilder> getDecRevBldrs() {
        return this.decRevBldrs;
    }

    public StateDefBuilder andPeerReviewBuilder(PeerReviewDefinitionBuilder peerRevBldr) {
        this.state.addPeerReview(peerRevBldr.getReviewDefinition());
        this.peerRevBldrs.add(peerRevBldr);
        return this;
    }

    public List<PeerReviewDefinitionBuilder> getPeerRevBldrs() {
        return this.peerRevBldrs;
    }

    public String getName() {
        return this.state.getName();
    }

    public StateDefBuilder andTransitionListener(AtsTaskDefToken taskDefToken) {
        this.state.addTransitionListener((IAtsTransitionHook)new CreateChangeReportTaskTransitionHook(taskDefToken));
        return this;
    }

    public StateDefBuilder andWorkItemListener(AtsTaskDefToken taskDefToken) {
        this.state.addWorkItemListener((IAtsWorkItemHook)new CreateChangeReportTaskCommitHook(taskDefToken));
        return this;
    }

    public StateDefBuilder andStateOptions(StateOption ... options) {
        StateOption[] stateOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            StateOption option = stateOptionArray[n2];
            this.state.getStateOptions().add(option);
            ++n2;
        }
        return this;
    }

    public boolean hasOption(WorkDefBuilderOption option) {
        return this.builderOptions.contains((Object)option);
    }

    public List<LayoutItem> getLayoutItems() {
        return this.state.getLayoutItems();
    }

    public StateDefBuilder andLayout(List<LayoutItem> layoutItems) {
        this.state.getLayoutItems().addAll(layoutItems);
        return this;
    }
}

