/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.AtsSearchUserType;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.ISearchCriteriaProvider;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AttributeValue;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsSearchDataSearch {
    private final AtsSearchData data;
    private final AtsApi atsApi;
    private final ISearchCriteriaProvider criteriaProvider;
    private AtsUser userById;

    public AtsSearchDataSearch(AtsSearchData data, AtsApi atsApi, ISearchCriteriaProvider criteriaProvider) {
        this.atsApi = atsApi;
        this.criteriaProvider = criteriaProvider;
        this.data = data.copy();
    }

    public Collection<ArtifactToken> performSearch() {
        Pair<IAtsQuery, Boolean> result = this.createAtsQuery();
        boolean assigneesWithCompletedOrCancelled = (Boolean)result.getSecond();
        IAtsQuery query = (IAtsQuery)result.getFirst();
        this.setUserType(this.data.getUserType(), query);
        HashSet<ArtifactToken> results = new HashSet<ArtifactToken>();
        results.addAll(Collections.castAll((Collection)query.getResultArtifacts().getList()));
        if (assigneesWithCompletedOrCancelled) {
            Pair<IAtsQuery, Boolean> result2 = this.createAtsQuery();
            IAtsQuery query2 = (IAtsQuery)result2.getFirst();
            this.setUserType(AtsSearchUserType.AssigneeWas, query);
            results.addAll(Collections.castAll((Collection)query2.getResultArtifacts().getList()));
        }
        return results;
    }

    public void setUserType(AtsSearchUserType userType, IAtsQuery query) {
        if (Strings.isValid((String)this.data.getUserId())) {
            this.userById = this.atsApi.getUserService().getUserByUserId(this.data.getUserId());
            if (userType == AtsSearchUserType.Originated) {
                query.andOriginator(this.userById);
            } else if (userType == AtsSearchUserType.Subscribed) {
                query.andSubscribed(this.userById);
            } else if (userType == AtsSearchUserType.Favorites) {
                query.andFavorite(this.userById);
            } else if (userType == AtsSearchUserType.AssigneeWas) {
                query.andAssigneeWas(new AtsUser[]{this.userById});
            } else if (userType == AtsSearchUserType.Assignee) {
                query.andAssignee(new AtsUser[]{this.userById});
            }
        }
    }

    public Pair<IAtsQuery, Boolean> createAtsQuery() {
        List workItemTypes;
        boolean assigneesWithCompletedOrCancelled = false;
        List stateTypes = this.data.getStateTypes();
        AtsSearchUserType userType = this.data.getUserType();
        if (userType == AtsSearchUserType.Assignee && (stateTypes.contains(StateType.Completed) || stateTypes.contains(StateType.Cancelled))) {
            assigneesWithCompletedOrCancelled = true;
        }
        if ((workItemTypes = this.data.getWorkItemTypes()).isEmpty()) {
            workItemTypes.add(WorkItemType.WorkItem);
        }
        IAtsQuery query = this.atsApi.getQueryService().createQuery((WorkItemType)this.data.getWorkItemTypes().iterator().next(), workItemTypes.toArray(new WorkItemType[workItemTypes.size()]));
        if (Strings.isValid((String)this.data.getTitle())) {
            query.andAttr((AttributeTypeId)AtsAttributeTypes.Title, this.data.getTitle(), QueryOption.CONTAINS_MATCH_OPTIONS);
        }
        if (!this.data.getStateTypes().isEmpty()) {
            query.andStateType(this.data.getStateTypes().toArray(new StateType[this.data.getStateTypes().size()]));
        }
        if (!this.data.getTeamDefIds().isEmpty()) {
            query.andTeam(this.data.getTeamDefIds());
        }
        if (!this.data.getAiIds().isEmpty()) {
            query.andActionableItem(this.data.getAiIds());
        }
        if (this.data.getVersionId() != null && this.data.getVersionId() > 0L) {
            query.andVersion(this.data.getVersionId());
        }
        if (Strings.isValid((String)this.data.getState())) {
            query.andState(this.data.getState());
        }
        if (Strings.isValid((String)this.data.getChangeType())) {
            query.andChangeType(this.data.getChangeType());
        }
        if (this.data.getProgramId() > 0L) {
            query.andProgram(this.data.getProgramId());
        }
        if (this.data.getInsertionId() > 0L) {
            query.andInsertion(this.data.getInsertionId());
        }
        if (this.data.getInsertionActivityId() > 0L) {
            query.andInsertionActivity(this.data.getInsertionActivityId());
        }
        if (this.data.getWorkPackageId() > 0L) {
            query.andWorkPackage(this.data.getWorkPackageId());
        }
        for (AttributeValue attrVal : this.data.getAttrValues().getAttributes()) {
            if (attrVal.isNotExists()) {
                query.andNotExists(attrVal.getAttrType());
                continue;
            }
            if (attrVal.getValues().isEmpty()) continue;
            query.andAttr((AttributeTypeId)attrVal.getAttrType(), (Collection)attrVal.getValues(), new QueryOption[0]);
        }
        if (this.criteriaProvider != null) {
            this.criteriaProvider.andCriteria(query);
        }
        return new Pair((Object)query, (Object)assigneesWithCompletedOrCancelled);
    }

    public Collection<ArtifactToken> performSearchNew() {
        Pair<IAtsQuery, Boolean> result = this.createAtsQuery();
        IAtsQuery query = (IAtsQuery)result.getFirst();
        return query.getResultArtifactsNew().getList();
    }
}

