/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.state.SimpleTeamState;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;

public class StateManager
implements IAtsStateManager {
    private final IAtsWorkItem workItem;
    private String currentStateName;
    private final List<WorkState> states = new CopyOnWriteArrayList<WorkState>();
    private final List<AtsUser> initialAssignees = new ArrayList<AtsUser>();
    private boolean dirty = false;
    private final String instanceId;
    private final AtsApi atsApi;

    public StateManager(IAtsWorkItem workItem, AtsApi atsApi) {
        this.workItem = workItem;
        this.atsApi = atsApi;
        this.instanceId = Lib.generateArtifactIdAsInt().toString();
    }

    public String getCurrentStateNameInternal() {
        return this.currentStateName;
    }

    public IStateToken getCurrentState() {
        return new SimpleTeamState(this.getCurrentStateNameInternal(), this.workItem.getCurrentStateType());
    }

    public void addAssignees(String stateName, Collection<? extends AtsUser> assignees) {
        if (assignees == null || assignees.isEmpty()) {
            return;
        }
        for (AtsUser atsUser : assignees) {
            if (!AtsCoreUsers.isSystemUser((AtsUser)atsUser)) continue;
            throw new OseeArgumentException("Can not assign workflow to System User", new Object[0]);
        }
        WorkState workState = this.getState(stateName);
        if (workState != null) {
            List currentAssignees = workState.getAssignees();
            for (AtsUser atsUser : assignees) {
                if (currentAssignees.contains(atsUser)) continue;
                workState.addAssignee(atsUser);
            }
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER)) {
            this.removeAssignee(this.getCurrentStateNameInternal(), AtsCoreUsers.UNASSIGNED_USER);
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.SYSTEM_USER)) {
            this.removeAssignee(this.getCurrentStateNameInternal(), AtsCoreUsers.SYSTEM_USER);
        }
        this.setDirty(true);
    }

    public void setAssignee(AtsUser assignee) {
        if (assignee != null) {
            this.setAssignees(Arrays.asList(assignee));
        }
    }

    public void setAssignees(Collection<? extends AtsUser> assignees) {
        this.setAssignees(this.getCurrentStateNameInternal(), new LinkedList<AtsUser>(assignees));
    }

    public void setAssignees(String stateName, List<? extends AtsUser> assignees) {
        if (assignees == null) {
            return;
        }
        StateDefinition stateDef = this.workItem.getWorkDefinition().getStateByName(stateName);
        StateType stateType = stateDef.getStateType();
        this.setAssignees(stateName, stateType, assignees);
    }

    public void setAssignees(String stateName, StateType stateType, List<? extends AtsUser> assignees) {
        if (assignees == null) {
            return;
        }
        if (stateType.isCompletedOrCancelled()) {
            if (assignees.isEmpty()) {
                return;
            }
            throw new OseeStateException("Can't assign completed/cancelled states.", new Object[0]);
        }
        for (AtsUser atsUser : assignees) {
            if (!AtsCoreUsers.isSystemUser((AtsUser)atsUser)) continue;
            throw new OseeArgumentException("Can not assign workflow to System User", new Object[0]);
        }
        WorkState workState = this.getState(this.getCurrentStateNameInternal());
        if (workState != null) {
            List currAssignees = workState.getAssignees();
            WorkState nextState = this.getState(stateName);
            ArrayList<? extends AtsUser> nextAssignees = new ArrayList<AtsUser>(assignees);
            ArrayList<? extends AtsUser> notifyNewAssignees = new ArrayList<AtsUser>(nextAssignees);
            notifyNewAssignees.removeAll(currAssignees);
            if (nextState != null) {
                nextState.setAssignees(nextAssignees);
            }
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER)) {
            this.removeAssignee(this.getCurrentStateNameInternal(), AtsCoreUsers.UNASSIGNED_USER);
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.SYSTEM_USER)) {
            this.removeAssignee(this.getCurrentStateNameInternal(), AtsCoreUsers.SYSTEM_USER);
        }
        this.setDirty(true);
    }

    public void transitionHelper(List<? extends AtsUser> toAssignees, IStateToken fromState, IStateToken toState) {
        this.createState(toState);
        this.setAssignees(toState.getName(), toAssignees);
        this.setCurrentStateName(toState.getName());
        this.setDirty(true);
    }

    public long getTimeInState() {
        return this.getTimeInState(this.getCurrentState());
    }

    public long getTimeInState(IStateToken state) {
        if (state == null) {
            return 0L;
        }
        IAtsLogItem logItem = this.getStateStartedData(state);
        if (logItem == null) {
            return 0L;
        }
        return new Date().getTime() - logItem.getDate().getTime();
    }

    public IAtsLogItem getStateStartedData(IStateToken state) {
        return this.getStateStartedData(state.getName());
    }

    public IAtsLogItem getStateStartedData(String stateName) {
        return this.workItem.getLog().getStateEvent(LogType.StateEntered, stateName);
    }

    public IAtsLogItem getStateCompletedData(IStateToken state) {
        return this.getStateCompletedData(state.getName());
    }

    public IAtsLogItem getStateCompletedData(String stateName) {
        return this.workItem.getLog().getStateEvent(LogType.StateComplete, stateName);
    }

    public void addAssignee(String stateName, AtsUser assignee) {
        this.addAssignees(stateName, Arrays.asList(assignee));
    }

    protected void addState(String name, List<? extends AtsUser> assignees, boolean logError) {
        if (this.getVisitedStateNames().contains(name)) {
            String errorStr = String.format("Error: Duplicate state [%s] for [%s]", name, this.workItem.getAtsId());
            if (logError) {
                OseeLog.log(StateManager.class, (Level)Level.SEVERE, (String)errorStr);
            }
            return;
        }
        this.addState(WorkState.create((String)name, assignees));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public WorkState getState(String string) {
        for (WorkState state : this.states) {
            if (!state.getName().equals(string)) continue;
            return state;
        }
        return null;
    }

    public List<AtsUser> getAssignees(String stateName) {
        return this.getAssigneesForState(stateName);
    }

    public List<AtsUser> getAssigneesForState(String fromStateName) {
        WorkState state = this.getState(fromStateName);
        if (state != null) {
            return state.getAssignees();
        }
        return Collections.emptyList();
    }

    public List<AtsUser> getAssignees() {
        ArrayList<AtsUser> assignees = new ArrayList<AtsUser>();
        WorkState state = this.getState(this.getCurrentStateNameInternal());
        if (state == null) {
            throw new OseeStateException("State not found for %s", new Object[]{this.workItem.toStringWithId()});
        }
        assignees.addAll(state.getAssignees());
        return assignees;
    }

    public void setCurrentStateName(String currentStateName) {
        Conditions.assertNotNull((Object)currentStateName, (String)"currentStateName", (Object[])new Object[0]);
        this.currentStateName = currentStateName;
        this.setDirty(true);
    }

    public void addAssignee(AtsUser assignee) {
        this.addAssignee(this.getCurrentStateNameInternal(), assignee);
    }

    public void addState(String stateName, List<? extends AtsUser> assignees) {
        WorkState state = this.createState(stateName);
        state.setAssignees(assignees);
    }

    public void setAssignees(List<? extends AtsUser> assignees) {
        this.setAssignees(this.getCurrentStateNameInternal(), assignees);
    }

    public WorkState createState(String stateName) {
        WorkState state = this.getState(stateName);
        if (state == null) {
            state = WorkState.create((String)stateName);
            this.addState(state);
        }
        return state;
    }

    public List<String> getVisitedStateNames() {
        return Named.getNames(this.states);
    }

    public void removeAssignee(String stateName, AtsUser assignee) {
        WorkState state = this.getState(stateName);
        if (state == null) {
            throw new OseeStateException("State [%s] not found for %s", new Object[]{stateName, this.workItem.toStringWithId()});
        }
        state.removeAssignee(assignee);
        this.setDirty(true);
    }

    public void setAssignee(IStateToken state, AtsUser assignee) {
        this.setAssignee(state.getName(), assignee);
    }

    public void createState(IStateToken state) {
        this.createState(state.getName());
    }

    public boolean isUnAssignedSolely() {
        return this.getAssignees().size() == 1 && this.isUnAssigned();
    }

    public String getAssigneesStr() {
        return this.getAssigneesStr(this.getCurrentStateNameInternal());
    }

    public void removeAssignee(AtsUser assignee) {
        this.removeAssignee(this.getCurrentStateNameInternal(), assignee);
    }

    public boolean isUnAssigned() {
        return this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER);
    }

    public void clearAssignees() {
        this.setAssignees(this.getCurrentStateNameInternal(), new LinkedList());
    }

    public Collection<AtsUser> getAssignees(IStateToken state) {
        return this.getAssignees(state.getName());
    }

    public boolean isStateVisited(IStateToken state) {
        return this.isStateVisited(state.getName());
    }

    public String getAssigneesStr(int length) {
        return this.getAssigneesStr(this.getCurrentStateNameInternal(), length);
    }

    public String getAssigneesStr(String stateName, int length) {
        String str = this.getAssigneesStr(stateName);
        if (str.length() > length) {
            return String.valueOf(str.substring(0, length - 1)) + "...";
        }
        return str;
    }

    public String getAssigneesStr(String stateName) {
        return AtsObjects.toString("; ", this.getAssignees(stateName));
    }

    public void addAssignees(Collection<? extends AtsUser> assignees) {
        this.addAssignees(this.getCurrentStateNameInternal(), assignees);
    }

    public void setAssignee(String stateName, AtsUser assignee) {
        if (assignee != null) {
            this.setAssignees(stateName, Arrays.asList(assignee));
        }
    }

    public boolean isStateVisited(String stateName) {
        return this.getVisitedStateNames().contains(stateName);
    }

    public void addState(WorkState workState) {
        this.addState(workState, true);
    }

    protected void addState(WorkState state, boolean logError) {
        if (this.getVisitedStateNames().contains(state.getName())) {
            String errorStr = String.format("Error: Duplicate state [%s] for [%s]", state.getName(), this.workItem.getAtsId());
            if (logError) {
                OseeLog.log(StateManager.class, (Level)Level.SEVERE, (String)errorStr);
            }
            return;
        }
        this.states.add(state);
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public List<AtsUser> getInitialAssignees() {
        return this.initialAssignees;
    }

    public List<AtsUser> getAssigneesAdded() {
        ArrayList<AtsUser> added = new ArrayList<AtsUser>();
        List<AtsUser> current = this.getAssignees();
        for (AtsUser user : current) {
            if (this.initialAssignees.contains(user)) continue;
            added.add(user);
        }
        return added;
    }

    public void clear() {
        this.initialAssignees.clear();
        this.states.clear();
        this.currentStateName = null;
    }

    public String toString() {
        return String.format("StateManager id[%s] for workitem [%s]", this.instanceId, this.workItem);
    }

    public boolean isInState(IStateToken state) {
        return this.getCurrentStateNameInternal().equals(state.getName());
    }

    public void setCreatedBy(AtsUser user, boolean logChange, Date date, IAtsChangeSet changes) {
        if (logChange) {
            this.logCreatedByChange(this.workItem, user);
        }
        if (changes == null) {
            if (this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
                this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy, (Object)user.getUserId());
            }
            if (date != null && this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedDate)) {
                this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.CreatedDate, (Object)date);
            }
        } else {
            if (this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
                this.atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy, (Object)user.getUserId());
            }
            if (date != null && this.atsApi.getStoreService().isAttributeTypeValid((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedDate)) {
                changes.setSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedDate, (Object)date);
            }
        }
    }

    public void internalSetCreatedBy(AtsUser user, IAtsChangeSet changes) {
        if (changes.isAttributeTypeValid(this.workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy)) {
            changes.setSoleAttributeValue(this.workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, user.getUserId());
        }
    }

    private void logCreatedByChange(IAtsWorkItem workItem, AtsUser user) {
        if (this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, null) == null) {
            workItem.getLog().addLog(LogType.Originated, "", "", new Date(), user.getUserId());
        } else {
            workItem.getLog().addLog(LogType.Originated, "", "Changed by " + this.atsApi.getUserService().getCurrentUser().getName(), new Date(), user.getUserId());
        }
    }

    public String getCurrentStateNameFast() {
        String currState = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, (Object)"");
        currState = currState.replaceFirst(";.*$", "");
        return currState;
    }
}

