/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class OrganizePrograms {
    private final AtsApi atsApi;
    private final ArtifactTypeToken artifactType;
    private final ArtifactToken folder;

    public OrganizePrograms(AtsApi atsApi) {
        this(atsApi, AtsArtifactTypes.Program, AtsArtifactToken.ProgramFolder);
    }

    public OrganizePrograms(AtsApi atsApi, ArtifactTypeToken artifactType, ArtifactToken folder) {
        this.atsApi = atsApi;
        this.artifactType = artifactType;
        this.folder = folder;
    }

    public XResultData run() {
        XResultData results = new XResultData();
        try {
            IAtsChangeSet changes = this.atsApi.createChangeSet("Organize Programs");
            ArtifactToken programFolder = this.atsApi.getQueryService().getOrCreateArtifact(AtsArtifactToken.AtsTopFolder, this.folder, changes);
            if (programFolder == null || programFolder.isInvalid()) {
                changes.createArtifact(AtsArtifactToken.AtsTopFolder, AtsArtifactToken.ProgramFolder);
            }
            for (ArtifactToken programArt : this.atsApi.getQueryService().getArtifacts(this.artifactType)) {
                if (this.atsApi.getRelationResolver().getChildren((ArtifactId)programFolder).contains(programArt)) continue;
                changes.addChild((ArtifactId)programFolder, (ArtifactId)programArt);
            }
            changes.executeIfNeeded();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }
}

