/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.branch;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class BranchOperationsUtil {
    public static XResultData validateBranchCommit(IAtsTeamWorkflow teamWf, BranchToken commitToBranch, boolean overrideStateValidation, XResultData rd, AtsApi atsApi) {
        if (rd == null) {
            rd = new XResultData();
        }
        rd.logf("Committing %s to destination %s\n\n", new Object[]{teamWf.toStringWithId(), commitToBranch.toStringWithId()});
        BranchToken workingBranch = atsApi.getBranchService().getBranch(teamWf);
        try {
            if (workingBranch.isInvalid()) {
                rd.errorf("Commit Branch Failed: Can not locate branch for workflow [%s]", new Object[]{teamWf.getAtsId()});
                return rd;
            }
            for (IAtsAbstractReview review : atsApi.getReviewService().getReviews(teamWf)) {
                ReviewBlockType blockType = ReviewBlockType.valueOf((String)((String)atsApi.getAttributeResolver().getSoleAttributeValue(review.getArtifactId(), (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, (Object)"None")));
                if (!blockType.isCommit() || review.isCompletedOrCancelled()) continue;
                rd.error("All blocking reviews must be completed before committing the working branch.  Please complete all blocking reviews in order to continue.");
                return rd;
            }
        }
        catch (Exception ex) {
            rd.errorf("Exception committing branch %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }
}

