/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;

public class AgileFolders {
    public static ArtifactId getOrCreateTopSprintFolder(AtsApi atsApi, long teamId, IAtsChangeSet changes) {
        ArtifactId teamFolder = AgileFolders.getTeamFolder(atsApi, teamId);
        ArtifactToken sprintFolder = null;
        for (ArtifactToken child : atsApi.getRelationResolver().getChildren(teamFolder)) {
            if (!child.getName().equals("Sprints")) continue;
            sprintFolder = child;
        }
        if (sprintFolder == null) {
            sprintFolder = changes.createArtifact(CoreArtifactTypes.Folder, "Sprints");
            changes.relate(teamFolder, CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)sprintFolder);
        }
        return sprintFolder;
    }

    public static ArtifactId getTeamFolder(AtsApi atsApi, long teamId) {
        return atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
    }

    public static ArtifactId getOrCreateTopFeatureGroupFolder(AtsApi atsApi, long teamId, ArtifactId artifact, IAtsChangeSet changes) {
        ArtifactId teamFolder = AgileFolders.getTeamFolder(atsApi, teamId);
        ArtifactToken featureGroupFolder = null;
        for (ArtifactToken child : atsApi.getRelationResolver().getChildren(teamFolder)) {
            if (!child.getName().equals("Feature Groups")) continue;
            featureGroupFolder = child;
        }
        if (featureGroupFolder == null) {
            featureGroupFolder = changes.createArtifact(CoreArtifactTypes.Folder, "Feature Groups");
            changes.addChild(teamFolder, (ArtifactId)featureGroupFolder);
        }
        return featureGroupFolder;
    }

    public static ArtifactId getOrCreateTopAgileFolder(AtsApi atsApi, ArtifactId userArt, IAtsChangeSet changes) {
        ArtifactToken agileFolder = atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.TopAgileFolder);
        if (agileFolder == null) {
            agileFolder = changes.createArtifact(AtsArtifactToken.TopAgileFolder);
            ArtifactToken rootArtifact = atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, (BranchId)atsApi.getAtsBranch());
            ArrayList<ArtifactToken> children = new ArrayList<ArtifactToken>();
            children.add(agileFolder);
            children.addAll(atsApi.getRelationResolver().getChildren((ArtifactId)rootArtifact));
            changes.setRelationsAndOrder((Object)rootArtifact, CoreRelationTypes.DefaultHierarchical_Child, children);
        }
        return agileFolder;
    }
}

