/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.mim.types.TransportType;

public class InterfaceConnection
extends PLGenericDBObject {
    public static final InterfaceConnection SENTINEL = new InterfaceConnection();
    private String Description;
    private TransportType TransportType;
    private List<ArtifactId> nodes;
    private ApplicabilityToken applicability;

    public InterfaceConnection(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceConnection(ArtifactReadable art) {
        super(art);
        this.setNodes(art.getRelated(CoreRelationTypes.InterfaceConnectionNode_Node).getList().stream().map(n -> n.getArtifactId()).collect(Collectors.toList()));
        this.setTransportType(new TransportType((ArtifactReadable)art.getRelated(CoreRelationTypes.InterfaceConnectionTransportType_TransportType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)));
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceConnection(Long id, String name) {
        super(id, name);
        this.setNodes(new LinkedList<ArtifactId>());
    }

    public InterfaceConnection() {
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public TransportType getTransportType() {
        return this.TransportType;
    }

    public void setTransportType(TransportType transportType) {
        this.TransportType = transportType;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public List<ArtifactId> getNodes() {
        return this.nodes;
    }

    private void setNodes(List<ArtifactId> nodes) {
        this.nodes = nodes;
    }
}

