/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.internal.PlatformTypeAccessor;
import org.eclipse.osee.mim.types.ArtifactMatch;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfacePlatformTypeApiImpl
implements InterfacePlatformTypeApi {
    private ArtifactAccessor<PlatformTypeToken> accessor;
    private final List<AttributeTypeId> attributes;
    private final List<RelationTypeSide> affectedRelations;

    InterfacePlatformTypeApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new PlatformTypeAccessor(orcsApi));
        this.attributes = this.createAttributeList();
        this.affectedRelations = this.createAffectedRelationTypeSideList();
    }

    @Override
    public ArtifactAccessor<PlatformTypeToken> getAccessor() {
        return this.accessor;
    }

    private List<RelationTypeSide> createAffectedRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceElementPlatformType_PlatformType);
        return relations;
    }

    private void setAccessor(ArtifactAccessor<PlatformTypeToken> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public PlatformTypeToken get(BranchId branch, ArtifactId platformTypeId) {
        if (!platformTypeId.isValid()) {
            return PlatformTypeToken.SENTINEL;
        }
        try {
            return this.getAccessor().get(branch, platformTypeId, Arrays.asList(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet, CoreRelationTypes.InterfaceEnumeration_EnumerationState));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public List<PlatformTypeToken> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public PlatformTypeToken getWithElementRelations(BranchId branch, ArtifactId platformTypeId) {
        try {
            return this.getAccessor().get(branch, platformTypeId, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element), PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithRelations(BranchId branch, ArtifactId platformTypeId, List<RelationTypeSide> relationTypes) {
        try {
            return this.getAccessor().get(branch, platformTypeId, relationTypes, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithAllParentRelations(BranchId branch, ArtifactId platformTypeId) {
        List<RelationTypeSide> relations = Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element, CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection);
        return this.getWithRelations(branch, platformTypeId, relations);
    }

    @Override
    public List<PlatformTypeToken> getAllFromEnumerationSet(InterfaceEnumerationSet enumSet) {
        return enumSet.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new PlatformTypeToken((ArtifactReadable)a)).collect(Collectors.toList());
    }

    @Override
    public List<PlatformTypeToken> getAllWithRelations(BranchId branch, List<RelationTypeSide> relationTypes) {
        return this.getAllWithRelations(branch, relationTypes, 0L, 0L);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithRelations(BranchId branch, String filter, List<RelationTypeSide> relationTypes) {
        return this.getFilteredWithRelations(branch, filter, relationTypes, 0L, 0L);
    }

    @Override
    public List<PlatformTypeToken> getAllWithElementRelations(BranchId branch) {
        return this.getAllWithElementRelations(branch, 0L, 0L);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithElementRelations(BranchId branch, String filter) {
        return this.getFilteredWithElementRelations(branch, filter, 0L, 0L);
    }

    private List<AttributeTypeId> createAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceLogicalType);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformType2sComplement);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeAnalogAccuracy);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeBitSize);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeBitsResolution);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeCompRate);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceDefaultValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementEnumLiteral);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMaxval);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMinval);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMsbValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeUnits);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription);
        return attributes;
    }

    @Override
    public Collection<PlatformTypeToken> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public List<PlatformTypeToken> getAllWithEnumSet(BranchId branch) {
        return this.getAllWithEnumSet(branch, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, this.affectedRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<PlatformTypeToken> queryExact(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, Arrays.asList(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet, CoreRelationTypes.InterfaceEnumeration_EnumerationState), isExact, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public List<PlatformTypeToken> getAllWithRelations(BranchId branch, List<RelationTypeSide> relationTypes, long pageNum, long pageSize) {
        return this.getAllWithRelations(branch, relationTypes, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<PlatformTypeToken> getAllWithEnumSet(BranchId branch, long pageNum, long pageSize) {
        return this.getAllWithEnumSet(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithRelations(BranchId branch, String filter, List<RelationTypeSide> relationTypes, long pageNum, long pageSize) {
        return this.getFilteredWithRelations(branch, filter, relationTypes, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<PlatformTypeToken> getAllWithElementRelations(BranchId branch, long pageNum, long pageSize) {
        return this.getAllWithElementRelations(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithElementRelations(BranchId branch, String filter, long pageNum, long pageSize) {
        return this.getFilteredWithElementRelations(branch, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<PlatformTypeToken> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<PlatformTypeToken> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return (List)this.getAccessor().getAll(branch, pageNum, pageSize, orderByAttribute);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public List<PlatformTypeToken> getAllWithRelations(BranchId branch, List<RelationTypeSide> relationTypes, AttributeTypeId orderByAttribute) {
        return this.getAllWithRelations(branch, relationTypes, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getAllWithRelations(BranchId branch, List<RelationTypeSide> relationTypes, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return (List)this.getAccessor().getAll(branch, relationTypes, pageNum, pageSize, orderByAttribute);
        }
        catch (Exception exception) {
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public List<PlatformTypeToken> getAllWithEnumSet(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAllWithEnumSet(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getAllWithEnumSet(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAllWithRelations(branch, Arrays.asList(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet), pageNum, pageSize, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithRelations(BranchId branch, String filter, List<RelationTypeSide> relationTypes, AttributeTypeId orderByAttribute) {
        return this.getFilteredWithRelations(branch, filter, relationTypes, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithRelations(BranchId branch, String filter, List<RelationTypeSide> relationTypes, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return (List)this.getAccessor().getAllByFilter(branch, filter, this.attributes, relationTypes, pageNum, pageSize, orderByAttribute);
        }
        catch (Exception exception) {
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public List<PlatformTypeToken> getAllWithElementRelations(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAllWithElementRelations(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithElementRelations(BranchId branch, String filter, AttributeTypeId orderByAttribute) {
        return this.getFilteredWithElementRelations(branch, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getAllWithElementRelations(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAllWithRelations(branch, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element, CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection), pageNum, pageSize, orderByAttribute);
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithElementRelations(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getFilteredWithRelations(branch, filter, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element, CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection), pageNum, pageSize, orderByAttribute);
    }

    @Override
    public String getUniqueIdentifier(String logicalType, String min, String max, String validRange, String units, String defaultValue, int bytes) {
        if (logicalType.equals("boolean")) {
            return "boolean";
        }
        String identifier = "";
        switch (logicalType) {
            case "character": {
                identifier = String.valueOf(identifier) + "Char";
                break;
            }
            case "double": {
                identifier = String.valueOf(identifier) + "Double";
                break;
            }
            case "float": {
                identifier = String.valueOf(identifier) + "Float";
                break;
            }
            case "sInteger": {
                identifier = String.valueOf(identifier) + "SInt";
                break;
            }
            case "sShort": {
                identifier = String.valueOf(identifier) + "SShort";
                break;
            }
            case "uInteger": {
                identifier = String.valueOf(identifier) + "UInt";
                break;
            }
            case "uLong": {
                identifier = String.valueOf(identifier) + "ULong";
                break;
            }
            case "uShort": {
                identifier = String.valueOf(identifier) + "UShort";
                break;
            }
            default: {
                identifier = String.valueOf(identifier) + "Unknown";
            }
        }
        if (!units.isEmpty()) {
            identifier = String.valueOf(identifier) + "_" + units;
        }
        if (!min.isEmpty()) {
            identifier = String.valueOf(identifier) + "_" + min;
        }
        if (!max.isEmpty()) {
            identifier = String.valueOf(identifier) + "_" + max;
        }
        if (!validRange.isEmpty()) {
            identifier = String.valueOf(identifier) + "_" + validRange;
        }
        if (!defaultValue.isEmpty()) {
            identifier = String.valueOf(identifier) + "_" + defaultValue;
        }
        identifier = String.valueOf(identifier) + "_" + bytes;
        return identifier;
    }
}

