/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.AffectedArtifactEndpoint;
import org.eclipse.osee.mim.CrossReferenceEndpoint;
import org.eclipse.osee.mim.EnumerationSetEndpoint;
import org.eclipse.osee.mim.GetAllMIMRelatedObjectsEndpoint;
import org.eclipse.osee.mim.IcdEndpoint;
import org.eclipse.osee.mim.InterfaceConnectionEndpoint;
import org.eclipse.osee.mim.InterfaceDifferenceReportEndpoint;
import org.eclipse.osee.mim.InterfaceElementEndpoint;
import org.eclipse.osee.mim.InterfaceElementSearchEndpoint;
import org.eclipse.osee.mim.InterfaceGraphEndpoint;
import org.eclipse.osee.mim.InterfaceMessageEndpoint;
import org.eclipse.osee.mim.InterfaceNodeEndpoint;
import org.eclipse.osee.mim.InterfaceStructureCountEndpoint;
import org.eclipse.osee.mim.InterfaceStructureEndpoint;
import org.eclipse.osee.mim.InterfaceStructureSearchEndpoint;
import org.eclipse.osee.mim.InterfaceSubMessageEndpoint;
import org.eclipse.osee.mim.InterfaceSubMessageFilterEndpoint;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.PlatformTypesEndpoint;
import org.eclipse.osee.mim.PlatformTypesFilterEndpoint;
import org.eclipse.osee.mim.QueryMIMResourcesEndpoint;
import org.eclipse.osee.mim.TransportTypeEndpoint;
import org.eclipse.osee.mim.internal.AffectedArtifactEndpointImpl;
import org.eclipse.osee.mim.internal.CrossReferenceEndpointImpl;
import org.eclipse.osee.mim.internal.EnumerationSetEndpointImpl;
import org.eclipse.osee.mim.internal.GetAllMIMRelatedObjectsEndpointImpl;
import org.eclipse.osee.mim.internal.IcdEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceConnectionEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceDifferenceReportEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceElementEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceElementSearchEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceGraphEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceMessageEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceNodeEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceStructureCountEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceStructureEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceStructureSearchEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceSubMessageEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceSubMessageFilterEndpointImpl;
import org.eclipse.osee.mim.internal.PlatformTypesEndpointImpl;
import org.eclipse.osee.mim.internal.PlatformTypesFilterEndpointImpl;
import org.eclipse.osee.mim.internal.QueryMIMResourcesEndpointImpl;
import org.eclipse.osee.mim.internal.TransportTypeEndpointImpl;

@Path(value="branch")
public class BranchAccessor {
    private final MimApi mimApi;

    public BranchAccessor(MimApi mimApi) {
        this.mimApi = mimApi;
    }

    @Path(value="{branch}/types")
    @Produces(value={"application/json"})
    public PlatformTypesEndpoint getPlatformTypes(@PathParam(value="branch") BranchId branch) {
        return new PlatformTypesEndpointImpl(branch, this.mimApi.getInterfacePlatformTypeApi(), this.mimApi.getInterfaceEnumerationSetApi(), this.mimApi.getInterfaceEnumerationApi());
    }

    @Path(value="{branch}/types/filter")
    @Produces(value={"application/json"})
    public PlatformTypesFilterEndpoint getPlatformTypesFilter(@PathParam(value="branch") BranchId branch) {
        return new PlatformTypesFilterEndpointImpl(branch, this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages")
    @Produces(value={"application/json"})
    public InterfaceMessageEndpoint getMessageEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId) {
        return new InterfaceMessageEndpointImpl(branch, connectionId, this.mimApi.getInterfaceMessageApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages")
    @Produces(value={"application/json"})
    public InterfaceSubMessageEndpoint getSubMessageEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId) {
        return new InterfaceSubMessageEndpointImpl(branch, messageId, this.mimApi.getInterfaceSubMessageApi());
    }

    @Path(value="{branch}/submessages/filter")
    @Produces(value={"application/json"})
    public InterfaceSubMessageFilterEndpoint getSubMessageFilterEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceSubMessageFilterEndpointImpl(branch, this.mimApi.getInterfaceSubMessageApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages/{submessageId}/structures")
    @Produces(value={"application/json"})
    public InterfaceStructureEndpoint getStructureEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @PathParam(value="submessageId") ArtifactId subMessageId) {
        return new InterfaceStructureEndpointImpl(branch, connectionId, messageId, subMessageId, this.mimApi.getInterfaceStructureApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages/{submessageId}/structures/count")
    @Produces(value={"application/json"})
    public InterfaceStructureCountEndpoint getStructureCountEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @PathParam(value="submessageId") ArtifactId subMessageId) {
        return new InterfaceStructureCountEndpointImpl(branch, messageId, subMessageId, this.mimApi.getInterfaceStructureApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages/{submessageId}/structures/{structureId}/elements")
    @Produces(value={"application/json"})
    public InterfaceElementEndpoint getElementEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @PathParam(value="submessageId") ArtifactId subMessageId, @PathParam(value="structureId") ArtifactId structureId) {
        return new InterfaceElementEndpointImpl(branch, messageId, subMessageId, structureId, this.mimApi.getInterfaceElementApi());
    }

    @Path(value="{branch}/elements")
    @Produces(value={"application/json"})
    public InterfaceElementSearchEndpoint getElementSearchEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceElementSearchEndpointImpl(branch, this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/structures")
    @Produces(value={"application/json"})
    public InterfaceStructureSearchEndpoint getStructureSearchEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceStructureSearchEndpointImpl(branch, this.mimApi.getInterfaceStructureApi());
    }

    @Path(value="{branch}/graph")
    @Produces(value={"application/json"})
    public InterfaceGraphEndpoint getGraphEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceGraphEndpointImpl(branch, this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi());
    }

    @Path(value="{branch}/nodes")
    @Produces(value={"application/json"})
    public InterfaceNodeEndpoint getNodeEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceNodeEndpointImpl(branch, this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi());
    }

    @Path(value="{branch}/connections")
    @Produces(value={"application/json"})
    public InterfaceConnectionEndpoint getConnectionEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceConnectionEndpointImpl(branch, this.mimApi.getInterfaceConnectionViewApi());
    }

    @Path(value="{branch}/enumerations")
    @Produces(value={"application/json"})
    public EnumerationSetEndpoint getEnumerationSetEndpoint(@PathParam(value="branch") BranchId branch) {
        return new EnumerationSetEndpointImpl(branch, this.mimApi.getInterfaceEnumerationSetApi());
    }

    @Path(value="{branch}/all")
    @Produces(value={"application/json"})
    public GetAllMIMRelatedObjectsEndpoint getRelated(@PathParam(value="branch") BranchId branch) {
        return new GetAllMIMRelatedObjectsEndpointImpl(branch, this.mimApi.getInterfaceStructureApi(), this.mimApi.getInterfaceMessageApi(), this.mimApi.getInterfaceSubMessageApi(), this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi(), this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/query")
    @Produces(value={"application/json"})
    public QueryMIMResourcesEndpoint getQueryEndpoint(@PathParam(value="branch") BranchId branch) {
        return new QueryMIMResourcesEndpointImpl(branch, this.mimApi.getInterfaceConnectionViewApi(), this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceMessageApi(), this.mimApi.getInterfaceSubMessageApi(), this.mimApi.getInterfaceStructureApi(), this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi(), this.mimApi.getInterfaceEnumerationApi(), this.mimApi.getInterfaceEnumerationSetApi());
    }

    @Path(value="{branch}/diff")
    @Produces(value={"application/json"})
    public InterfaceDifferenceReportEndpoint getDifferencesEndpoint(@PathParam(value="branch") BranchId branch) {
        return new InterfaceDifferenceReportEndpointImpl(branch, this.mimApi.getInterfaceDifferenceReportApi());
    }

    @Path(value="{branch}/affected")
    @Produces(value={"application/json"})
    public AffectedArtifactEndpoint getAffectedArtifacts(@PathParam(value="branch") BranchId branch) {
        return new AffectedArtifactEndpointImpl(branch, this.mimApi.getInterfaceConnectionViewApi(), this.mimApi.getInterfaceMessageApi(), this.mimApi.getInterfaceSubMessageApi(), this.mimApi.getInterfaceStructureApi(), this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfacePlatformTypeApi(), this.mimApi.getInterfaceEnumerationSetApi(), this.mimApi.getInterfaceEnumerationApi());
    }

    @Path(value="{branch}/transportTypes")
    @Produces(value={"application/json"})
    public TransportTypeEndpoint getTransportTypeEndpoint(@PathParam(value="branch") BranchId branch) {
        return new TransportTypeEndpointImpl(branch, this.mimApi.getTransportTypeApi());
    }

    @Path(value="{branch}/crossReference")
    @Produces(value={"application/json"})
    public CrossReferenceEndpoint getCrossReferenceEndpoint(@PathParam(value="branch") BranchId branch) {
        return new CrossReferenceEndpointImpl(branch, this.mimApi.getCrossReferenceApi());
    }

    @Path(value="{branch}/view/{viewId}/icd/{id}")
    @Produces(value={"application/xml"})
    public IcdEndpoint getIcd(@PathParam(value="branch") BranchId branch, @PathParam(value="viewId") ArtifactId viewId, @PathParam(value="id") ArtifactId connectionId) {
        return new IcdEndpointImpl(branch, viewId, connectionId, this.mimApi);
    }

    @Path(value="{branch}/icd/{id}")
    @Produces(value={"application/xml"})
    public IcdEndpoint getIcd(@PathParam(value="branch") BranchId branch, @PathParam(value="id") ArtifactId connectionId) {
        return new IcdEndpointImpl(branch, ArtifactId.SENTINEL, connectionId, this.mimApi);
    }
}

