/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public class SimpleNamespaceContext
implements NamespaceContext {
    private final Map<String, String> urisByPrefix = new HashMap<String, String>();
    private final Map<String, Set<String>> prefixesByURI = new HashMap<String, Set<String>>();

    public SimpleNamespaceContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.addNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public synchronized void addNamespace(String prefix, String namespaceURI) {
        this.urisByPrefix.put(prefix, namespaceURI);
        if (this.prefixesByURI.containsKey(namespaceURI)) {
            this.prefixesByURI.get(namespaceURI).add(prefix);
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(prefix);
            this.prefixesByURI.put(namespaceURI, set);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        if (this.urisByPrefix.containsKey(prefix)) {
            return this.urisByPrefix.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.getPrefixes(namespaceURI).next();
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI cannot be null");
        }
        if (this.prefixesByURI.containsKey(namespaceURI)) {
            return this.prefixesByURI.get(namespaceURI).iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }
}

